/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server;

import java.util.List;
import javax.enterprise.event.Event;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.ScenarioRunnerServiceImpl;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.AbstractScenarioRunner;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.RuleScenarioRunner;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.RULESimulationCreationStrategy;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.test.Failure;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.KieContainer;
import org.kie.workbench.common.services.backend.builder.service.BuildInfo;
import org.kie.workbench.common.services.backend.builder.service.BuildInfoService;
import org.kie.workbench.common.services.backend.project.ModuleClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieModule;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ScenarioRunnerServiceImplTest {
    @Mock
    private EventSourceMock<TestResultMessage> defaultTestResultMessageEventMock;
    @Mock
    private AbstractScenarioRunner runnerMock;
    @Mock
    private KieModuleService moduleServiceMock;
    @Mock
    private BuildInfoService buildInfoServiceMock;
    @Mock
    private BuildInfo buildInfoMock;
    @Mock
    private KieContainer kieContainerMock;
    @Mock
    private ModuleClassLoaderHelper classLoaderHelperMock;
    @Captor
    private ArgumentCaptor<TestResultMessage> testResultMessageArgumentCaptor;
    @InjectMocks
    private ScenarioRunnerServiceImpl scenarioRunnerService = new ScenarioRunnerServiceImpl();
    private Path path = PathFactory.newPath((String)"contextpath", (String)"file:///contextpath");

    @Before
    public void setup() {
        Mockito.when((Object)this.classLoaderHelperMock.getModuleClassLoader((KieModule)Matchers.any())).thenReturn((Object)ClassLoader.getSystemClassLoader());
    }

    @Test
    public void runAllTests() throws Exception {
        this.scenarioRunnerService.runAllTests("test", (Path)Mockito.mock(Path.class));
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEventMock)).fire(Matchers.any());
    }

    @Test
    public void runTest() throws Exception {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn((Object)this.kieContainerMock);
        ScenarioSimulationModel scenarioSimulationModel = new ScenarioSimulationModel();
        scenarioSimulationModel.setSimulation(new RULESimulationCreationStrategy().createSimulation(this.path, "default"));
        this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), scenarioSimulationModel);
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEventMock)).fire(Matchers.any());
    }

    @Test
    public void runAllTestsSpecifiedEvent() throws Exception {
        EventSourceMock customTestResultEvent = (EventSourceMock)Mockito.mock(EventSourceMock.class);
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, simulation) -> this.runnerMock);
        this.scenarioRunnerService.runAllTests("test", (Path)Mockito.mock(Path.class), (Event)customTestResultEvent);
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEventMock, (VerificationMode)Mockito.never())).fire(Matchers.any());
        ((EventSourceMock)Mockito.verify((Object)customTestResultEvent)).fire(Matchers.any());
    }

    @Test
    public void runFailed() throws Exception {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn((Object)this.kieContainerMock);
        ScenarioSimulationModel scenarioSimulationModel = new ScenarioSimulationModel();
        scenarioSimulationModel.setSimulation(new RULESimulationCreationStrategy().createSimulation(this.path, "default"));
        Scenario scenario = scenarioSimulationModel.getSimulation().getScenarioByIndex(0);
        scenario.setDescription("Test Scenario");
        final String errorMessage = "Test Error";
        this.scenarioRunnerService.setRunnerSupplier((kieContainer, simulation) -> new RuleScenarioRunner((KieContainer)kieContainer, (Simulation)simulation, ""){

            protected void internalRunScenario(Scenario scenario, ScenarioRunnerData scenarioRunnerData) {
                throw new ScenarioException(errorMessage);
            }
        });
        this.scenarioRunnerService.runTest("test", (Path)Mockito.mock(Path.class), scenarioSimulationModel);
        ((EventSourceMock)Mockito.verify(this.defaultTestResultMessageEventMock, (VerificationMode)Mockito.times((int)1))).fire(this.testResultMessageArgumentCaptor.capture());
        TestResultMessage value = (TestResultMessage)this.testResultMessageArgumentCaptor.getValue();
        List failures = value.getFailures();
        Assert.assertEquals((long)1L, (long)failures.size());
        String testDescription = String.format("#%d: %s", 1, scenario.getDescription());
        String errorMessageFormatted = String.format("#%d: %s()", 1, errorMessage);
        Failure failure = (Failure)failures.get(0);
        Assert.assertEquals((Object)errorMessageFormatted, (Object)failure.getMessage());
        Assert.assertEquals((long)1L, (long)value.getRunCount());
        Assert.assertTrue((boolean)failure.getDisplayName().startsWith(testDescription));
    }

    @Test
    public void kieContainerTest() {
        Mockito.when((Object)this.buildInfoServiceMock.getBuildInfo((Module)Matchers.any())).thenReturn((Object)this.buildInfoMock);
        Mockito.when((Object)this.buildInfoMock.getKieContainer()).thenReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.scenarioRunnerService.getKieContainer((Path)Mockito.mock(Path.class))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Retrieving KieContainer has failed. Fix all compilation errors within the project and build the project again.");
    }
}

