/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.expression;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.DMNFeelExpressionEvaluator;
import org.junit.Assert;
import org.junit.Test;

public class DMNFeelExpressionEvaluatorTest {
    DMNFeelExpressionEvaluator expressionEvaluator = new DMNFeelExpressionEvaluator(this.getClass().getClassLoader());

    @Test
    public void evaluate() {
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluate((Object)"not( true )", (Object)false, Boolean.TYPE));
        Assert.assertTrue((boolean)this.expressionEvaluator.evaluate((Object)">2, >5", (Object)BigDecimal.valueOf(6L), BigDecimal.class));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluate(new Object(), null, Object.class)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Raw expression should be a string");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.expressionEvaluator.evaluate((Object)"! true", null, null)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Impossible to parse the expression '! true'");
    }

    @Test
    public void getValueForGiven() {
        Assert.assertEquals((Object)BigDecimal.valueOf(5L), (Object)this.expressionEvaluator.getValueForGiven(BigDecimal.class.getCanonicalName(), null, (Object)"2 + 3"));
        Object nonStringObject = new Object();
        Assert.assertEquals((Object)nonStringObject, (Object)this.expressionEvaluator.getValueForGiven("class", null, nonStringObject));
    }

    @Test
    public void expressionTest() {
        String listJsonString = "[{\"name\": \"\\\"John\\\"\"}, {\"name\": \"\\\"John\\\"\", \"names\" : [{\"value\": \"\\\"Anna\\\"\"}, {\"value\": \"\\\"Mario\\\"\"}]}]";
        List parsedValue = (List)this.expressionEvaluator.convertResult(listJsonString, List.class.getCanonicalName(), Collections.singletonList(Map.class.getCanonicalName()));
        Assert.assertEquals((long)2L, (long)parsedValue.size());
        Assert.assertEquals((long)2L, (long)((List)((Map)parsedValue.get(1)).get("names")).size());
        Assert.assertTrue((boolean)((List)((Map)parsedValue.get(1)).get("names")).contains("Anna"));
        String mapJsonString = "{\"first\": {\"name\": \"\\\"John\\\"\"}}";
        Map parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", ((Map)parsedMap.get("first")).get("name"));
        mapJsonString = "{\"first\": {\"siblings\": [{\"name\" : \"\\\"John\\\"\"}]}}";
        parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)"John", ((Map)((List)((Map)parsedMap.get("first")).get("siblings")).get(0)).get("name"));
        mapJsonString = "{\"first\": {\"phones\": {\"number\" : \"1\"}}}";
        parsedMap = (Map)this.expressionEvaluator.convertResult(mapJsonString, Map.class.getCanonicalName(), Arrays.asList(String.class.getCanonicalName(), Object.class.getCanonicalName()));
        Assert.assertEquals((long)1L, (long)parsedMap.size());
        Assert.assertEquals((Object)BigDecimal.valueOf(1L), ((Map)((Map)parsedMap.get("first")).get("phones")).get("number"));
    }
}

