/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.runner;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.DMNFeelExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.expression.ExpressionEvaluator;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Dispute;
import org.drools.workbench.screens.scenariosimulation.backend.server.model.Person;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.DMNScenarioRunnerHelper;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.RuleScenarioRunnerHelperTest;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.ScenarioException;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioExpect;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioResult;
import org.drools.workbench.screens.scenariosimulation.backend.server.runner.model.ScenarioRunnerData;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.runtime.RequestContext;
import org.kie.dmn.api.core.DMNDecisionResult;
import org.kie.dmn.api.core.DMNResult;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNScenarioRunnerHelperTest {
    @Mock
    RequestContext requestContext;
    @Mock
    DMNResult dmnResult;
    @Mock
    DMNDecisionResult dmnDecisionResult;
    private static final String NAME = "NAME";
    private static final String FEEL_EXPRESSION_NAME = "\"NAME\"";
    private static final BigDecimal AMOUNT = BigDecimal.valueOf(10L);
    private static final String TEST_DESCRIPTION = "Test description";
    private static final ClassLoader classLoader = RuleScenarioRunnerHelperTest.class.getClassLoader();
    private static final ExpressionEvaluator expressionEvaluator = new DMNFeelExpressionEvaluator(classLoader);
    private static final DMNScenarioRunnerHelper runnerHelper = new DMNScenarioRunnerHelper();
    private Simulation simulation;
    private FactIdentifier personFactIdentifier;
    private ExpressionIdentifier firstNameGivenExpressionIdentifier;
    private FactMapping firstNameGivenFactMapping;
    private Scenario scenario1;
    private Scenario scenario2;
    private ExpressionIdentifier firstNameExpectedExpressionIdentifier;
    private FactMapping firstNameExpectedFactMapping;
    private FactIdentifier disputeFactIdentifier;
    private ExpressionIdentifier amountGivenExpressionIdentifier;
    private FactMapping amountNameGivenFactMapping;
    private ExpressionIdentifier amountExpectedExpressionIdentifier;
    private FactMapping amountNameExpectedFactMapping;
    private FactMappingValue amountNameExpectedFactMappingValue;
    private FactMappingValue firstNameExpectedValue;

    @Before
    public void init() {
        this.simulation = new Simulation();
        this.personFactIdentifier = FactIdentifier.create((String)"Fact 1", (String)Person.class.getCanonicalName());
        this.firstNameGivenExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Given", (FactMappingType)FactMappingType.GIVEN);
        this.firstNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier);
        this.firstNameGivenFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameGivenFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.disputeFactIdentifier = FactIdentifier.create((String)"Fact 2", (String)Dispute.class.getCanonicalName());
        this.amountGivenExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Given", (FactMappingType)FactMappingType.GIVEN);
        this.amountNameGivenFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier);
        this.amountNameGivenFactMapping.addExpressionElement("Fact 2", BigDecimal.class.getCanonicalName());
        this.amountNameGivenFactMapping.addExpressionElement("amount", BigDecimal.class.getCanonicalName());
        this.firstNameExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"First Name Expected", (FactMappingType)FactMappingType.EXPECT);
        this.firstNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier);
        this.firstNameExpectedFactMapping.addExpressionElement("Fact 1", String.class.getCanonicalName());
        this.firstNameExpectedFactMapping.addExpressionElement("firstName", String.class.getCanonicalName());
        this.amountExpectedExpressionIdentifier = ExpressionIdentifier.create((String)"Amount Expected", (FactMappingType)FactMappingType.EXPECT);
        this.amountNameExpectedFactMapping = this.simulation.getSimulationDescriptor().addFactMapping(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier);
        this.amountNameExpectedFactMapping.addExpressionElement("Fact 2", Double.class.getCanonicalName());
        this.amountNameExpectedFactMapping.addExpressionElement("amount", Double.class.getCanonicalName());
        this.scenario1 = this.simulation.addScenario();
        this.scenario1.setDescription(TEST_DESCRIPTION);
        this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.firstNameExpectedValue = this.scenario1.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2 = this.simulation.addScenario();
        this.scenario2.setDescription(TEST_DESCRIPTION);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameGivenExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.personFactIdentifier, this.firstNameExpectedExpressionIdentifier, (Object)FEEL_EXPRESSION_NAME);
        this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountGivenExpressionIdentifier, (Object)AMOUNT);
        this.amountNameExpectedFactMappingValue = this.scenario2.addMappingValue(this.disputeFactIdentifier, this.amountExpectedExpressionIdentifier, (Object)AMOUNT);
    }

    @Test
    public void verifyConditions() {
        Mockito.when((Object)this.requestContext.getOutput(Mockito.anyString())).thenReturn((Object)this.dmnResult);
        ScenarioRunnerData scenarioRunnerData = new ScenarioRunnerData();
        scenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData, expressionEvaluator, this.requestContext)).isInstanceOf(ScenarioException.class)).hasMessage("DMN execution has not generated a decision result with name Fact 1");
        Mockito.when((Object)this.dmnResult.getDecisionResultByName(Mockito.anyString())).thenReturn((Object)this.dmnDecisionResult);
        Mockito.when((Object)this.dmnDecisionResult.getEvaluationStatus()).thenReturn((Object)DMNDecisionResult.DecisionEvaluationStatus.SUCCEEDED);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData, expressionEvaluator, this.requestContext)).isInstanceOf(ScenarioException.class)).hasMessage("Wrong resultRaw structure because it is not a complex type as expected");
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("firstName", "WrongValue");
        Mockito.when((Object)this.dmnDecisionResult.getResult()).thenReturn(resultMap);
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), scenarioRunnerData, expressionEvaluator, this.requestContext);
        Assert.assertEquals((long)1L, (long)scenarioRunnerData.getResults().size());
        Assert.assertFalse((boolean)((ScenarioResult)scenarioRunnerData.getResults().get(0)).getResult());
        ScenarioRunnerData newScenarioRunnerData = new ScenarioRunnerData();
        newScenarioRunnerData.addExpect(new ScenarioExpect(this.personFactIdentifier, Collections.singletonList(this.firstNameExpectedValue)));
        resultMap.put("firstName", NAME);
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), newScenarioRunnerData, expressionEvaluator, this.requestContext);
        Assert.assertEquals((long)1L, (long)newScenarioRunnerData.getResults().size());
        Assert.assertTrue((boolean)((ScenarioResult)newScenarioRunnerData.getResults().get(0)).getResult());
        runnerHelper.verifyConditions(this.simulation.getSimulationDescriptor(), newScenarioRunnerData, (ExpressionEvaluator)Mockito.mock(ExpressionEvaluator.class), this.requestContext);
        Assert.assertTrue((boolean)((ScenarioResult)newScenarioRunnerData.getResults().get(0)).getFactMappingValue().isError());
    }

    @Test
    public void createObject() {
        HashMap<List<String>, Object> params = new HashMap<List<String>, Object>();
        params.put(Arrays.asList("creator", "name"), "TestName");
        params.put(Arrays.asList("creator", "surname"), "TestSurname");
        params.put(Collections.singletonList("age"), BigDecimal.valueOf(10L));
        Object objectRaw = runnerHelper.createObject(String.class.getCanonicalName(), params, this.getClass().getClassLoader());
        Assert.assertTrue((boolean)(objectRaw instanceof Map));
        Map object = (Map)objectRaw;
        Assert.assertEquals((Object)BigDecimal.valueOf(10L), object.get("age"));
        Assert.assertTrue((boolean)(object.get("creator") instanceof Map));
        Map creator = (Map)object.get("creator");
        Assert.assertEquals((Object)"TestName", creator.get("name"));
        Assert.assertEquals((Object)"TestSurname", creator.get("surname"));
    }
}

