/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.util;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.drools.workbench.screens.scenariosimulation.backend.server.util.DMNSimulationUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.io.Resource;
import org.kie.dmn.api.core.DMNModel;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DMNSimulationUtilsTest {
    @Test
    public void findDMNModel() {
        List<String> pathToFind = Arrays.asList(new StringBuilder("to/find").reverse().toString().split("/"));
        List models = Stream.of("this/should/not/match", "find", "something/to/find").map(this::createDMNModelMock).collect(Collectors.toList());
        DMNSimulationUtils.findDMNModel(models, pathToFind, (int)1);
        List<String> impossibleToFind = Arrays.asList(new StringBuilder("not/find").reverse().toString().split("/"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> DMNSimulationUtils.findDMNModel((List)models, (List)impossibleToFind, (int)1)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Retrieving the DMNModel has failed. Make sure the used DMN asset does not produce any compilation errors and that the project does not contain multiple DMN assets with the same name and namespace. After addressing the issues, build the project again.");
    }

    private DMNModel createDMNModelMock(String path) {
        DMNModel modelMock = (DMNModel)Mockito.mock(DMNModel.class);
        Resource resourceMock = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)resourceMock.getSourcePath()).thenReturn((Object)path);
        Mockito.when((Object)modelMock.getResource()).thenReturn((Object)resourceMock);
        return modelMock;
    }
}

