/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.backend.server.importexport;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.scenariosimulation.api.model.FactMappingType;
import org.drools.scenariosimulation.api.model.FactMappingValue;
import org.drools.scenariosimulation.api.model.Scenario;
import org.drools.scenariosimulation.api.model.Simulation;

public class ScenarioCsvImportExport {
    public static int HEADER_SIZE = 3;

    public String exportData(Simulation simulation) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        List factMappings = simulation.getSimulationDescriptor().getUnmodifiableFactMappings();
        CSVPrinter printer = new CSVPrinter((Appendable)stringBuilder, CSVFormat.DEFAULT);
        this.generateHeader(factMappings, printer);
        for (Scenario scenario : simulation.getUnmodifiableScenarios()) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (FactMapping factMapping : factMappings) {
                Optional factMappingValue = scenario.getFactMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier());
                values.add(factMappingValue.map(FactMappingValue::getRawValue).orElse(""));
            }
            printer.printRecord(values.toArray());
        }
        printer.close();
        return stringBuilder.toString();
    }

    public Simulation importData(String raw, Simulation originalSimulation) throws IOException {
        CSVParser csvParser = CSVFormat.DEFAULT.parse((Reader)new StringReader(raw));
        Simulation toReturn = originalSimulation.cloneSimulation();
        toReturn.clearScenarios();
        List factMappings = toReturn.getSimulationDescriptor().getUnmodifiableFactMappings();
        List csvRecords = csvParser.getRecords();
        if (csvRecords.size() < HEADER_SIZE) {
            throw new IllegalArgumentException("Malformed file, missing header");
        }
        csvRecords = csvRecords.subList(HEADER_SIZE, csvRecords.size());
        for (CSVRecord csvRecord : csvRecords) {
            Scenario scenarioToFill = toReturn.addScenario();
            if (csvRecord.size() != factMappings.size()) {
                throw new IllegalArgumentException("Malformed row " + csvRecord);
            }
            for (int i = 0; i < factMappings.size(); ++i) {
                FactMapping factMapping = (FactMapping)factMappings.get(i);
                String valueToImport = "".equals(csvRecord.get(i)) ? null : csvRecord.get(i);
                scenarioToFill.addMappingValue(factMapping.getFactIdentifier(), factMapping.getExpressionIdentifier(), (Object)valueToImport);
            }
        }
        return toReturn;
    }

    protected void generateHeader(List<FactMapping> factMappings, CSVPrinter printer) throws IOException {
        ArrayList<String> firstLineHeader = new ArrayList<String>();
        ArrayList<String> secondLineHeader = new ArrayList<String>();
        ArrayList<String> thirdLineHeader = new ArrayList<String>();
        for (FactMapping factMapping : factMappings) {
            if (FactMappingType.OTHER.equals((Object)factMapping.getExpressionIdentifier().getType())) {
                String factAlias = factMapping.getFactAlias();
                firstLineHeader.add(factAlias);
                secondLineHeader.add(factAlias);
                thirdLineHeader.add(factAlias);
                continue;
            }
            firstLineHeader.add(factMapping.getExpressionIdentifier().getType().name());
            secondLineHeader.add("#".equals(factMapping.getFactAlias()) ? "" : factMapping.getFactAlias());
            thirdLineHeader.add(factMapping.getExpressionAlias());
        }
        printer.printRecord(firstLineHeader.toArray());
        printer.printRecord(secondLineHeader.toArray());
        printer.printRecord(thirdLineHeader.toArray());
    }
}

