/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Widget;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.editor.RunScenarioMenuItem;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioSimulationViewProvider;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.workbench.model.menu.MenuItem;

public class ScenarioSimulationViewImpl
extends KieEditorViewImpl
implements ScenarioSimulationView {
    private ScenarioGridPanel scenarioGridPanel;
    private ScenarioSimulationEditorPresenter presenter;
    @Inject
    private ScenarioGridLayer scenarioGridLayer;
    @Inject
    private GridContextMenu gridContextMenu;
    @Inject
    private HeaderContextMenu headerContextMenu;
    private HandlerRegistration clickHandlerRegistration;

    @Override
    public void init(ScenarioSimulationEditorPresenter presenter) {
        this.presenter = presenter;
        this.scenarioGridPanel = ScenarioSimulationViewProvider.newScenarioGridPanel(this.scenarioGridLayer);
        this.clickHandlerRegistration = this.scenarioGridPanel.addClickHandler(new ScenarioSimulationGridPanelClickHandler(this.scenarioGridPanel.getScenarioGrid(), this.gridContextMenu, this.headerContextMenu));
        this.scenarioGridLayer.enterPinnedMode((GridWidget)this.scenarioGridLayer.getScenarioGrid(), () -> {});
        this.initWidget((Widget)this.scenarioGridPanel);
    }

    @Override
    public void setContent(Simulation simulation) {
        this.scenarioGridPanel.getScenarioGrid().setContent(simulation);
    }

    @Override
    public void clear() {
        if (this.clickHandlerRegistration != null) {
            this.clickHandlerRegistration.removeHandler();
        }
    }

    @Override
    public void addGridMenuItem(String id, String label, String i18n, Command command) {
        this.gridContextMenu.addMenuItem(id, label, i18n, command);
    }

    @Override
    public void addHeaderMenuItem(String id, String label, String i18n, Command command) {
        this.headerContextMenu.addMenuItem(id, label, i18n, command);
    }

    @Override
    public MenuItem getRunScenarioMenuItem() {
        return new RunScenarioMenuItem(ScenarioSimulationEditorConstants.INSTANCE.runScenarioSimulation(), new Command(){

            public void execute() {
                ScenarioSimulationViewImpl.this.presenter.onRunScenario();
            }
        });
    }
}

