/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridData;

public class ScenarioGridModel
extends BaseGridData {
    private Simulation simulation;

    public ScenarioGridModel() {
    }

    public ScenarioGridModel(boolean isMerged) {
        super(isMerged);
    }

    public void bindContent(Simulation simulation) {
        this.simulation = simulation;
        this.checkSimulation();
    }

    public void appendColumn(GridColumn<?> column) {
        String title;
        this.checkSimulation();
        super.appendColumn(column);
        SimulationDescriptor simulationDescriptor = this.simulation.getSimulationDescriptor();
        String columnId = title = ((GridColumn.HeaderMetaData)column.getHeaderMetaData().get(0)).getTitle();
        FactIdentifier factIdentifier = FactIdentifier.create((String)columnId, (String)String.class.getCanonicalName());
        int columnIndex = this.getColumnCount() - 1;
        ExpressionIdentifier ei = ExpressionIdentifier.create((String)columnId, (FactMappingType)FactMappingType.GIVEN);
        simulationDescriptor.addFactMapping(columnIndex, title, factIdentifier, ei);
    }

    public GridData.Range setCell(int rowIndex, int columnIndex, Supplier<GridCell<?>> cellSupplier) {
        this.checkSimulation();
        GridData.Range toReturn = super.setCell(rowIndex, columnIndex, cellSupplier);
        Optional<?> optionalValue = this.getCellValue(this.getCell(rowIndex, columnIndex));
        if (!optionalValue.isPresent()) {
            return toReturn;
        }
        Object rawValue = optionalValue.get();
        if (rawValue instanceof String) {
            String cellValue = (String)rawValue;
            Scenario scenarioByIndex = this.simulation.getScenarioByIndex(rowIndex);
            FactMapping factMappingByIndex = this.simulation.getSimulationDescriptor().getFactMappingByIndex(columnIndex);
            FactIdentifier factIdentifier = factMappingByIndex.getFactIdentifier();
            ExpressionIdentifier expressionIdentifier = factMappingByIndex.getExpressionIdentifier();
            scenarioByIndex.addOrUpdateMappingValue(factIdentifier, expressionIdentifier, (Object)cellValue);
        }
        return toReturn;
    }

    public void clear() {
        int to = this.getRowCount();
        IntStream.range(0, to).map(i -> to - i - 1).forEach(arg_0 -> ((ScenarioGridModel)this).deleteRow(arg_0));
        ArrayList copyList = new ArrayList(this.getColumns());
        copyList.forEach(arg_0 -> ((ScenarioGridModel)this).deleteColumn(arg_0));
        if (this.simulation != null) {
            this.simulation.clear();
        }
    }

    private void checkSimulation() {
        Objects.requireNonNull(this.simulation, "Bind a simulation to the ScenarioGridModel to use it");
    }

    public Optional<Simulation> getSimulation() {
        return Optional.ofNullable(this.simulation);
    }

    private Optional<?> getCellValue(GridCell<?> gridCell) {
        return Optional.ofNullable(gridCell).map(GridCell::getValue).map(GridCellValue::getValue);
    }
}

