/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.utils;

import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.types.Point2D;
import java.util.List;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellEditContext;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.impl.BaseGridRendererHelper;

public class ScenarioSimulationGridHeaderUtilities {
    public static Integer getUiHeaderRowIndex(GridWidget gridWidget, GridColumn<?> column, double cy) {
        double headerMaxY;
        Group header = gridWidget.getHeader();
        GridRenderer renderer = gridWidget.getRenderer();
        BaseGridRendererHelper.RenderingInformation ri = gridWidget.getRendererHelper().getRenderingInformation();
        double headerRowsYOffset = ri.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double d = headerMaxY = header == null ? renderer.getHeaderHeight() : renderer.getHeaderHeight() + header.getY();
        if (cy < headerMinY || cy > headerMaxY) {
            return null;
        }
        int uiHeaderRowIndex = 0;
        double offsetY = cy - headerMinY;
        double headerRowsHeight = renderer.getHeaderRowHeight();
        double headerRowHeight = headerRowsHeight / (double)column.getHeaderMetaData().size();
        while (headerRowHeight < offsetY) {
            offsetY -= headerRowHeight;
            ++uiHeaderRowIndex;
        }
        if (uiHeaderRowIndex < 0 || uiHeaderRowIndex > column.getHeaderMetaData().size() - 1) {
            return null;
        }
        return uiHeaderRowIndex;
    }

    public static ScenarioHeaderMetaData getColumnScenarioHeaderMetaData(GridWidget gridWidget, double cx, double cy) {
        GridColumn<?> column = ScenarioSimulationGridHeaderUtilities.getGridColumn(gridWidget, cx);
        if (column == null) {
            return null;
        }
        Integer uiHeaderRowIndex = ScenarioSimulationGridHeaderUtilities.getUiHeaderRowIndex(gridWidget, column, cy);
        return (ScenarioHeaderMetaData)((Object)column.getHeaderMetaData().get(uiHeaderRowIndex));
    }

    public static ScenarioHeaderMetaData getColumnScenarioHeaderMetaData(GridWidget gridWidget, GridColumn<?> column, double cy) {
        Integer uiHeaderRowIndex = ScenarioSimulationGridHeaderUtilities.getUiHeaderRowIndex(gridWidget, column, cy);
        return uiHeaderRowIndex == null ? null : (ScenarioHeaderMetaData)((Object)column.getHeaderMetaData().get(uiHeaderRowIndex));
    }

    public static GridColumn<?> getGridColumn(GridWidget gridWidget, double cx) {
        BaseGridRendererHelper rendererHelper = gridWidget.getRendererHelper();
        BaseGridRendererHelper.RenderingInformation ri = rendererHelper.getRenderingInformation();
        if (ri == null) {
            return null;
        }
        BaseGridRendererHelper.ColumnInformation ci = rendererHelper.getColumnInformation(cx);
        return ci.getColumn();
    }

    public static boolean hasEditableHeader(GridColumn<?> column) {
        return column.getHeaderMetaData().stream().anyMatch(md -> md instanceof ScenarioHeaderMetaData);
    }

    public static boolean isEditableHeader(GridColumn<?> column, Integer uiHeaderRowIndex) {
        return column.getHeaderMetaData().get(uiHeaderRowIndex) instanceof ScenarioHeaderMetaData;
    }

    public static GridBodyCellEditContext makeRenderContext(GridWidget gridWidget, BaseGridRendererHelper.RenderingInformation ri, BaseGridRendererHelper.ColumnInformation ci, int uiHeaderRowIndex) {
        return ScenarioSimulationGridHeaderUtilities.makeRenderContext(gridWidget, ri, ci, null, uiHeaderRowIndex);
    }

    public static GridBodyCellEditContext makeRenderContext(GridWidget gridWidget, BaseGridRendererHelper.RenderingInformation ri, BaseGridRendererHelper.ColumnInformation ci, Point2D rp, int uiHeaderRowIndex) {
        GridColumn column = ci.getColumn();
        GridRenderer renderer = gridWidget.getRenderer();
        Group header = gridWidget.getHeader();
        double headerRowsYOffset = ri.getHeaderRowsYOffset();
        double headerMinY = header == null ? headerRowsYOffset : header.getY() + headerRowsYOffset;
        double headerRowHeight = renderer.getHeaderRowHeight() / (double)column.getHeaderMetaData().size();
        double cellX = gridWidget.getAbsoluteX() + ci.getOffsetX();
        double cellY = gridWidget.getAbsoluteY() + headerMinY + headerRowHeight * (double)uiHeaderRowIndex;
        BaseGridRendererHelper.RenderingBlockInformation floatingBlockInformation = ri.getFloatingBlockInformation();
        double floatingX = floatingBlockInformation.getX();
        double floatingWidth = floatingBlockInformation.getWidth();
        double clipMinX = gridWidget.getAbsoluteX() + floatingX + floatingWidth;
        double clipMinY = gridWidget.getAbsoluteY();
        double blockCellX = cellX;
        double blockCellWidth = column.getWidth();
        List gridColumns = ri.getAllColumns();
        GridColumn.HeaderMetaData clicked = (GridColumn.HeaderMetaData)column.getHeaderMetaData().get(uiHeaderRowIndex);
        if (ci.getUiColumnIndex() > 0) {
            int uiLeadColumnIndex = ci.getUiColumnIndex() - 1;
            GridColumn lead = (GridColumn)gridColumns.get(uiLeadColumnIndex);
            while (uiLeadColumnIndex >= 0 && ScenarioSimulationGridHeaderUtilities.isSameHeaderMetaData(clicked, lead.getHeaderMetaData(), uiHeaderRowIndex)) {
                blockCellX -= lead.getWidth();
                blockCellWidth += lead.getWidth();
                if (--uiLeadColumnIndex < 0) continue;
                lead = (GridColumn)gridColumns.get(uiLeadColumnIndex);
            }
        }
        if (ci.getUiColumnIndex() < gridColumns.size() - 1) {
            int uiTailColumnIndex = ci.getUiColumnIndex() + 1;
            GridColumn tail = (GridColumn)gridColumns.get(uiTailColumnIndex);
            while (uiTailColumnIndex < gridColumns.size() && ScenarioSimulationGridHeaderUtilities.isSameHeaderMetaData(clicked, tail.getHeaderMetaData(), uiHeaderRowIndex)) {
                blockCellWidth += tail.getWidth();
                tail = (GridColumn)gridColumns.get(uiTailColumnIndex);
                if (++uiTailColumnIndex >= gridColumns.size()) continue;
                tail = (GridColumn)gridColumns.get(uiTailColumnIndex);
            }
        }
        return new GridBodyCellEditContext(blockCellX, cellY, blockCellWidth, headerRowHeight, clipMinY, clipMinX, uiHeaderRowIndex, ci.getUiColumnIndex(), floatingBlockInformation.getColumns().contains(column), gridWidget.getViewport().getTransform(), renderer, Optional.ofNullable(rp));
    }

    private static boolean isSameHeaderMetaData(GridColumn.HeaderMetaData clickedHeaderMetaData, List<GridColumn.HeaderMetaData> columnHeaderMetaData, int uiHeaderRowIndex) {
        if (uiHeaderRowIndex > columnHeaderMetaData.size() - 1) {
            return false;
        }
        return clickedHeaderMetaData.equals(columnHeaderMetaData.get(uiHeaderRowIndex));
    }
}

