/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.List;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelDoubleClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRenderer;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridRow;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class ScenarioGrid
extends BaseGridWidget {
    private final ScenarioGridLayer scenarioGridLayer;
    private final ScenarioGridPanel scenarioGridPanel;

    public ScenarioGrid(ScenarioGridModel model, ScenarioGridLayer scenarioGridLayer, ScenarioGridRenderer renderer, ScenarioGridPanel scenarioGridPanel) {
        super((GridData)model, (GridSelectionManager)scenarioGridLayer, (GridPinnedModeManager)scenarioGridLayer, (GridRenderer)renderer);
        this.scenarioGridLayer = scenarioGridLayer;
        this.scenarioGridPanel = scenarioGridPanel;
        this.setDraggable(false);
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
    }

    public void setContent(Simulation simulation) {
        ((ScenarioGridModel)this.model).clear();
        ((ScenarioGridModel)this.model).bindContent(simulation);
        simulation.getSimulationDescriptor().sortByLogicalPosition();
        this.setHeaderColumns(simulation);
        this.appendRows(simulation);
    }

    protected NodeMouseDoubleClickHandler getGridMouseDoubleClickHandler(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        return new ScenarioSimulationGridPanelDoubleClickHandler((GridWidget)this, selectionManager, pinnedModeManager, this.renderer);
    }

    private void setHeaderColumns(Simulation simulation) {
        simulation.getSimulationDescriptor().getFactMappings().forEach(fact -> {
            String columnId = fact.getExpressionIdentifier().getName();
            String columnTitle = fact.getExpressionAlias();
            String columnGroup = fact.getExpressionIdentifier().getType().name();
            this.model.insertColumn(fact.getLogicalPosition(), (GridColumn)ScenarioSimulationUtils.getScenarioGridColumn(columnId, columnTitle, columnGroup, this.scenarioGridPanel, this.scenarioGridLayer));
        });
    }

    private void appendRows(Simulation simulation) {
        List scenarios = simulation.getScenarios();
        IntStream.range(0, scenarios.size()).forEach(rowIndex -> {
            Scenario scenario = (Scenario)scenarios.get(rowIndex);
            this.model.insertRow(rowIndex, (GridRow)new ScenarioGridRow());
            scenario.getFactMappingValues().forEach(value -> {
                FactIdentifier factIdentifier = value.getFactIdentifier();
                ExpressionIdentifier expressionIdentifier = value.getExpressionIdentifier();
                if (!(value.getRawValue() instanceof String)) {
                    throw new UnsupportedOperationException("Only string is supported at the moment");
                }
                String stringValue = (String)value.getRawValue();
                int columnIndex = simulation.getSimulationDescriptor().getIndexByIdentifier(factIdentifier, expressionIdentifier);
                this.model.setCell(rowIndex, columnIndex, () -> new ScenarioGridCell((GridCellValue<String>)new ScenarioGridCellValue(stringValue)));
            });
        });
    }
}

