/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.menu;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.Command;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.MenuItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.MenuItemView;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.MenuItemViewImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class MenuItemPresenterTest {
    @Mock
    private MenuItemViewImpl mockMenuItemView;
    @Mock
    private LIElement mockLIElement;
    @Mock
    private Map<LIElement, Command> mockMenuItemsCommandMap;
    @Mock
    private Command mockCommand;
    private MenuItemPresenter menuItemPresenter;

    @Before
    public void setup() {
        Mockito.when((Object)this.mockMenuItemView.getLIElement()).thenReturn((Object)this.mockLIElement);
        Mockito.when((Object)this.mockMenuItemsCommandMap.containsKey(this.mockLIElement)).thenReturn((Object)true);
        Mockito.when((Object)this.mockMenuItemsCommandMap.get(this.mockLIElement)).thenReturn((Object)this.mockCommand);
        this.menuItemPresenter = (MenuItemPresenter)Mockito.spy((Object)new MenuItemPresenter(){
            {
                this.menuItemsCommandMap = MenuItemPresenterTest.this.mockMenuItemsCommandMap;
            }

            protected MenuItemView getMenuItemView() {
                return MenuItemPresenterTest.this.mockMenuItemView;
            }
        });
    }

    @Test
    public void onClickEvent() {
        ClickEvent mockClickEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        this.menuItemPresenter.onClickEvent(mockClickEvent);
        ((ClickEvent)Mockito.verify((Object)mockClickEvent, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((ClickEvent)Mockito.verify((Object)mockClickEvent, (VerificationMode)Mockito.times((int)1))).stopPropagation();
    }

    @Test
    public void executeCommand() {
        this.menuItemPresenter.executeCommand(this.mockLIElement);
        ((Map)Mockito.verify(this.mockMenuItemsCommandMap, (VerificationMode)Mockito.times((int)1))).containsKey(this.mockLIElement);
        ((Command)Mockito.verify((Object)this.mockCommand, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void getLIElement() {
        LIElement liElement = this.menuItemPresenter.getLIElement("TEST-ID", "TEST-LABEL", this.mockCommand);
        Assert.assertNotNull((Object)liElement);
        ((Map)Mockito.verify(this.mockMenuItemsCommandMap, (VerificationMode)Mockito.times((int)1))).put(liElement, this.mockCommand);
    }
}

