/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationGridPanelClickHandlerTest {
    private ScenarioSimulationGridPanelClickHandler scenarioSimulationGridPanelClickHandler;
    @Mock
    private ScenarioGrid mockScenarioGrid;
    @Mock
    private GridContextMenu mockGridContextMenu;
    @Mock
    private HeaderContextMenu mockHeaderContextMenu;
    @Mock
    private Element mockTarget;
    @Mock
    private NativeEvent mockNativeEvent;
    @Mock
    private Document mockDocument;
    @Mock
    private ContextMenuEvent mockContextMenuEvent;

    @Before
    public void setUp() throws Exception {
        this.scenarioSimulationGridPanelClickHandler = (ScenarioSimulationGridPanelClickHandler)Mockito.spy((Object)new ScenarioSimulationGridPanelClickHandler(this.mockScenarioGrid, this.mockGridContextMenu, this.mockHeaderContextMenu){

            protected void manageRightClick(ContextMenuEvent event) {
            }
        });
        Mockito.when((Object)this.mockNativeEvent.getClientX()).thenReturn((Object)100);
        Mockito.when((Object)this.mockNativeEvent.getClientY()).thenReturn((Object)100);
        Mockito.when((Object)this.mockTarget.getOwnerDocument()).thenReturn((Object)this.mockDocument);
        Mockito.when((Object)this.mockTarget.getAbsoluteLeft()).thenReturn((Object)50);
        Mockito.when((Object)this.mockTarget.getScrollLeft()).thenReturn((Object)20);
        Mockito.when((Object)this.mockTarget.getAbsoluteTop()).thenReturn((Object)50);
        Mockito.when((Object)this.mockTarget.getScrollTop()).thenReturn((Object)20);
        Mockito.when((Object)this.mockDocument.getScrollLeft()).thenReturn((Object)10);
        Mockito.when((Object)this.mockDocument.getScrollTop()).thenReturn((Object)10);
        Mockito.when((Object)this.mockContextMenuEvent.getNativeEvent()).thenReturn((Object)this.mockNativeEvent);
        Mockito.when((Object)this.mockContextMenuEvent.getRelativeElement()).thenReturn((Object)this.mockTarget);
    }

    @Test
    public void getRelativeX() {
        int retrieved = this.scenarioSimulationGridPanelClickHandler.getRelativeX(this.mockContextMenuEvent);
        Assert.assertEquals((long)80L, (long)retrieved);
    }

    @Test
    public void getRelativeY() {
        int retrieved = this.scenarioSimulationGridPanelClickHandler.getRelativeY(this.mockContextMenuEvent);
        Assert.assertEquals((long)80L, (long)retrieved);
    }

    @Test
    public void onClick() {
        ClickEvent mockEvent = (ClickEvent)Mockito.mock(ClickEvent.class);
        Mockito.when((Object)mockEvent.getNativeEvent()).thenReturn((Object)this.mockNativeEvent);
        Mockito.when((Object)mockEvent.getRelativeElement()).thenReturn((Object)this.mockTarget);
        this.scenarioSimulationGridPanelClickHandler.onClick(mockEvent);
        this.commonCheck();
    }

    @Test
    public void onContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.onContextMenu(this.mockContextMenuEvent);
        ((ContextMenuEvent)Mockito.verify((Object)this.mockContextMenuEvent, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((ContextMenuEvent)Mockito.verify((Object)this.mockContextMenuEvent, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        this.commonCheck();
    }

    private void commonCheck() {
        ((GridContextMenu)Mockito.verify((Object)this.mockGridContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((HeaderContextMenu)Mockito.verify((Object)this.mockHeaderContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
        Mockito.reset((Object[])new GridContextMenu[]{this.mockGridContextMenu});
        Mockito.reset((Object[])new HeaderContextMenu[]{this.mockHeaderContextMenu});
    }
}

