/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.commands.CommandExecutor;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.models.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.client.producers.ScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.RightPanelMenuItem;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditor;
import org.kie.workbench.common.widgets.metadata.client.KieEditorView;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.workbench.events.PlaceGainFocusEvent;
import org.uberfire.client.workbench.events.PlaceHiddenEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.ext.widgets.common.client.callbacks.HasBusyIndicatorDefaultErrorCallback;
import org.uberfire.ext.widgets.common.client.common.HasBusyIndicator;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@WorkbenchEditor(identifier="ScenarioSimulationEditor", supportedTypes={ScenarioSimulationResourceType.class})
public class ScenarioSimulationEditorPresenter
extends KieEditor<ScenarioSimulationModel> {
    public static final String IDENTIFIER = "ScenarioSimulationEditor";
    private ImportsWidgetPresenter importsWidget;
    private AsyncPackageDataModelOracleFactory oracleFactory;
    private ScenarioSimulationModel model;
    private Caller<ScenarioSimulationService> service;
    private ScenarioSimulationResourceType type;
    private AsyncPackageDataModelOracle oracle;
    private ScenarioSimulationView view;
    private CommandExecutor commandExecutor;
    private Command populateRightPanelCommand;
    private String packageName = "";
    RightPanelMenuItem rightPanelMenuItem;
    PlaceRequest rightPanelRequest;
    ObservablePath path;
    EventBus eventBus;

    public ScenarioSimulationEditorPresenter() {
    }

    @Inject
    public ScenarioSimulationEditorPresenter(Caller<ScenarioSimulationService> service, ScenarioSimulationProducer scenarioSimulationProducer, ScenarioSimulationResourceType type, ImportsWidgetPresenter importsWidget, AsyncPackageDataModelOracleFactory oracleFactory, PlaceManager placeManager) {
        super((KieEditorView)scenarioSimulationProducer.getScenarioSimulationView());
        this.view = (ScenarioSimulationView)this.baseView;
        this.service = service;
        this.type = type;
        this.importsWidget = importsWidget;
        this.oracleFactory = oracleFactory;
        this.placeManager = placeManager;
        this.rightPanelMenuItem = scenarioSimulationProducer.getRightPanelMenuItem();
        this.commandExecutor = scenarioSimulationProducer.getCommandExecutor();
        this.eventBus = scenarioSimulationProducer.getEventBus();
        this.commandExecutor.setScenarioGridPanel(this.view.getScenarioGridPanel());
        this.view.init(this);
        this.populateRightPanelCommand = this.getPopulateRightPanelCommand();
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.init(path, place, (ClientResourceType)this.type);
        this.path = path;
        this.rightPanelRequest = new DefaultPlaceRequest("org.drools.scenariosimulation.RightPanel");
        this.rightPanelRequest.addParameter("ScenarioSimulationEditorPresenter", path.toString());
        this.rightPanelMenuItem.init(this.rightPanelRequest);
    }

    @OnClose
    public void onClose() {
        this.versionRecordManager.clear();
        if (PlaceStatus.OPEN.equals((Object)this.placeManager.getStatus(this.rightPanelRequest))) {
            this.placeManager.closePlace(this.rightPanelRequest);
            this.view.showLoading();
        }
        this.view.clear();
    }

    @OnMayClose
    public boolean mayClose() {
        return super.mayClose((Object)this.model);
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return this.menus;
    }

    public void onPlaceGainFocusEvent(@Observes PlaceGainFocusEvent placeGainFocusEvent) {
        if (!(placeGainFocusEvent.getPlace() instanceof PathPlaceRequest)) {
            return;
        }
        PathPlaceRequest placeRequest = (PathPlaceRequest)placeGainFocusEvent.getPlace();
        if (placeRequest.getIdentifier().equals(IDENTIFIER) && placeRequest.getPath().equals(this.path) && PlaceStatus.CLOSE.equals((Object)this.placeManager.getStatus(this.rightPanelRequest))) {
            this.registerRightPanelCallback();
            this.placeManager.goTo(this.rightPanelRequest);
            this.populateRightPanel();
        }
    }

    public void onPlaceHiddenEvent(@Observes PlaceHiddenEvent placeHiddenEvent) {
        if (!(placeHiddenEvent.getPlace() instanceof PathPlaceRequest)) {
            return;
        }
        PathPlaceRequest placeRequest = (PathPlaceRequest)placeHiddenEvent.getPlace();
        if (placeRequest.getIdentifier().equals(IDENTIFIER) && placeRequest.getPath().equals(this.path)) {
            this.view.getScenarioGridLayer().getScenarioGrid().clearSelections();
            if (PlaceStatus.OPEN.equals((Object)this.placeManager.getStatus(this.rightPanelRequest))) {
                this.unRegisterRightPanelCallback();
                this.clearRightPanelStatus();
                this.placeManager.closePlace(this.rightPanelRequest);
            }
        }
    }

    public ScenarioSimulationView getView() {
        return this.view;
    }

    public ScenarioSimulationModel getModel() {
        return this.model;
    }

    public void onRunScenario() {
        ((ScenarioSimulationService)this.service.call()).runScenario((Path)this.versionRecordManager.getCurrentPath(), this.model);
    }

    protected void registerRightPanelCallback() {
        this.placeManager.registerOnOpenCallback(this.rightPanelRequest, this.populateRightPanelCommand);
        this.placeManager.registerOnOpenCallback(this.rightPanelRequest, this.rightPanelMenuItem.getSetButtonTextTrue());
        this.placeManager.registerOnCloseCallback(this.rightPanelRequest, this.rightPanelMenuItem.getSetButtonTextFalse());
    }

    protected void unRegisterRightPanelCallback() {
        this.placeManager.getOnOpenCallbacks(this.rightPanelRequest).remove(this.populateRightPanelCommand);
        this.placeManager.getOnOpenCallbacks(this.rightPanelRequest).remove(this.rightPanelMenuItem.getSetButtonTextTrue());
        this.placeManager.getOnCloseCallbacks(this.rightPanelRequest).remove(this.rightPanelMenuItem.getSetButtonTextFalse());
    }

    protected void makeMenuBar() {
        this.fileMenuBuilder.addNewTopLevelMenu(this.view.getRunScenarioMenuItem());
        super.makeMenuBar();
        this.addRightPanelMenuItem(this.fileMenuBuilder);
    }

    protected Supplier<ScenarioSimulationModel> getContentSupplier() {
        return () -> this.model;
    }

    protected void save(String commitMessage) {
        ((ScenarioSimulationService)this.service.call(this.getSaveSuccessCallback(this.model.hashCode()), (ErrorCallback)new HasBusyIndicatorDefaultErrorCallback((HasBusyIndicator)this.baseView))).save((Path)this.versionRecordManager.getCurrentPath(), (Object)this.model, (Object)this.metadata, commitMessage);
    }

    protected void addCommonActions(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addNewTopLevelMenu(this.versionRecordManager.buildMenu()).addNewTopLevelMenu(this.alertsButtonMenuItemBuilder.build());
    }

    protected void loadContent() {
        ((ScenarioSimulationService)this.service.call(this.getModelSuccessCallback(), (ErrorCallback)this.getNoSuchFileExceptionErrorCallback())).loadContent((Path)this.versionRecordManager.getCurrentPath());
    }

    void populateRightPanel() {
        this.getRightPanelPresenter().ifPresent(presenter -> {
            presenter.onDisableEditorTab();
            this.commandExecutor.setRightPanelPresenter((RightPanelView.Presenter)presenter);
            presenter.setEventBus(this.eventBus);
            this.populateRightPanel((RightPanelView.Presenter)presenter);
        });
    }

    void populateRightPanel(RightPanelView.Presenter rightPanelPresenter) {
        TreeMap<String, FactModelTree> factTypeFieldsMap = new TreeMap<String, FactModelTree>();
        if (this.oracle == null) {
            if (rightPanelPresenter != null) {
                rightPanelPresenter.setFactTypeFieldsMap(factTypeFieldsMap);
            }
            return;
        }
        String[] factTypes = this.oracle.getFactTypes();
        if (factTypes.length == 0) {
            if (rightPanelPresenter != null) {
                rightPanelPresenter.setFactTypeFieldsMap(factTypeFieldsMap);
            }
            return;
        }
        Callback<FactModelTree> aggregatorCallback = this.aggregatorCallback(rightPanelPresenter, factTypes.length, factTypeFieldsMap);
        for (String factType : factTypes) {
            this.oracle.getFieldCompletions(factType, this.fieldCompletionsCallback(factType, aggregatorCallback));
        }
    }

    void clearRightPanelStatus() {
        this.getRightPanelPresenter().ifPresent(RightPanelView.Presenter::onClearStatus);
    }

    private RemoteCallback<ScenarioSimulationModelContent> getModelSuccessCallback() {
        return content -> {
            if (this.versionRecordManager.getCurrentPath() == null) {
                return;
            }
            this.packageName = content.getDataModel().getPackageName();
            this.resetEditorPages(content.getOverview());
            this.model = content.getModel();
            this.oracle = this.oracleFactory.makeAsyncPackageDataModelOracle((Path)this.versionRecordManager.getCurrentPath(), (HasImports)this.model, content.getDataModel());
            this.populateRightPanel();
            this.importsWidget.setContent(this.oracle, this.model.getImports(), this.isReadOnly);
            this.addImportsTab((IsWidget)this.importsWidget);
            this.baseView.hideBusyIndicator();
            this.view.setContent(this.model.getSimulation());
            this.createOriginalHash(this.model.hashCode());
        };
    }

    private void addRightPanelMenuItem(FileMenuBuilder fileMenuBuilder) {
        fileMenuBuilder.addNewTopLevelMenu((MenuItem)this.rightPanelMenuItem);
    }

    private Callback<ModelField[]> fieldCompletionsCallback(String factName, Callback<FactModelTree> aggregatorCallback) {
        return result -> {
            HashMap<String, String> simpleProperties = new HashMap<String, String>();
            for (ModelField modelField : result) {
                if (modelField.getName().equals("this")) continue;
                simpleProperties.put(modelField.getName(), modelField.getClassName());
            }
            FactModelTree toSend = new FactModelTree(factName, this.packageName, simpleProperties);
            aggregatorCallback.callback((Object)toSend);
        };
    }

    private Callback<FactModelTree> aggregatorCallback(RightPanelView.Presenter rightPanelPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap) {
        return result -> {
            factTypeFieldsMap.put(result.getFactName(), (FactModelTree)result);
            if (factTypeFieldsMap.size() == expectedElements) {
                factTypeFieldsMap.values().forEach(factModelTree -> this.populateFactModel((FactModelTree)factModelTree, factTypeFieldsMap));
                rightPanelPresenter.setFactTypeFieldsMap(factTypeFieldsMap);
            }
        };
    }

    private void populateFactModel(FactModelTree toPopulate, SortedMap<String, FactModelTree> factTypeFieldsMap) {
        ArrayList toRemove = new ArrayList();
        toPopulate.getSimpleProperties().forEach((key, value) -> {
            if (factTypeFieldsMap.containsKey(value)) {
                toRemove.add(key);
                toPopulate.addExpandableProperty((String)key, ((FactModelTree)factTypeFieldsMap.get(value)).getFactName());
            }
        });
        toRemove.forEach(toPopulate::removeSimpleProperty);
    }

    private Optional<RightPanelView> getRightPanelView() {
        if (PlaceStatus.OPEN.equals((Object)this.placeManager.getStatus(this.rightPanelRequest))) {
            AbstractWorkbenchActivity rightPanelActivity = (AbstractWorkbenchActivity)this.placeManager.getActivity(this.rightPanelRequest);
            return Optional.of((RightPanelView)rightPanelActivity.getWidget());
        }
        return Optional.empty();
    }

    private Optional<RightPanelView.Presenter> getRightPanelPresenter() {
        return this.getRightPanelView().isPresent() ? Optional.of(this.getRightPanelView().get().getPresenter()) : Optional.empty();
    }

    private Command getPopulateRightPanelCommand() {
        return this::populateRightPanel;
    }
}

