/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated(stylesheet="/org/drools/workbench/screens/scenariosimulation/client/resources/css/ScenarioSimulationEditorStyles.css")
public class RightPanelViewImpl
extends Composite
implements RightPanelView {
    private RightPanelView.Presenter presenter;
    @DataField(value="rightPanelTabs")
    private UListElement rightPanelTabs = Document.get().createULElement();
    @DataField(value="clearSearchButton")
    ButtonElement clearSearchButton = Document.get().createButtonElement();
    @DataField(value="searchButton")
    ButtonElement searchButton = Document.get().createButtonElement();
    @DataField(value="inputSearch")
    InputElement inputSearch = Document.get().createTextInputElement();
    @DataField(value="nameField")
    InputElement nameField = Document.get().createTextInputElement();
    @DataField(value="listContainer")
    DivElement listContainer = Document.get().createDivElement();
    @DataField(value="conditionsButton")
    ButtonElement conditionsButton = Document.get().createButtonElement();

    public void init(RightPanelView.Presenter presenter) {
        this.presenter = presenter;
        this.disableEditorTab();
    }

    @Override
    public RightPanelView.Presenter getPresenter() {
        return this.presenter;
    }

    @EventHandler(value={"clearSearchButton"})
    public void onClearSearchButtonClick(ClickEvent event) {
        this.presenter.onClearSearch();
    }

    @EventHandler(value={"inputSearch"})
    public void onInputSearchKeyUp(KeyUpEvent event) {
        this.presenter.onShowClearButton();
    }

    @EventHandler(value={"inputSearch"})
    public void onInputSearchKeyDownEvent(KeyDownEvent event) {
        if (event.getNativeKeyCode() == 13) {
            this.presenter.onSearchedEvent(this.inputSearch.getValue());
        }
    }

    @EventHandler(value={"searchButton"})
    public void onSearchButtonClicked(ClickEvent event) {
        this.presenter.onSearchedEvent(this.inputSearch.getValue());
    }

    @Override
    public void clearInputSearch() {
        this.inputSearch.setValue("");
    }

    @Override
    public void clearNameField() {
        this.nameField.setValue("");
    }

    @Override
    public void hideClearButton() {
        this.clearSearchButton.setDisabled(true);
        this.clearSearchButton.setAttribute("style", "display: none;");
    }

    @Override
    public void showClearButton() {
        this.clearSearchButton.setDisabled(false);
        this.clearSearchButton.removeAttribute("style");
    }

    @Override
    public DivElement getListContainer() {
        return this.listContainer;
    }

    @Override
    public void enableEditorTab() {
        this.setDisabledStatus(false);
    }

    @Override
    public void disableEditorTab() {
        this.setDisabledStatus(true);
    }

    protected void setDisabledStatus(boolean disabled) {
        this.clearSearchButton.setDisabled(disabled);
        this.searchButton.setDisabled(disabled);
        this.inputSearch.setDisabled(disabled);
        this.nameField.setDisabled(disabled);
        this.conditionsButton.setDisabled(disabled);
        this.setListContainerDisabledStatus(disabled);
    }

    protected void setListContainerDisabledStatus(boolean disabled) {
        if (disabled) {
            this.listContainer.addClassName("disabled");
        } else {
            this.listContainer.removeClassName("disabled");
        }
    }
}

