/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.commands.RightPanelMenuCommand;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.MenuVisitor;

@Dependent
public class RightPanelMenuItem
implements MenuCustom<Widget> {
    private Button button = (Button)GWT.create(Button.class);
    private PlaceManager placeManager;
    private PlaceRequest rightPanelRequest;
    private RightPanelMenuCommand rightPanelMenuCommand;
    private Command setButtonTextFalse = () -> this.setButtonText(false);
    private Command setButtonTextTrue = () -> this.setButtonText(true);

    public RightPanelMenuItem() {
    }

    @Inject
    public RightPanelMenuItem(PlaceManager placeManager, RightPanelMenuCommand rightPanelMenuCommand) {
        this.placeManager = placeManager;
        this.rightPanelMenuCommand = rightPanelMenuCommand;
        this.button.addClickHandler(event -> {
            if (rightPanelMenuCommand != null) {
                rightPanelMenuCommand.execute();
            }
        });
        this.button.setSize(ButtonSize.SMALL);
    }

    public void init(PlaceRequest rightPanelRequest) {
        this.rightPanelRequest = rightPanelRequest;
        this.rightPanelMenuCommand.init(rightPanelRequest);
        boolean isRightPanelShown = PlaceStatus.OPEN.equals((Object)this.placeManager.getStatus(rightPanelRequest));
        this.setButtonText(isRightPanelShown);
    }

    public Widget build() {
        return this.button;
    }

    public boolean isEnabled() {
        return this.button.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.button.setEnabled(enabled);
    }

    public String getContributionPoint() {
        return null;
    }

    public String getCaption() {
        return null;
    }

    public MenuPosition getPosition() {
        return null;
    }

    public int getOrder() {
        return 0;
    }

    public void accept(MenuVisitor visitor) {
        visitor.visit((MenuCustom)this);
    }

    public void addEnabledStateChangeListener(EnabledStateChangeListener listener) {
    }

    public String getIdentifier() {
        return null;
    }

    public Command getSetButtonTextFalse() {
        return this.setButtonTextFalse;
    }

    public Command getSetButtonTextTrue() {
        return this.setButtonTextTrue;
    }

    private void setButtonText(boolean isRightPanelShown) {
        this.button.setText(isRightPanelShown ? ScenarioSimulationEditorConstants.INSTANCE.hideRightPanel() : ScenarioSimulationEditorConstants.INSTANCE.showRightPanel());
    }
}

