/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client;

import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;

public class TestUtils {
    public static Simulation getSimulation(int numberOfColumns, int numberOfRows) {
        Simulation simulation = new Simulation();
        SimulationDescriptor simulationDescriptor = simulation.getSimulationDescriptor();
        simulationDescriptor.addFactMapping(FactIdentifier.DESCRIPTION, ExpressionIdentifier.DESCRIPTION);
        IntStream.range(0, numberOfColumns).forEach(columnIndex -> simulationDescriptor.addFactMapping(FactIdentifier.create((String)TestUtils.getFactName(columnIndex), (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)TestUtils.getColName(columnIndex), (FactMappingType)FactMappingType.EXPECTED)));
        IntStream.range(0, numberOfRows).forEach(rowIndex -> {
            Scenario scenario = simulation.addScenario();
            scenario.setDescription(TestUtils.getRowName(rowIndex));
            IntStream.range(0, numberOfColumns).forEach(columnIndex -> scenario.addMappingValue(FactIdentifier.create((String)TestUtils.getFactName(columnIndex), (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)TestUtils.getColName(columnIndex), (FactMappingType)FactMappingType.EXPECTED), (Object)TestUtils.getCellValue(columnIndex, rowIndex)));
        });
        return simulation;
    }

    public static String getColName(int index) {
        return "COL-" + index;
    }

    public static String getRowName(int index) {
        return "ROW-" + index;
    }

    public static String getFactName(int index) {
        return "GROUP_COL-" + index;
    }

    public static String getCellValue(int col, int row) {
        return "VAL_COL-" + col + "-ROW-" + row;
    }
}

