/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwtmockito.GwtMockitoTestRunner;
import javax.enterprise.event.Event;
import org.drools.workbench.screens.scenariosimulation.client.handlers.NewScenarioSimulationHandler;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.project.model.Package;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.security.shared.api.identity.User;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.widgets.client.handlers.NewResourcePresenter;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.security.Resource;
import org.uberfire.security.ResourceAction;
import org.uberfire.security.ResourceRef;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.ActivityResourceType;

@RunWith(value=GwtMockitoTestRunner.class)
public class NewScenarioSimulationHandlerTest {
    @Mock
    private BusyIndicatorView mockBusyIndicatorView;
    @Mock
    private ScenarioSimulationService mockScenarioSimulationService;
    @Mock
    private ScenarioSimulationResourceType mockResourceType;
    @Mock
    private EventSourceMock mockNotificationEvent;
    @Mock
    private EventSourceMock mockNewResourceSuccessEvent;
    @Mock
    private PlaceManager mockPlaceManager;
    @Mock
    private AuthorizationManager authorizationManager;
    @Mock
    private SessionInfo sessionInfo;
    @Mock
    private User user;
    @Captor
    private ArgumentCaptor<ResourceRef> refArgumentCaptor;
    private NewScenarioSimulationHandler handler;

    @Before
    public void setUp() throws Exception {
        this.handler = new NewScenarioSimulationHandler(this.mockResourceType, this.mockBusyIndicatorView, (Event)this.mockNotificationEvent, (Event)this.mockNewResourceSuccessEvent, this.mockPlaceManager, (Caller)new CallerMock((Object)this.mockScenarioSimulationService), this.authorizationManager, this.sessionInfo);
        Mockito.when((Object)this.sessionInfo.getIdentity()).thenReturn((Object)this.user);
    }

    @Test
    public void checkCanCreateWhenFeatureDisabled() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user))).thenReturn((Object)false);
        Assert.assertFalse((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    @Test
    public void checkCanCreateWhenFeatureEnabled() {
        Mockito.when((Object)this.authorizationManager.authorize((Resource)Matchers.any(ResourceRef.class), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user))).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.handler.canCreate());
        this.assertResourceRef();
    }

    @Test
    public void checkRightResourceType() throws Exception {
        this.handler.create(new Package(), "newfile.scesim", (NewResourcePresenter)Mockito.mock(NewResourcePresenter.class));
        ((BusyIndicatorView)Mockito.verify((Object)this.mockBusyIndicatorView)).showBusyIndicator("Saving");
        ((BusyIndicatorView)Mockito.verify((Object)this.mockBusyIndicatorView)).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify((Object)this.mockNotificationEvent)).fire(Matchers.any(NotificationEvent.class));
        ((EventSourceMock)Mockito.verify((Object)this.mockNewResourceSuccessEvent)).fire(Matchers.any(NewResourcePresenter.class));
        ((PlaceManager)Mockito.verify((Object)this.mockPlaceManager)).goTo((Path)Matchers.any(Path.class));
    }

    private void assertResourceRef() {
        ((AuthorizationManager)Mockito.verify((Object)this.authorizationManager)).authorize((Resource)this.refArgumentCaptor.capture(), (ResourceAction)Matchers.eq((Object)ResourceAction.READ), (User)Matchers.eq((Object)this.user));
        Assert.assertEquals((Object)"ScenarioSimulationEditor", (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getIdentifier());
        Assert.assertEquals((Object)ActivityResourceType.EDITOR, (Object)((ResourceRef)this.refArgumentCaptor.getValue()).getResourceType());
    }
}

