/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.client.events.SetInstanceHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetPropertyHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.models.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractRightPanelTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class RightPanelPresenterTest
extends AbstractRightPanelTest {
    @Mock
    private RightPanelView rightPanelViewMock;
    @Mock
    private DivElement dataObjectListContainerMock;
    @Mock
    private DivElement instanceListContainerMock;
    @Mock
    private ListGroupItemPresenter listGroupItemPresenterMock;
    @Mock
    private ListGroupItemView selectedListGroupItemViewMock;
    @Mock
    private FieldItemView selectedFieldItemViewMock;
    @Mock
    private EventBus eventBusMock;
    private RightPanelPresenter rightPanelPresenter;

    @Override
    @Before
    public void setup() {
        super.setup();
        String firstKey = (String)this.dataObjectFactTreeMap.firstKey();
        FactModelTree factModelTree = (FactModelTree)this.dataObjectFactTreeMap.get(firstKey);
        String firstPropertyKey = (String)new ArrayList(factModelTree.getSimpleProperties().keySet()).get(0);
        String firstPropertyClass = (String)factModelTree.getSimpleProperties().get(firstPropertyKey);
        Mockito.when((Object)this.selectedListGroupItemViewMock.getActualClassName()).thenReturn((Object)firstKey);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFullPath()).thenReturn((Object)firstKey);
        Mockito.when((Object)this.selectedFieldItemViewMock.getFieldName()).thenReturn((Object)firstPropertyKey);
        Mockito.when((Object)this.selectedFieldItemViewMock.getClassName()).thenReturn((Object)firstPropertyClass);
        Mockito.when((Object)this.rightPanelViewMock.getDataObjectListContainer()).thenReturn((Object)this.dataObjectListContainerMock);
        Mockito.when((Object)this.rightPanelViewMock.getInstanceListContainer()).thenReturn((Object)this.instanceListContainerMock);
        Mockito.when((Object)this.listGroupItemPresenterMock.getDivElement(this.FACT_NAME, this.FACT_MODEL_TREE)).thenReturn((Object)this.dataObjectListContainerMock);
        this.rightPanelPresenter = (RightPanelPresenter)Mockito.spy((Object)new RightPanelPresenter(this.rightPanelViewMock, this.listGroupItemPresenterMock){
            {
                this.dataObjectFieldsMap = RightPanelPresenterTest.this.dataObjectFactTreeMap;
                this.instanceFieldsMap = RightPanelPresenterTest.this.instanceFactTreeMap;
                this.eventBus = RightPanelPresenterTest.this.eventBusMock;
            }
        });
    }

    @Test
    public void onSetup() {
        this.rightPanelPresenter.setup();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).init((Object)this.rightPanelPresenter);
    }

    @Test
    public void getTitle() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.testTools(), (Object)this.rightPanelPresenter.getTitle());
    }

    @Test
    public void onClearSearch() {
        this.rightPanelPresenter.onClearSearch();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).clearInputSearch();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).hideClearButton();
    }

    @Test
    public void onClearNameField() {
        this.rightPanelPresenter.onClearNameField();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).clearNameField();
    }

    @Test
    public void onClearStatus() {
        this.rightPanelPresenter.onClearStatus();
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenter, (VerificationMode)Mockito.times((int)1))).onClearSearch();
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenter, (VerificationMode)Mockito.times((int)1))).onClearNameField();
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenter, (VerificationMode)Mockito.times((int)1))).clearDataObjectList();
    }

    @Test
    public void clearDataObjectList() {
        this.rightPanelPresenter.clearDataObjectList();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).getDataObjectListContainer();
        ((DivElement)Mockito.verify((Object)this.dataObjectListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void clearInstanceList() {
        this.rightPanelPresenter.clearInstanceList();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).getInstanceListContainer();
        ((DivElement)Mockito.verify((Object)this.instanceListContainerMock, (VerificationMode)Mockito.times((int)1))).removeAllChildren();
    }

    @Test
    public void getFactModelTree() {
        this.rightPanelPresenter.setDataObjectFieldsMap(this.dataObjectFactTreeMap);
        String factName = this.getRandomFactModelTree(this.dataObjectFactTreeMap, 0);
        FactModelTree retrieved = this.rightPanelPresenter.getFactModelTreeFromFactTypeMap(factName);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals(this.dataObjectFactTreeMap.get(factName), (Object)retrieved);
    }

    @Test
    public void setFactTypeFieldsMap() {
        this.rightPanelPresenter.setDataObjectFieldsMap(this.dataObjectFactTreeMap);
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenter, (VerificationMode)Mockito.times((int)this.dataObjectFactTreeMap.size()))).addDataObjectListGroupItemView(Matchers.anyString(), (FactModelTree)Matchers.anyObject());
    }

    @Test
    public void onShowClearButton() {
        this.rightPanelPresenter.onShowClearButton();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).showClearButton();
    }

    @Test
    public void setEventBus() {
        this.rightPanelPresenter.setEventBus(this.eventBusMock);
        Assert.assertEquals((Object)this.eventBusMock, (Object)this.rightPanelPresenter.eventBus);
    }

    @Test
    public void onSearchedEvent() {
        this.rightPanelPresenter.onSearchedEvent("");
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenter, (VerificationMode)Mockito.times((int)1))).clearDataObjectList();
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenter, (VerificationMode)Mockito.times((int)1))).clearInstanceList();
    }

    @Test
    public void addListGroupItemView() {
        this.rightPanelPresenter.addDataObjectListGroupItemView(this.FACT_NAME, this.FACT_MODEL_TREE);
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).getDataObjectListContainer();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).getDivElement((String)Matchers.eq((Object)this.FACT_NAME), (FactModelTree)Matchers.eq((Object)this.FACT_MODEL_TREE));
        ((DivElement)Mockito.verify((Object)this.dataObjectListContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.anyObject());
    }

    @Test
    public void onEnableEditorTabWithoutFactName() {
        this.rightPanelPresenter.onEnableEditorTab();
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenter, (VerificationMode)Mockito.times((int)1))).onSearchedEvent((String)Matchers.eq((Object)""));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).enable();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable(Matchers.anyString());
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
    }

    @Test
    public void onEnableEditorTabWithFactName() {
        this.rightPanelPresenter.onEnableEditorTab(this.FACT_NAME, null, false);
        ((RightPanelPresenter)Mockito.verify((Object)this.rightPanelPresenter, (VerificationMode)Mockito.times((int)1))).onPerfectMatchSearchedEvent((String)Matchers.eq((Object)this.FACT_NAME), Matchers.eq((boolean)false));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).enable((String)Matchers.eq((Object)this.FACT_NAME));
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).enableEditorTab();
    }

    @Test
    public void onDisableEditorTab() {
        this.rightPanelPresenter.onDisableEditorTab();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.times((int)1))).disable();
        ((ListGroupItemPresenter)Mockito.verify((Object)this.listGroupItemPresenterMock, (VerificationMode)Mockito.never())).enable();
        ((RightPanelView)Mockito.verify((Object)this.rightPanelViewMock, (VerificationMode)Mockito.times((int)1))).disableEditorTab();
    }

    @Test
    public void onModifyColumn() {
        this.rightPanelPresenter.editingColumnEnabled = true;
        this.rightPanelPresenter.selectedFieldItemView = null;
        this.rightPanelPresenter.selectedListGroupItemView = null;
        this.rightPanelPresenter.onModifyColumn();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        this.rightPanelPresenter.selectedListGroupItemView = null;
        this.rightPanelPresenter.selectedFieldItemView = this.selectedFieldItemViewMock;
        this.rightPanelPresenter.onModifyColumn();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        this.rightPanelPresenter.selectedListGroupItemView = this.selectedListGroupItemViewMock;
        this.rightPanelPresenter.selectedFieldItemView = null;
        this.rightPanelPresenter.onModifyColumn();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.isA(SetPropertyHeaderEvent.class));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetInstanceHeaderEvent.class));
    }

    @Test
    public void filterTerm() {
        String key = this.getRandomString();
        String search = String.join((CharSequence)";", IntStream.range(0, 4).mapToObj(i -> this.getRandomString()).collect(Collectors.toSet()));
        TestCase.assertTrue((boolean)this.rightPanelPresenter.filterTerm(key, key, false));
        Assert.assertFalse((boolean)this.rightPanelPresenter.filterTerm(key, key, true));
        Assert.assertFalse((boolean)this.rightPanelPresenter.filterTerm(key, search, false));
        TestCase.assertTrue((boolean)this.rightPanelPresenter.filterTerm(key, search, true));
        search = search + ";" + key;
        TestCase.assertTrue((boolean)this.rightPanelPresenter.filterTerm(key, search, false));
        Assert.assertFalse((boolean)this.rightPanelPresenter.filterTerm(key, search, true));
    }
}

