/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.Set;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractHeaderMenuPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderGivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.OtherContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.UnmodifiableColumnGridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridPanelClickHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationGridPanelClickHandlerTest
extends AbstractScenarioSimulationGridPanelClickHandlerTest {
    private ScenarioSimulationGridPanelClickHandler scenarioSimulationGridPanelClickHandler;
    private final int EXPECTED_RELATIVE_X = 80;
    private final int EXPECTED_RELATIVE_Y = 80;
    @Mock
    private OtherContextMenu mockOtherContextMenu;
    @Mock
    private HeaderGivenContextMenu mockHeaderGivenContextMenu;
    @Mock
    private HeaderExpectedContextMenu mockHeaderExpectedContextMenu;
    @Mock
    private GivenContextMenu mockGivenContextMenu;
    @Mock
    private ExpectedContextMenu mockExpectedContextMenu;
    @Mock
    private GridContextMenu mockGridContextMenu;
    @Mock
    private UnmodifiableColumnGridContextMenu mockUnmodifiableColumnGridContextMenu;
    @Mock
    private Set<AbstractHeaderMenuPresenter> mockManagedMenus;
    @Mock
    private ScenarioGridColumn gridColumnMock;
    @Mock
    private EventBus mockEventBus;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.scenarioSimulationGridPanelClickHandler = (ScenarioSimulationGridPanelClickHandler)Mockito.spy((Object)new ScenarioSimulationGridPanelClickHandler(){
            {
                this.scenarioGrid = ScenarioSimulationGridPanelClickHandlerTest.this.scenarioGridMock;
                this.otherContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.mockOtherContextMenu;
                this.headerGivenContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.mockHeaderGivenContextMenu;
                this.headerExpectedContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.mockHeaderExpectedContextMenu;
                this.givenContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.mockGivenContextMenu;
                this.expectedContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.mockExpectedContextMenu;
                this.gridContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.mockGridContextMenu;
                this.unmodifiableColumnGridContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.mockUnmodifiableColumnGridContextMenu;
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.mockOtherContextMenu);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.mockHeaderGivenContextMenu);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.mockHeaderExpectedContextMenu);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.mockGivenContextMenu);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.mockExpectedContextMenu);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.mockGridContextMenu);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.mockUnmodifiableColumnGridContextMenu);
            }

            protected boolean manageRightClick(ContextMenuEvent event) {
                return true;
            }

            protected String getExistingInstances(String group, ScenarioGridModel scenarioGridModel) {
                return "test1;test2;test3";
            }

            protected String getPropertyName(Simulation simulation, int columnIndex) {
                return "test.name";
            }
        });
        this.mockManagedMenus = (Set)Mockito.spy((Object)this.scenarioSimulationGridPanelClickHandler.managedMenus);
    }

    @Test
    public void setScenarioGrid() {
        this.scenarioSimulationGridPanelClickHandler.setScenarioGrid(this.scenarioGridMock);
        Assert.assertEquals((Object)this.scenarioGridMock, (Object)this.scenarioSimulationGridPanelClickHandler.scenarioGrid);
    }

    @Test
    public void setOtherContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setOtherContextMenu(this.mockOtherContextMenu);
        Assert.assertEquals((Object)this.mockOtherContextMenu, (Object)this.scenarioSimulationGridPanelClickHandler.otherContextMenu);
    }

    @Test
    public void setHeaderGivenContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setHeaderGivenContextMenu(this.mockHeaderGivenContextMenu);
        Assert.assertEquals((Object)this.mockHeaderGivenContextMenu, (Object)this.scenarioSimulationGridPanelClickHandler.headerGivenContextMenu);
    }

    @Test
    public void setHeaderExpectedContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setHeaderExpectedContextMenu(this.mockHeaderExpectedContextMenu);
        Assert.assertEquals((Object)this.mockHeaderExpectedContextMenu, (Object)this.scenarioSimulationGridPanelClickHandler.headerExpectedContextMenu);
    }

    @Test
    public void setGivenContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setGivenContextMenu(this.mockGivenContextMenu);
        Assert.assertEquals((Object)this.mockGivenContextMenu, (Object)this.scenarioSimulationGridPanelClickHandler.givenContextMenu);
    }

    @Test
    public void setExpectedContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setExpectedContextMenu(this.mockExpectedContextMenu);
        Assert.assertEquals((Object)this.mockExpectedContextMenu, (Object)this.scenarioSimulationGridPanelClickHandler.expectedContextMenu);
    }

    @Test
    public void setGridContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setGridContextMenu(this.mockGridContextMenu);
        Assert.assertEquals((Object)this.mockGridContextMenu, (Object)this.scenarioSimulationGridPanelClickHandler.gridContextMenu);
    }

    @Test
    public void setUnmodifiableColumnGridContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setUnmodifiableColumnGridContextMenu(this.mockUnmodifiableColumnGridContextMenu);
        Assert.assertEquals((Object)this.mockUnmodifiableColumnGridContextMenu, (Object)this.scenarioSimulationGridPanelClickHandler.unmodifiableColumnGridContextMenu);
    }

    @Test
    public void setEventBus() {
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.mockEventBus);
        ((OtherContextMenu)Mockito.verify((Object)this.mockOtherContextMenu, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.mockEventBus));
        ((HeaderGivenContextMenu)Mockito.verify((Object)this.mockHeaderGivenContextMenu, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.mockEventBus));
        ((HeaderExpectedContextMenu)Mockito.verify((Object)this.mockHeaderExpectedContextMenu, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.mockEventBus));
        ((GivenContextMenu)Mockito.verify((Object)this.mockGivenContextMenu, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.mockEventBus));
        ((ExpectedContextMenu)Mockito.verify((Object)this.mockExpectedContextMenu, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.mockEventBus));
        ((GridContextMenu)Mockito.verify((Object)this.mockGridContextMenu, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.mockEventBus));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.mockUnmodifiableColumnGridContextMenu, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.mockEventBus));
    }

    @Test
    public void getRelativeX() {
        int retrieved = this.scenarioSimulationGridPanelClickHandler.getRelativeX(this.contextMenuEventMock);
        Assert.assertEquals((long)80L, (long)retrieved);
    }

    @Test
    public void getRelativeY() {
        int retrieved = this.scenarioSimulationGridPanelClickHandler.getRelativeY(this.contextMenuEventMock);
        Assert.assertEquals((long)80L, (long)retrieved);
    }

    @Test
    public void commonClickManagement() {
        this.scenarioSimulationGridPanelClickHandler.hideMenus();
        ((OtherContextMenu)Mockito.verify((Object)this.mockOtherContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((HeaderGivenContextMenu)Mockito.verify((Object)this.mockHeaderGivenContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((HeaderExpectedContextMenu)Mockito.verify((Object)this.mockHeaderExpectedContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((GivenContextMenu)Mockito.verify((Object)this.mockGivenContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((ExpectedContextMenu)Mockito.verify((Object)this.mockExpectedContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((GridContextMenu)Mockito.verify((Object)this.mockGridContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.mockUnmodifiableColumnGridContextMenu, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void onContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.onContextMenu(this.contextMenuEventMock);
        ((ContextMenuEvent)Mockito.verify((Object)this.contextMenuEventMock, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((ContextMenuEvent)Mockito.verify((Object)this.contextMenuEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        this.commonCheck();
    }

    @Test
    public void testManageLeftClick() {
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.mockEventBus);
        Assert.assertTrue((String)"Click to only header cell of the only present column.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5, false, false));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.eq((int)0));
        ((EventBus)Mockito.verify((Object)this.mockEventBus)).fireEvent((GwtEvent)Matchers.any(EnableRightPanelEvent.class));
    }

    @Test
    public void testManageLeftClick_ReadOnly() {
        Mockito.when((Object)this.headerMetaDataMock.isReadOnly()).thenReturn((Object)true);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.mockEventBus);
        Assert.assertFalse((String)"Click to readonly header cell.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5, false, false));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.mockEventBus, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any(EnableRightPanelEvent.class));
    }

    @Test
    public void testManageLeftClick_NextToGrid() {
        Assert.assertFalse((String)"Click to point next to table.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(this.GRID_WIDTH.intValue() + 5, 5, false, false));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.mockEventBus, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any(EnableRightPanelEvent.class));
    }

    @Test
    public void testManageLeftClick_BelowHeader() {
        Assert.assertFalse((String)"Click to point below header.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, this.HEADER_HEIGHT.intValue() + 5, false, false));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.mockEventBus, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any(EnableRightPanelEvent.class));
    }

    @Test
    public void testManageGridLeftClickReadOnlyTrue() {
        Mockito.when((Object)this.headerMetaDataMock.isReadOnly()).thenReturn((Object)true);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.mockEventBus);
        Mockito.when((Object)this.scenarioGridCellMock.isEditing()).thenReturn((Object)true);
        boolean retrieved = this.scenarioSimulationGridPanelClickHandler.manageGridLeftClick(this.scenarioGridMock, Integer.valueOf(1), Integer.valueOf(0), this.gridColumnMock);
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.never())).setEditing(Matchers.anyBoolean());
        Assert.assertTrue((boolean)retrieved);
        Mockito.when((Object)this.scenarioGridCellMock.isEditing()).thenReturn((Object)false);
        this.scenarioSimulationGridPanelClickHandler.manageGridLeftClick(this.scenarioGridMock, Integer.valueOf(1), Integer.valueOf(0), this.gridColumnMock);
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditing(Matchers.eq((boolean)false));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).isReadOnly();
    }

    @Test
    public void testManageGridLeftClickReadOnlyFalse() {
        Mockito.when((Object)this.scenarioGridMock.startEditingCell(1, 0)).thenReturn((Object)true);
        Mockito.when((Object)this.headerMetaDataMock.isReadOnly()).thenReturn((Object)false);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.mockEventBus);
        Mockito.when((Object)this.scenarioGridCellMock.isEditing()).thenReturn((Object)true);
        boolean retrieved = this.scenarioSimulationGridPanelClickHandler.manageGridLeftClick(this.scenarioGridMock, Integer.valueOf(1), Integer.valueOf(0), this.gridColumnMock);
        Assert.assertTrue((boolean)retrieved);
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.never())).setEditing(Matchers.anyBoolean());
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.never())).isReadOnly();
        Mockito.when((Object)this.scenarioGridCellMock.isEditing()).thenReturn((Object)false);
        this.scenarioSimulationGridPanelClickHandler.manageGridLeftClick(this.scenarioGridMock, Integer.valueOf(1), Integer.valueOf(0), this.gridColumnMock);
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditing(Matchers.eq((boolean)true));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).isReadOnly();
    }

    private void commonCheck() {
        ((ScenarioSimulationGridPanelClickHandler)Mockito.verify((Object)this.scenarioSimulationGridPanelClickHandler, (VerificationMode)Mockito.times((int)1))).hideMenus();
    }
}

