/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.function.Consumer;
import org.drools.workbench.screens.scenariosimulation.client.commands.AbstractCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.AppendColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.AppendRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.CommandExecutor;
import org.drools.workbench.screens.scenariosimulation.client.commands.DeleteColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.DeleteRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.DisableRightPanelCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.DuplicateRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.EnableRightPanelCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.InsertColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.InsertRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.PrependColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.PrependRowCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.SetInstanceHeaderCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.SetPropertyHeaderCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.events.AppendColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.AppendRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DeleteRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DisableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.DuplicateRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.InsertRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.PrependColumnEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.PrependRowEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ScenarioGridReloadEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetInstanceHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetPropertyHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.popup.DeletePopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.popup.PreserveDeletePopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class CommandExecutorTest
extends AbstractCommandTest {
    @Mock
    private List<HandlerRegistration> handlerRegistrationListMock;
    @Mock
    private HandlerRegistration appendColumnHandlerRegistrationMock;
    @Mock
    private HandlerRegistration appendRowHandlerRegistrationMock;
    @Mock
    private HandlerRegistration deleteColumnHandlerRegistrationMock;
    @Mock
    private HandlerRegistration deleteRowHandlerRegistrationMock;
    @Mock
    private HandlerRegistration disableRightPanelEventHandlerMock;
    @Mock
    private HandlerRegistration duplicateHandlerRegistrationMock;
    @Mock
    private HandlerRegistration enableRightPanelEventHandlerMock;
    @Mock
    private HandlerRegistration insertColumnHandlerRegistrationMock;
    @Mock
    private HandlerRegistration insertRowHandlerRegistrationMock;
    @Mock
    private HandlerRegistration prependColumnHandlerRegistrationMock;
    @Mock
    private HandlerRegistration prependRowHandlerRegistrationMock;
    @Mock
    private HandlerRegistration reloadRightPanelHandlerRegistrationMock;
    @Mock
    private HandlerRegistration scenarioGridReloadHandlerRegistrationMock;
    @Mock
    private HandlerRegistration setInstanceHeaderEventHandlerMock;
    @Mock
    private HandlerRegistration setPropertyHeaderEventHandlerMock;
    @Mock
    private DeletePopupPresenter deletePopupPresenterMock;
    @Mock
    private PreserveDeletePopupPresenter preserveDeletePopupPresenterMock;
    private CommandExecutor commandExecutor;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)AppendColumnEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.appendColumnHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)AppendRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.appendRowHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)DeleteColumnEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.deleteColumnHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)DeleteRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.deleteRowHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)DisableRightPanelEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.disableRightPanelEventHandlerMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)DuplicateRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.duplicateHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)EnableRightPanelEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.enableRightPanelEventHandlerMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)InsertColumnEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.insertColumnHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)InsertRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.insertRowHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)PrependColumnEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.prependColumnHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)PrependRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.prependRowHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)ReloadRightPanelEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.reloadRightPanelHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)ScenarioGridReloadEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.scenarioGridReloadHandlerRegistrationMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)SetInstanceHeaderEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.setInstanceHeaderEventHandlerMock);
        Mockito.when((Object)this.eventBusMock.addHandler((GwtEvent.Type)Matchers.eq((Object)SetPropertyHeaderEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class))).thenReturn((Object)this.setPropertyHeaderEventHandlerMock);
        this.commandExecutor = (CommandExecutor)Mockito.spy((Object)new CommandExecutor(){
            {
                this.eventBus = CommandExecutorTest.this.eventBusMock;
                this.handlerRegistrationList = CommandExecutorTest.this.handlerRegistrationListMock;
                this.model = CommandExecutorTest.this.scenarioGridModelMock;
                this.scenarioGridPanel = CommandExecutorTest.this.scenarioGridPanelMock;
                this.scenarioGridLayer = CommandExecutorTest.this.scenarioGridLayerMock;
                this.scenarioSimulationEditorPresenter = CommandExecutorTest.this.scenarioSimulationEditorPresenterMock;
                this.rightPanelPresenter = CommandExecutorTest.this.rightPanelPresenterMock;
                this.deletePopupPresenter = CommandExecutorTest.this.deletePopupPresenterMock;
                this.preserveDeletePopupPresenter = CommandExecutorTest.this.preserveDeletePopupPresenterMock;
            }
        });
    }

    @Test
    public void setEventBus() {
        this.commandExecutor.setEventBus(this.eventBusMock);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).registerHandlers();
        Assert.assertEquals((Object)this.eventBusMock, (Object)this.commandExecutor.eventBus);
    }

    @Test
    public void setScenarioSimulationEditorPresenter() {
        this.commandExecutor.setScenarioSimulationEditorPresenter(this.scenarioSimulationEditorPresenterMock);
        Assert.assertEquals((Object)this.scenarioSimulationEditorPresenterMock, (Object)this.commandExecutor.scenarioSimulationEditorPresenter);
    }

    @Test
    public void setRightPanelPresenter() {
        this.commandExecutor.setRightPanelPresenter((RightPanelView.Presenter)this.rightPanelPresenterMock);
        Assert.assertEquals((Object)this.rightPanelPresenterMock, (Object)this.commandExecutor.rightPanelPresenter);
    }

    @Test
    public void setScenarioGridPanel() {
        this.commandExecutor.setScenarioGridPanel(this.scenarioGridPanelMock);
        Assert.assertEquals((Object)this.scenarioGridPanelMock, (Object)this.commandExecutor.scenarioGridPanel);
        Assert.assertEquals((Object)this.scenarioGridLayerMock, (Object)this.commandExecutor.scenarioGridLayer);
        Assert.assertEquals((Object)this.scenarioGridModelMock, (Object)this.commandExecutor.model);
    }

    @Test
    public void unregisterHandlers() {
        this.commandExecutor.unregisterHandlers();
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).forEach((Consumer)Matchers.anyObject());
    }

    @Test
    public void onAppendColumnEvent() {
        AppendColumnEvent event = new AppendColumnEvent(this.COLUMN_GROUP);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(AppendColumnCommand.class));
    }

    @Test
    public void onAppendRowEvent() {
        AppendRowEvent event = new AppendRowEvent();
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(AppendRowCommand.class));
    }

    @Test
    public void onDeleteColumnEvent() {
        DeleteColumnEvent event = new DeleteColumnEvent(3, this.COLUMN_GROUP);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedColumn()).thenReturn(null);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(DeleteColumnCommand.class));
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(DisableRightPanelCommand.class));
        Mockito.reset((Object[])new CommandExecutor[]{this.commandExecutor});
        ((ScenarioGridModel)Mockito.doReturn((Object)this.gridColumnMock).when((Object)this.scenarioGridModelMock)).getSelectedColumn();
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(DeleteColumnCommand.class));
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.never())).commonExecute((Command)Matchers.isA(DisableRightPanelCommand.class));
    }

    @Test
    public void onDeleteRowEvent() {
        DeleteRowEvent event = new DeleteRowEvent(2);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(DeleteRowCommand.class));
    }

    @Test
    public void onDisableRightPanelEvent() {
        DisableRightPanelEvent event = new DisableRightPanelEvent();
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(DisableRightPanelCommand.class));
    }

    @Test
    public void onDuplicateRowEvent() {
        DuplicateRowEvent event = new DuplicateRowEvent(2);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(DuplicateRowCommand.class));
    }

    @Test
    public void onEnableRightPanelEvent() {
        EnableRightPanelEvent event = new EnableRightPanelEvent();
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(EnableRightPanelCommand.class));
    }

    @Test
    public void onInsertColumnEvent() {
        InsertColumnEvent event = new InsertColumnEvent(3, true, false);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(InsertColumnCommand.class));
    }

    @Test
    public void onInsertRowEvent() {
        InsertRowEvent event = new InsertRowEvent(2);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(InsertRowCommand.class));
    }

    @Test
    public void onPrependColumnEvent() {
        PrependColumnEvent event = new PrependColumnEvent(this.COLUMN_GROUP);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(PrependColumnCommand.class));
    }

    @Test
    public void onPrependRowEvent() {
        PrependRowEvent event = new PrependRowEvent();
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(PrependRowCommand.class));
    }

    @Test
    public void onReloadRightPanelEvent() {
        ReloadRightPanelEvent event = new ReloadRightPanelEvent(true);
        this.commandExecutor.onEvent(event);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadRightPanel(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.scenarioSimulationEditorPresenterMock});
        event = new ReloadRightPanelEvent(false);
        this.commandExecutor.onEvent(event);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadRightPanel(Matchers.eq((boolean)false));
    }

    @Test
    public void onScenarioGridReloadEvent() {
        this.commandExecutor.scenarioGridPanel = this.scenarioGridPanelMock;
        ScenarioGridReloadEvent event = new ScenarioGridReloadEvent();
        this.commandExecutor.handle(event);
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
    }

    @Test
    public void onSetInstanceHeaderEvent() {
        SetInstanceHeaderEvent event = new SetInstanceHeaderEvent("test.scesim", "test.scesim.testclass");
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedColumn()).thenReturn(null);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.never())).commonExecute((Command)Matchers.isA(SetInstanceHeaderCommand.class));
        ((ScenarioGridModel)Mockito.doReturn((Object)this.gridColumnMock).when((Object)this.scenarioGridModelMock)).getSelectedColumn();
        Mockito.reset((Object[])new CommandExecutor[]{this.commandExecutor});
        Mockito.when((Object)this.scenarioGridModelMock.isSelectedColumnEmpty()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioGridModelMock.isSameSelectedColumnType(event.getClassName())).thenReturn((Object)true);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.never())).commonExecute((Command)Matchers.isA(SetInstanceHeaderCommand.class));
        Mockito.when((Object)this.scenarioGridModelMock.isSameSelectedColumnType(event.getClassName())).thenReturn((Object)false);
        Mockito.when((Object)this.gridColumnMock.isInstanceAssigned()).thenReturn((Object)true);
        this.commandExecutor.onEvent(event);
        ((DeletePopupPresenter)Mockito.verify((Object)this.deletePopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.changeTypeMainTitle()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.changeTypeMainQuestion()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.changeTypeText1()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.changeTypeTextQuestion()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.changeTypeTextDanger()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.changeType()), (Command)Matchers.isA(Command.class));
        Mockito.when((Object)this.gridColumnMock.isInstanceAssigned()).thenReturn((Object)false);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(SetInstanceHeaderCommand.class));
    }

    @Test
    public void onSetPropertyHeaderEvent() {
        SetPropertyHeaderEvent event = new SetPropertyHeaderEvent("test.scesim", "VALUE", this.VALUE_CLASS_NAME);
        Mockito.when((Object)this.scenarioGridModelMock.getSelectedColumn()).thenReturn(null);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.never())).commonExecute((Command)Matchers.isA(SetPropertyHeaderCommand.class));
        ((ScenarioGridModel)Mockito.doReturn((Object)this.gridColumnMock).when((Object)this.scenarioGridModelMock)).getSelectedColumn();
        Mockito.reset((Object[])new CommandExecutor[]{this.commandExecutor});
        Mockito.when((Object)this.scenarioGridModelMock.isSelectedColumnEmpty()).thenReturn((Object)true);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.times((int)1))).commonExecute((Command)Matchers.isA(SetPropertyHeaderCommand.class));
        Mockito.when((Object)this.scenarioGridModelMock.isSelectedColumnEmpty()).thenReturn((Object)false);
        Mockito.reset((Object[])new CommandExecutor[]{this.commandExecutor});
        Mockito.when((Object)this.scenarioGridModelMock.isSameSelectedColumnProperty("VALUE")).thenReturn((Object)true);
        this.commandExecutor.onEvent(event);
        ((CommandExecutor)Mockito.verify((Object)this.commandExecutor, (VerificationMode)Mockito.never())).commonExecute((Command)Matchers.isA(SetPropertyHeaderCommand.class));
        Mockito.when((Object)this.scenarioGridModelMock.isSameSelectedColumnProperty("VALUE")).thenReturn((Object)false);
        Mockito.reset((Object[])new CommandExecutor[]{this.commandExecutor});
        Mockito.when((Object)this.scenarioGridModelMock.isSameSelectedColumnType(this.VALUE_CLASS_NAME)).thenReturn((Object)true);
        this.commandExecutor.onEvent(event);
        ((PreserveDeletePopupPresenter)Mockito.verify((Object)this.preserveDeletePopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioMainTitle()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioMainQuestion()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioText1()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioTextQuestion()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioTextOption1()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.preserveDeleteScenarioTextOption2()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.preserveValues()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteValues()), (Command)Matchers.isA(Command.class), (Command)Matchers.isA(Command.class));
        Mockito.when((Object)this.scenarioGridModelMock.isSameSelectedColumnType(this.VALUE_CLASS_NAME)).thenReturn((Object)false);
        Mockito.reset((Object[])new CommandExecutor[]{this.commandExecutor});
        this.commandExecutor.onEvent(event);
        ((DeletePopupPresenter)Mockito.verify((Object)this.deletePopupPresenterMock, (VerificationMode)Mockito.times((int)1))).show((String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioMainTitle()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioMainQuestion()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioText1()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioTextQuestion()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteScenarioTextDanger()), (String)Matchers.eq((Object)ScenarioSimulationEditorConstants.INSTANCE.deleteValues()), (Command)Matchers.isA(Command.class));
    }

    @Test
    public void commonExecute() {
        this.commandExecutor.scenarioGridPanel = this.scenarioGridPanelMock;
        Command mockCommand = (Command)Mockito.mock(Command.class);
        this.commandExecutor.commonExecute(mockCommand);
        ((Command)Mockito.verify((Object)mockCommand, (VerificationMode)Mockito.times((int)1))).execute();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).select();
    }

    @Test
    public void registerHandlers() {
        this.commandExecutor.registerHandlers();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)AppendColumnEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.appendColumnHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)AppendRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.appendRowHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)DeleteColumnEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.deleteColumnHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)DeleteRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.deleteRowHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)DisableRightPanelEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.disableRightPanelEventHandlerMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)DuplicateRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.duplicateHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)EnableRightPanelEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.enableRightPanelEventHandlerMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)InsertColumnEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.insertColumnHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)InsertRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.insertRowHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)PrependColumnEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.prependColumnHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)PrependRowEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.prependRowHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)ReloadRightPanelEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.reloadRightPanelHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)ScenarioGridReloadEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.scenarioGridReloadHandlerRegistrationMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)SetInstanceHeaderEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.setInstanceHeaderEventHandlerMock));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).addHandler((GwtEvent.Type)Matchers.eq((Object)SetPropertyHeaderEvent.TYPE), (EventHandler)Matchers.isA(CommandExecutor.class));
        ((List)Mockito.verify(this.handlerRegistrationListMock, (VerificationMode)Mockito.times((int)1))).add(Matchers.eq((Object)this.setPropertyHeaderEventHandlerMock));
    }
}

