/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.widgets;

import com.ait.lienzo.client.core.event.NodeMouseDoubleClickHandler;
import com.ait.lienzo.shared.core.types.EventPropagationMode;
import java.util.List;
import java.util.stream.IntStream;
import org.drools.workbench.screens.scenariosimulation.client.factories.FactoryProvider;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelDoubleClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.renderers.ScenarioGridRenderer;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridRow;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.impl.BaseGridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.grid.renderers.grids.GridRenderer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridSelectionManager;
import org.uberfire.ext.wires.core.grids.client.widget.layer.pinning.GridPinnedModeManager;

public class ScenarioGrid
extends BaseGridWidget {
    private final ScenarioGridLayer scenarioGridLayer;
    private final ScenarioGridPanel scenarioGridPanel;

    public ScenarioGrid(ScenarioGridModel model, ScenarioGridLayer scenarioGridLayer, ScenarioGridRenderer renderer, ScenarioGridPanel scenarioGridPanel) {
        super((GridData)model, (GridSelectionManager)scenarioGridLayer, (GridPinnedModeManager)scenarioGridLayer, (GridRenderer)renderer);
        this.scenarioGridLayer = scenarioGridLayer;
        this.scenarioGridPanel = scenarioGridPanel;
        this.setDraggable(false);
        this.setEventPropagationMode(EventPropagationMode.NO_ANCESTORS);
    }

    public void setContent(Simulation simulation) {
        ((ScenarioGridModel)this.model).clear();
        ((ScenarioGridModel)this.model).bindContent(simulation);
        this.setHeaderColumns(simulation);
        this.appendRows(simulation);
    }

    public ScenarioGridModel getModel() {
        return (ScenarioGridModel)this.model;
    }

    public void clearSelections() {
        this.model.clearSelections();
    }

    public void setSelectedColumnAndHeader(int headerRowIndex, int columnIndex) {
        ((ScenarioGridModel)this.model).selectColumn(columnIndex);
        this.model.selectHeaderCell(headerRowIndex, columnIndex);
    }

    public void selectRow(int rowIndex) {
        ((ScenarioGridModel)this.model).selectRow(rowIndex);
    }

    protected NodeMouseDoubleClickHandler getGridMouseDoubleClickHandler(GridSelectionManager selectionManager, GridPinnedModeManager pinnedModeManager) {
        return new ScenarioSimulationGridPanelDoubleClickHandler((GridWidget)this, selectionManager, pinnedModeManager, this.renderer);
    }

    protected void setHeaderColumns(Simulation simulation) {
        List factMappings = simulation.getSimulationDescriptor().getUnmodifiableFactMappings();
        IntStream.range(0, factMappings.size()).forEach(columnIndex -> this.setHeaderColumn(columnIndex, (FactMapping)factMappings.get(columnIndex)));
    }

    protected void setHeaderColumn(int columnIndex, FactMapping factMapping) {
        FactIdentifier factIdentifier = factMapping.getFactIdentifier();
        String columnId = factMapping.getExpressionIdentifier().getName();
        String instanceTitle = factMapping.getFactAlias();
        String propertyTitle = factMapping.getExpressionAlias();
        String columnGroup = factMapping.getExpressionIdentifier().getType().name();
        boolean isInstanceAssigned = this.isInstanceAssigned(factIdentifier);
        boolean isPropertyAssigned = this.isPropertyAssigned(isInstanceAssigned, factMapping);
        String placeHolder = this.getPlaceholder(isPropertyAssigned);
        ScenarioGridColumn scenarioGridColumn = this.getScenarioGridColumnLocal(instanceTitle, propertyTitle, columnId, columnGroup, factMapping.getExpressionIdentifier().getType(), isPropertyAssigned, placeHolder);
        scenarioGridColumn.setInstanceAssigned(isInstanceAssigned);
        scenarioGridColumn.setPropertyAssigned(isPropertyAssigned);
        scenarioGridColumn.setReadOnly(!isPropertyAssigned);
        scenarioGridColumn.setFactIdentifier(factIdentifier);
        ((ScenarioGridModel)this.model).insertColumnGridOnly(columnIndex, (GridColumn<?>)scenarioGridColumn);
    }

    protected boolean isInstanceAssigned(FactIdentifier factIdentifier) {
        if (FactIdentifier.DESCRIPTION.equals((Object)factIdentifier)) {
            return true;
        }
        return !FactIdentifier.EMPTY.equals((Object)factIdentifier) && !FactIdentifier.INDEX.equals((Object)factIdentifier);
    }

    protected boolean isPropertyAssigned(boolean instanceAssigned, FactMapping factMapping) {
        if (FactIdentifier.DESCRIPTION.equals((Object)factMapping.getFactIdentifier())) {
            return true;
        }
        return instanceAssigned && !factMapping.getExpressionElements().isEmpty();
    }

    protected String getPlaceholder(boolean isPropertyAssigned) {
        return isPropertyAssigned ? ScenarioSimulationEditorConstants.INSTANCE.insertValue() : ScenarioSimulationEditorConstants.INSTANCE.defineValidType();
    }

    protected ScenarioHeaderTextBoxSingletonDOMElementFactory getScenarioHeaderTextBoxSingletonDOMElementFactory() {
        return FactoryProvider.getHeaderTextBoxFactory(this.scenarioGridPanel, this.scenarioGridLayer);
    }

    protected ScenarioGridColumn getScenarioGridColumnLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, boolean readOnly, String placeHolder) {
        ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader = this.getScenarioHeaderTextBoxSingletonDOMElementFactory();
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = this.getHeaderBuilderLocal(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, factoryHeader);
        return this.getScenarioGridColumnLocal(headerBuilder, readOnly, placeHolder);
    }

    protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, boolean readOnly, String placeHolder) {
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, this.scenarioGridPanel, this.scenarioGridLayer, readOnly, placeHolder);
    }

    protected ScenarioSimulationBuilders.HeaderBuilder getHeaderBuilderLocal(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader) {
        return ScenarioSimulationUtils.getHeaderBuilder(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, factoryHeader);
    }

    protected void appendRows(Simulation simulation) {
        List scenarios = simulation.getUnmodifiableScenarios();
        IntStream.range(0, scenarios.size()).forEach(rowIndex -> this.appendRow(rowIndex, (Scenario)scenarios.get(rowIndex)));
    }

    protected void appendRow(int rowIndex, Scenario scenario) {
        ((ScenarioGridModel)this.model).insertRowGridOnly(rowIndex, (GridRow)new ScenarioGridRow(), scenario);
    }
}

