/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.AbstractCommand;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;

@Dependent
public class InsertColumnCommand
extends AbstractCommand {
    private ScenarioGridModel model;
    private String columnId;
    private int columnIndex;
    private boolean isRight;
    private boolean asProperty;

    public InsertColumnCommand() {
    }

    public InsertColumnCommand(ScenarioGridModel model, String columnId, int columnIndex, boolean isRight, boolean asProperty, ScenarioGridPanel scenarioGridPanel, ScenarioGridLayer scenarioGridLayer) {
        super(scenarioGridPanel, scenarioGridLayer);
        this.model = model;
        this.columnId = columnId;
        this.columnIndex = columnIndex;
        this.isRight = isRight;
        this.asProperty = asProperty;
    }

    public void execute() {
        List columns = this.model.getColumns();
        ScenarioGridColumn selectedColumn = (ScenarioGridColumn)((Object)columns.get(this.columnIndex));
        ScenarioHeaderMetaData selectedInformationHeaderMetaData = selectedColumn.getInformationHeaderMetaData();
        String columnGroup = selectedInformationHeaderMetaData.getColumnGroup();
        String originalInstanceTitle = selectedInformationHeaderMetaData.getTitle();
        FactMappingType factMappingType = FactMappingType.valueOf((String)columnGroup.toUpperCase());
        Map.Entry<String, String> validPlaceholders = this.model.getValidPlaceholders();
        boolean cloneInstance = this.asProperty && selectedColumn.isInstanceAssigned();
        String instanceTitle = cloneInstance ? originalInstanceTitle : validPlaceholders.getKey();
        String propertyTitle = validPlaceholders.getValue();
        String placeHolder = ScenarioSimulationEditorConstants.INSTANCE.defineValidType();
        ScenarioGridColumn scenarioGridColumnLocal = this.getScenarioGridColumnLocal(instanceTitle, propertyTitle, this.columnId, columnGroup, factMappingType, this.scenarioGridPanel, this.scenarioGridLayer, placeHolder);
        scenarioGridColumnLocal.setInstanceAssigned(cloneInstance);
        scenarioGridColumnLocal.setPropertyAssigned(false);
        if (cloneInstance) {
            scenarioGridColumnLocal.setFactIdentifier(selectedColumn.getFactIdentifier());
        }
        int columnPosition = -1;
        if (this.asProperty) {
            columnPosition = this.isRight ? this.columnIndex + 1 : this.columnIndex;
        } else {
            GridData.Range instanceRange = this.model.getInstanceLimits(this.columnIndex);
            columnPosition = this.isRight ? instanceRange.getMaxRowIndex() + 1 : instanceRange.getMinRowIndex();
        }
        this.model.insertColumn(columnPosition, (GridColumn<?>)scenarioGridColumnLocal);
    }
}

