/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.ButtonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.AbstractCollectionEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementView;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class ElementPresenterTest<E extends ElementView, T extends ElementView.Presenter<E>>
extends AbstractCollectionEditorTest {
    protected static final String ELEMENT1_ID = "ELEMENT1_ID";
    protected static final String ELEMENT2_ID = "ELEMENT2_ID";
    protected T elementPresenter;
    protected List<E> elementViewListLocal = new ArrayList();
    protected E elementView1Mock;
    protected E elementView2Mock;
    @Mock
    protected ButtonElement editItemButtonMock;
    @Mock
    protected ButtonElement deleteItemButtonMock;

    @Override
    protected void setup() {
        super.setup();
        Mockito.when((Object)this.elementView1Mock.getEditItemButton()).thenReturn((Object)this.editItemButtonMock);
        Mockito.when((Object)this.elementView2Mock.getEditItemButton()).thenReturn((Object)this.editItemButtonMock);
        Mockito.when((Object)this.elementView1Mock.getDeleteItemButton()).thenReturn((Object)this.deleteItemButtonMock);
        Mockito.when((Object)this.elementView2Mock.getDeleteItemButton()).thenReturn((Object)this.deleteItemButtonMock);
        Mockito.when((Object)this.elementView1Mock.getItemId()).thenReturn((Object)ELEMENT1_ID);
        Mockito.when((Object)this.elementView2Mock.getItemId()).thenReturn((Object)ELEMENT2_ID);
        Mockito.when((Object)this.elementView1Mock.getItemSeparator()).thenReturn((Object)this.itemSeparatorMock);
        Mockito.when((Object)this.elementView1Mock.getItemSeparator()).thenReturn((Object)this.itemSeparatorMock);
        Mockito.when((Object)this.elementView1Mock.getFaAngleRight()).thenReturn((Object)this.faAngleRightMock);
        Mockito.when((Object)this.elementView2Mock.getFaAngleRight()).thenReturn((Object)this.faAngleRightMock);
        Mockito.when((Object)this.elementView1Mock.getItemContainer()).thenReturn((Object)this.itemContainerMock);
        Mockito.when((Object)this.elementView2Mock.getItemContainer()).thenReturn((Object)this.itemContainerMock);
        Mockito.when((Object)this.elementView1Mock.getInnerItemContainer()).thenReturn((Object)this.innerItemContainerMock);
        Mockito.when((Object)this.elementView2Mock.getInnerItemContainer()).thenReturn((Object)this.innerItemContainerMock);
        Mockito.when((Object)this.elementView1Mock.getSaveChange()).thenReturn((Object)this.saveChangeMock);
        Mockito.when((Object)this.elementView2Mock.getSaveChange()).thenReturn((Object)this.saveChangeMock);
        this.elementViewListLocal.add(this.elementView1Mock);
        this.elementViewListLocal.add(this.elementView2Mock);
        for (String el : Arrays.asList(ELEMENT1_ID, ELEMENT2_ID)) {
            Mockito.when((Object)this.propertyPresenterMock.getProperties((String)Matchers.eq((Object)(el + "#KEY")))).thenReturn(new HashMap());
            Mockito.when((Object)this.propertyPresenterMock.getProperties((String)Matchers.eq((Object)(el + "#VALUE")))).thenReturn(new HashMap());
        }
    }

    @Test
    public void onToggleRowExpansionTrue() {
        this.commonOnToggleRowExpansion(true);
    }

    @Test
    public void onToggleRowExpansionFalse() {
        this.commonOnToggleRowExpansion(false);
    }

    @Test
    public void remove() {
        this.elementPresenter.remove();
        this.elementViewListLocal.forEach(elementViewMock -> ((ElementView.Presenter)Mockito.verify(this.elementPresenter, (VerificationMode)Mockito.times((int)1))).onDeleteItem((ElementView)Matchers.eq((Object)elementViewMock)));
    }

    @Test
    public void toggleEditItemButtonStatusToDisableTrue() {
        this.elementPresenter.toggleEditingStatus(true);
        this.elementViewListLocal.forEach(elementViewMock -> {
            ((ElementView)Mockito.verify((Object)elementViewMock, (VerificationMode)Mockito.times((int)1))).getEditItemButton();
            ((ElementView)Mockito.verify((Object)elementViewMock, (VerificationMode)Mockito.times((int)1))).getDeleteItemButton();
        });
        ((ButtonElement)Mockito.verify((Object)this.editItemButtonMock, (VerificationMode)Mockito.times((int)2))).setDisabled(true);
        ((ButtonElement)Mockito.verify((Object)this.deleteItemButtonMock, (VerificationMode)Mockito.times((int)2))).setDisabled(true);
    }

    @Test
    public void toggleEditItemButtonStatusToDisableFalse() {
        this.elementPresenter.toggleEditingStatus(false);
        this.elementViewListLocal.forEach(elementViewMock -> {
            ((ElementView)Mockito.verify((Object)elementViewMock, (VerificationMode)Mockito.times((int)1))).getEditItemButton();
            ((ElementView)Mockito.verify((Object)elementViewMock, (VerificationMode)Mockito.times((int)1))).getDeleteItemButton();
        });
        ((ButtonElement)Mockito.verify((Object)this.editItemButtonMock, (VerificationMode)Mockito.times((int)2))).setDisabled(false);
        ((ButtonElement)Mockito.verify((Object)this.deleteItemButtonMock, (VerificationMode)Mockito.times((int)2))).setDisabled(false);
    }

    private void commonOnToggleRowExpansion(boolean isShown) {
        this.elementPresenter.onToggleRowExpansion(isShown);
        this.elementViewListLocal.forEach(elementViewMock -> ((ElementView.Presenter)Mockito.verify(this.elementPresenter, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion((ElementView)Matchers.eq((Object)elementViewMock), Matchers.eq((boolean)isShown)));
    }
}

