/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.List;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetInstanceHeaderCommand;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@RunWith(value=GwtMockitoTestRunner.class)
public class SetInstanceHeaderCommandTest
extends AbstractScenarioSimulationCommandTest {
    @Mock
    private List<GridColumn<?>> mockGridColumns;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.mockGridColumns.indexOf(this.gridColumnMock)).thenReturn((Object)3);
        Mockito.when((Object)this.scenarioGridModelMock.getColumns()).thenReturn(this.mockGridColumns);
        this.command = (AbstractScenarioSimulationCommand)Mockito.spy((Object)new SetInstanceHeaderCommand(){

            protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, ScenarioSimulationContext context) {
                return SetInstanceHeaderCommandTest.this.gridColumnMock;
            }

            protected Optional<FactIdentifier> getFactIdentifierByColumnTitle(String columnTitle, ScenarioSimulationContext context) {
                return Optional.empty();
            }
        });
        Assert.assertTrue((boolean)this.command.isUndoable());
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
    }

    @Test
    public void executeNoColumn() {
        this.gridColumnMock = null;
        this.command.execute(this.scenarioSimulationContextLocal);
        ((SetInstanceHeaderCommand)Mockito.verify((Object)((SetInstanceHeaderCommand)this.command), (VerificationMode)Mockito.never())).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.gridColumnMock);
    }

    @Test
    public void executeDMN() {
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        this.scenarioSimulationContextLocal.getStatus().setClassName(this.VALUE_CLASS_NAME);
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.DMN);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setEditableHeaders(Matchers.eq((boolean)false));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.atLeastOnce())).getInformationHeaderMetaData();
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)this.VALUE_CLASS_NAME));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned(Matchers.eq((boolean)true));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(Matchers.eq((boolean)false));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnInstance(Matchers.eq((int)3), (GridColumn)Matchers.eq((Object)this.gridColumnMock));
    }

    @Test
    public void executeRULE() {
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        this.scenarioSimulationContextLocal.getStatus().setClassName(this.VALUE_CLASS_NAME);
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setEditableHeaders(Matchers.eq((boolean)true));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.atLeastOnce())).getInformationHeaderMetaData();
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)this.VALUE_CLASS_NAME));
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setInstanceAssigned(Matchers.eq((boolean)true));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(Matchers.eq((boolean)false));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnInstance(Matchers.eq((int)3), (GridColumn)Matchers.eq((Object)this.gridColumnMock));
    }
}

