/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetPropertyHeaderCommand;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

@RunWith(value=GwtMockitoTestRunner.class)
public class SetPropertyHeaderCommandTest
extends AbstractScenarioSimulationCommandTest {
    @Mock
    private List<GridColumn<?>> gridColumnsMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.gridColumnsMock.indexOf(this.gridColumnMock)).thenReturn((Object)3);
        this.command = (AbstractScenarioSimulationCommand)Mockito.spy((Object)new SetPropertyHeaderCommand(){

            protected ScenarioGridColumn getScenarioGridColumnLocal(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, ScenarioSimulationContext context) {
                return SetPropertyHeaderCommandTest.this.gridColumnMock;
            }
        });
        this.scenarioSimulationContextLocal.getStatus().setFullPackage("test.scesim");
        this.scenarioSimulationContextLocal.getStatus().setValue("value");
        this.scenarioSimulationContextLocal.getStatus().setValueClassName(this.VALUE_CLASS_NAME);
        Assert.assertTrue((boolean)this.command.isUndoable());
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
    }

    @Test
    public void executeNoColumn() {
        this.gridColumnMock = null;
        this.command.execute(this.scenarioSimulationContextLocal);
        ((SetPropertyHeaderCommand)Mockito.verify((Object)((SetPropertyHeaderCommand)this.command), (VerificationMode)Mockito.never())).executeIfSelectedColumn(this.scenarioSimulationContextLocal, this.gridColumnMock);
    }

    @Test
    public void executeKeepDataFalseDMN() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(false);
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.DMN);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setEditableHeaders(Matchers.eq((boolean)false));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(Matchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle("value");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(false);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(Matchers.anyInt(), (GridColumn)Matchers.isA(ScenarioGridColumn.class), (String)Matchers.eq((Object)"value"), (String)Matchers.eq((Object)this.VALUE_CLASS_NAME), Matchers.eq((boolean)false));
    }

    @Test
    public void executeKeepDataFalseRule() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(false);
        Mockito.when((Object)this.simulationDescriptorMock.getType()).thenReturn((Object)ScenarioSimulationModel.Type.RULE);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((ScenarioGridColumn)Mockito.verify((Object)this.gridColumnMock, (VerificationMode)Mockito.times((int)1))).setEditableHeaders(Matchers.eq((boolean)true));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(Matchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle("value");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(false);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(Matchers.anyInt(), (GridColumn)Matchers.isA(ScenarioGridColumn.class), (String)Matchers.eq((Object)"value"), (String)Matchers.eq((Object)this.VALUE_CLASS_NAME), Matchers.eq((boolean)false));
    }

    @Test
    public void executeKeepDataTrue() {
        this.scenarioSimulationContextLocal.getStatus().setKeepData(true);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setColumnGroup(Matchers.anyString());
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle("value");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.propertyHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setReadOnly(false);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateColumnProperty(Matchers.anyInt(), (GridColumn)Matchers.eq((Object)this.gridColumnMock), (String)Matchers.eq((Object)"value"), (String)Matchers.eq((Object)this.VALUE_CLASS_NAME), Matchers.eq((boolean)true));
    }

    @Test
    public void navigateComplexObject() {
        FactModelTree book = new FactModelTree("Book", "com.Book", new HashMap(), new HashMap());
        book.addExpandableProperty("author", "Author");
        FactModelTree author = new FactModelTree("Author", "com.Author", new HashMap(), new HashMap());
        SortedMap sortedMap = (SortedMap)Mockito.spy(new TreeMap());
        sortedMap.put("Book", book);
        sortedMap.put("Author", author);
        List<String> elements = Arrays.asList("Book", "author", "currentlyPrinted");
        FactModelTree target = ((SetPropertyHeaderCommand)this.command).navigateComplexObject(book, elements, sortedMap);
        Assert.assertEquals((Object)target, (Object)author);
        ((SortedMap)Mockito.verify((Object)sortedMap, (VerificationMode)Mockito.times((int)1))).get("Author");
    }
}

