/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.Set;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractColumnMenuPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.AbstractHeaderMenuPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.ExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.GridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderExpectedContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.HeaderGivenContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.OtherContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.editor.menu.UnmodifiableColumnGridContextMenu;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationGridPanelClickHandlerTest
extends AbstractScenarioSimulationGridHandlerTest {
    private ScenarioSimulationGridPanelClickHandler scenarioSimulationGridPanelClickHandler;
    @Mock
    private OtherContextMenu otherContextMenuMock;
    @Mock
    private HeaderGivenContextMenu headerGivenContextMenuMock;
    @Mock
    private HeaderExpectedContextMenu headerExpectContextMenuMock;
    @Mock
    private GivenContextMenu givenContextMenuMock;
    @Mock
    private ExpectedContextMenu expectContextMenuMock;
    @Mock
    private GridContextMenu gridContextMenuMock;
    @Mock
    private UnmodifiableColumnGridContextMenu nnmodifiableColumnGridContextMenuMock;
    @Mock
    private Set<AbstractHeaderMenuPresenter> managedMenusMock;
    @Mock
    private EventBus eventBusMock;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.scenarioSimulationGridPanelClickHandler = (ScenarioSimulationGridPanelClickHandler)Mockito.spy((Object)new ScenarioSimulationGridPanelClickHandler(){
            {
                this.scenarioGrid = ScenarioSimulationGridPanelClickHandlerTest.this.scenarioGridMock;
                this.otherContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.otherContextMenuMock;
                this.headerGivenContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.headerGivenContextMenuMock;
                this.headerExpectedContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.headerExpectContextMenuMock;
                this.givenContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.givenContextMenuMock;
                this.expectedContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.expectContextMenuMock;
                this.gridContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.gridContextMenuMock;
                this.unmodifiableColumnGridContextMenu = ScenarioSimulationGridPanelClickHandlerTest.this.nnmodifiableColumnGridContextMenuMock;
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.otherContextMenuMock);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.headerGivenContextMenuMock);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.headerExpectContextMenuMock);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.givenContextMenuMock);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.expectContextMenuMock);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.gridContextMenuMock);
                this.managedMenus.add(ScenarioSimulationGridPanelClickHandlerTest.this.nnmodifiableColumnGridContextMenuMock);
                this.eventBus = ScenarioSimulationGridPanelClickHandlerTest.this.eventBusMock;
                this.rendererHelper = ScenarioSimulationGridPanelClickHandlerTest.this.scenarioGridRendererHelperMock;
            }

            protected boolean manageRightClick(ContextMenuEvent event) {
                return true;
            }
        });
        this.managedMenusMock = (Set)Mockito.spy((Object)this.scenarioSimulationGridPanelClickHandler.managedMenus);
    }

    @Test
    public void setScenarioGrid() {
        this.scenarioSimulationGridPanelClickHandler.setScenarioGrid(this.scenarioGridMock);
        Assert.assertEquals((Object)this.scenarioGridMock, (Object)this.scenarioSimulationGridPanelClickHandler.scenarioGrid);
    }

    @Test
    public void setOtherContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setOtherContextMenu(this.otherContextMenuMock);
        Assert.assertEquals((Object)this.otherContextMenuMock, (Object)this.scenarioSimulationGridPanelClickHandler.otherContextMenu);
    }

    @Test
    public void setHeaderGivenContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setHeaderGivenContextMenu(this.headerGivenContextMenuMock);
        Assert.assertEquals((Object)this.headerGivenContextMenuMock, (Object)this.scenarioSimulationGridPanelClickHandler.headerGivenContextMenu);
    }

    @Test
    public void setHeaderExpectedContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setHeaderExpectedContextMenu(this.headerExpectContextMenuMock);
        Assert.assertEquals((Object)this.headerExpectContextMenuMock, (Object)this.scenarioSimulationGridPanelClickHandler.headerExpectedContextMenu);
    }

    @Test
    public void setGivenContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setGivenContextMenu(this.givenContextMenuMock);
        Assert.assertEquals((Object)this.givenContextMenuMock, (Object)this.scenarioSimulationGridPanelClickHandler.givenContextMenu);
    }

    @Test
    public void setExpectedContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setExpectedContextMenu(this.expectContextMenuMock);
        Assert.assertEquals((Object)this.expectContextMenuMock, (Object)this.scenarioSimulationGridPanelClickHandler.expectedContextMenu);
    }

    @Test
    public void setGridContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setGridContextMenu(this.gridContextMenuMock);
        Assert.assertEquals((Object)this.gridContextMenuMock, (Object)this.scenarioSimulationGridPanelClickHandler.gridContextMenu);
    }

    @Test
    public void setUnmodifiableColumnGridContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.setUnmodifiableColumnGridContextMenu(this.nnmodifiableColumnGridContextMenuMock);
        Assert.assertEquals((Object)this.nnmodifiableColumnGridContextMenuMock, (Object)this.scenarioSimulationGridPanelClickHandler.unmodifiableColumnGridContextMenu);
    }

    @Test
    public void setEventBus() {
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.eventBusMock);
        ((OtherContextMenu)Mockito.verify((Object)this.otherContextMenuMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
        ((HeaderGivenContextMenu)Mockito.verify((Object)this.headerGivenContextMenuMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
        ((HeaderExpectedContextMenu)Mockito.verify((Object)this.headerExpectContextMenuMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
        ((GivenContextMenu)Mockito.verify((Object)this.givenContextMenuMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
        ((ExpectedContextMenu)Mockito.verify((Object)this.expectContextMenuMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.nnmodifiableColumnGridContextMenuMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
    }

    @Test
    public void onContextMenu() {
        this.scenarioSimulationGridPanelClickHandler.onContextMenu(this.contextMenuEventMock);
        ((ContextMenuEvent)Mockito.verify((Object)this.contextMenuEventMock, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((ContextMenuEvent)Mockito.verify((Object)this.contextMenuEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        this.commonCheck();
    }

    @Test
    public void hideMenus() {
        this.scenarioSimulationGridPanelClickHandler.hideMenus();
        ((OtherContextMenu)Mockito.verify((Object)this.otherContextMenuMock, (VerificationMode)Mockito.times((int)1))).hide();
        ((HeaderGivenContextMenu)Mockito.verify((Object)this.headerGivenContextMenuMock, (VerificationMode)Mockito.times((int)1))).hide();
        ((HeaderExpectedContextMenu)Mockito.verify((Object)this.headerExpectContextMenuMock, (VerificationMode)Mockito.times((int)1))).hide();
        ((GivenContextMenu)Mockito.verify((Object)this.givenContextMenuMock, (VerificationMode)Mockito.times((int)1))).hide();
        ((ExpectedContextMenu)Mockito.verify((Object)this.expectContextMenuMock, (VerificationMode)Mockito.times((int)1))).hide();
        ((GridContextMenu)Mockito.verify((Object)this.gridContextMenuMock, (VerificationMode)Mockito.times((int)1))).hide();
        ((UnmodifiableColumnGridContextMenu)Mockito.verify((Object)this.nnmodifiableColumnGridContextMenuMock, (VerificationMode)Mockito.times((int)1))).hide();
    }

    @Test
    public void testManageHeaderRightClick_NOGroupGIVENTitle() {
        this.commonTestManageHeaderRightClick_NOGroupTitle("GIVEN", (AbstractHeaderMenuPresenter)this.headerGivenContextMenuMock);
    }

    @Test
    public void testManageHeaderRightClick_NOGroupHEADERTitle() {
        this.commonTestManageHeaderRightClick_NOGroupTitle("EXPECT", (AbstractHeaderMenuPresenter)this.headerExpectContextMenuMock);
    }

    @Test
    public void testManageHeaderRightClick_NOGroupOTHERTitle() {
        this.commonTestManageHeaderRightClick_NOGroupTitle("OTHER", (AbstractHeaderMenuPresenter)this.otherContextMenuMock);
    }

    @Test
    public void testManageHeaderRightClick_GIVENGroup() {
        this.commonTestManageHeaderRightClick_Group("GIVEN", (AbstractColumnMenuPresenter)this.givenContextMenuMock);
    }

    @Test
    public void testManageHeaderRightClick_EXPECTGroup() {
        this.commonTestManageHeaderRightClick_Group("EXPECT", (AbstractColumnMenuPresenter)this.expectContextMenuMock);
    }

    @Test
    public void testManageHeaderRightClick_OTHERGroup() {
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"OTHER");
        this.scenarioSimulationGridPanelClickHandler.manageHeaderRightClick(this.scenarioGridMock, 10, 10, this.point2DMock, Integer.valueOf(1));
        ((OtherContextMenu)Mockito.verify((Object)this.otherContextMenuMock, (VerificationMode)Mockito.times((int)1))).show(Matchers.eq((int)10), Matchers.eq((int)10));
        Mockito.reset((Object[])new OtherContextMenu[]{this.otherContextMenuMock});
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"OTHER-SOMETHING");
        this.scenarioSimulationGridPanelClickHandler.manageHeaderRightClick(this.scenarioGridMock, 10, 10, this.point2DMock, Integer.valueOf(1));
        ((OtherContextMenu)Mockito.verify((Object)this.otherContextMenuMock, (VerificationMode)Mockito.times((int)1))).show(Matchers.eq((int)10), Matchers.eq((int)10));
    }

    @Test
    public void testManageLeftClick() {
        Mockito.when((Object)this.point2DMock.getX()).thenReturn((Object)5.0);
        Mockito.when((Object)this.point2DMock.getY()).thenReturn((Object)5.0);
        Assert.assertTrue((String)"testManageLeftClick fail", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
    }

    @Test
    public void testManageLeftClick_ReadOnly() {
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)true);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.eventBusMock);
        Assert.assertTrue((String)"Click to readonly header cell.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.any(EnableRightPanelEvent.class));
    }

    @Test
    public void testManageLeftClick_NextToGrid() {
        Assert.assertFalse((String)"Click to point next to table.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(this.GRID_WIDTH.intValue() + 5, 5));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any(EnableRightPanelEvent.class));
    }

    @Test
    public void testManageLeftClick_BelowHeader() {
        Assert.assertFalse((String)"Click to point below header.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, this.HEADER_HEIGHT.intValue() + 5));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any(EnableRightPanelEvent.class));
    }

    @Test
    public void testManageHeaderLeftClick_NoEditableHeader() {
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)true);
        Assert.assertTrue((String)"NoEditableHeader fail", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
    }

    @Test
    public void testManageHeaderLeftClick_NullUIHeaderRowIndex() {
        Assert.assertFalse((String)"NullUIHeaderRowIndex fail", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 15));
    }

    @Test
    public void testManageHeaderLeftClick_NullMetadata() {
        Mockito.when(this.headerMetaDatasMock.get(Matchers.anyInt())).thenReturn(null);
        Assert.assertFalse((String)"NullMetadata fail", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
    }

    @Test
    public void testManageHeaderLeftClick_GIVENGroup() {
        this.commontTestManageHeaderLeftClick_Group("GIVEN", true);
    }

    @Test
    public void testManageHeaderLeftClick_EXPECTGroup() {
        this.commontTestManageHeaderLeftClick_Group("EXPECT", true);
    }

    @Test
    public void testManageHeaderLeftClick_OTHERGroup() {
        this.commontTestManageHeaderLeftClick_Group("OTHER", false);
    }

    @Test
    public void testManageGridLeftClickReadOnlyTrue() {
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)true);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.eventBusMock);
        Mockito.when((Object)this.scenarioGridCellMock.isEditingMode()).thenReturn((Object)false);
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn(null).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiHeaderRowIndexLocal((Point2D)Matchers.isA(Point2D.class));
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)1).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiRowIndexLocal(Matchers.anyDouble());
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)0).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiColumnIndexLocal(Matchers.anyDouble());
        Assert.assertTrue((boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).selectCell(Matchers.eq((int)1), Matchers.eq((int)0));
    }

    @Test
    public void testManageGridLeftClickReadOnlyFalse() {
        Mockito.when((Object)this.scenarioGridMock.startEditingCell(1, 0)).thenReturn((Object)true);
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)false);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.eventBusMock);
        Mockito.when((Object)this.scenarioGridCellMock.isEditingMode()).thenReturn((Object)false);
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn(null).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiHeaderRowIndexLocal((Point2D)Matchers.isA(Point2D.class));
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)1).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiRowIndexLocal(Matchers.anyDouble());
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)0).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiColumnIndexLocal(Matchers.anyDouble());
        ((ScenarioGridModel)Mockito.doReturn((Object)this.scenarioGridCellMock).when((Object)this.scenarioGridModelMock)).getCell(1, 0);
        Assert.assertTrue((boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).selectCell(Matchers.eq((int)1), Matchers.eq((int)0));
    }

    @Test
    public void testManageHeaderRightClick_NullMetadata() {
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn(null).when((Object)this.scenarioSimulationGridPanelClickHandler)).getColumnScenarioHeaderMetaDataLocal(this.point2DMock);
        Assert.assertFalse((boolean)this.scenarioSimulationGridPanelClickHandler.manageHeaderRightClick(this.scenarioGridMock, 10, 10, this.point2DMock, Integer.valueOf(1)));
        ((ScenarioSimulationGridPanelClickHandler)Mockito.verify((Object)this.scenarioSimulationGridPanelClickHandler, (VerificationMode)Mockito.never())).getUiHeaderRowIndexLocal((Point2D)Matchers.eq((Object)this.point2DMock));
    }

    @Test
    public void testManageHeaderRightClick_NullUIHeaderRowIndex() {
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)this.informationHeaderMetaDataMock).when((Object)this.scenarioSimulationGridPanelClickHandler)).getColumnScenarioHeaderMetaDataLocal(this.point2DMock);
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn(null).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiHeaderRowIndexLocal(this.point2DMock);
        Assert.assertFalse((boolean)this.scenarioSimulationGridPanelClickHandler.manageHeaderRightClick(this.scenarioGridMock, 10, 10, this.point2DMock, Integer.valueOf(1)));
        ((ScenarioSimulationGridPanelClickHandler)Mockito.verify((Object)this.scenarioSimulationGridPanelClickHandler, (VerificationMode)Mockito.times((int)1))).getUiHeaderRowIndexLocal((Point2D)Matchers.eq((Object)this.point2DMock));
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).getColumnGroup();
    }

    private void commontTestManageHeaderLeftClick_Group(String group, boolean assertExpected) {
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)1).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiHeaderRowIndexLocal(this.point2DMock);
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)false);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)group);
        String message = group + "Group fail";
        if (!assertExpected) {
            Assert.assertFalse((String)message, (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
            ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.eq((int)0), Matchers.eq((int)0));
            ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any());
            return;
        }
        Assert.assertTrue((String)message, (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).setSelectedColumnAndHeader(Matchers.eq((int)0), Matchers.eq((int)0));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(EnableRightPanelEvent.class));
    }

    private void commonTestManageHeaderRightClick_NOGroupTitle(String group, AbstractHeaderMenuPresenter menuMock) {
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getTitle()).thenReturn((Object)group);
        this.scenarioSimulationGridPanelClickHandler.manageHeaderRightClick(this.scenarioGridMock, 10, 10, this.point2DMock, Integer.valueOf(1));
        ((AbstractHeaderMenuPresenter)Mockito.verify((Object)menuMock, (VerificationMode)Mockito.times((int)1))).show(Matchers.eq((int)10), Matchers.eq((int)10));
    }

    private void commonTestManageHeaderRightClick_Group(String group, AbstractColumnMenuPresenter menuMock) {
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)group);
        this.scenarioSimulationGridPanelClickHandler.manageHeaderRightClick(this.scenarioGridMock, 10, 10, this.point2DMock, Integer.valueOf(1));
        ((AbstractColumnMenuPresenter)Mockito.verify((Object)menuMock, (VerificationMode)Mockito.times((int)1))).show(Matchers.eq((int)10), Matchers.eq((int)10), Matchers.eq((int)1), (String)Matchers.eq((Object)group), Matchers.anyBoolean());
        Mockito.reset((Object[])new AbstractColumnMenuPresenter[]{menuMock});
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)(group + "-SOMETHING"));
        this.scenarioSimulationGridPanelClickHandler.manageHeaderRightClick(this.scenarioGridMock, 10, 10, this.point2DMock, Integer.valueOf(1));
        ((AbstractColumnMenuPresenter)Mockito.verify((Object)menuMock, (VerificationMode)Mockito.times((int)1))).show(Matchers.eq((int)10), Matchers.eq((int)10), Matchers.eq((int)1), (String)Matchers.eq((Object)group), Matchers.anyBoolean());
    }

    private void commonCheck() {
        ((ScenarioSimulationGridPanelClickHandler)Mockito.verify((Object)this.scenarioSimulationGridPanelClickHandler, (VerificationMode)Mockito.times((int)1))).hideMenus();
    }
}

