/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.models;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadRightPanelEvent;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.values.ScenarioGridCellValue;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.model.GridRow;
import org.uberfire.ext.wires.core.grids.client.model.impl.BaseGridRow;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioGridModelTest {
    private ScenarioGridModel scenarioGridModel;
    @Mock
    private ScenarioGridColumn scenarioGridColumnMock;
    @Mock
    private ScenarioGridColumn scenarioIndexGridColumnMock;
    @Mock
    private BaseGridRow gridRowMock;
    @Mock
    private ScenarioHeaderMetaData groupHeaderMetaDataMock;
    @Mock
    private ScenarioHeaderMetaData informationHeaderMetaDataMock;
    @Mock
    private ScenarioHeaderMetaData propertyHeaderMetaDataMock;
    @Mock
    private ScenarioHeaderMetaData indexHeaderMetaDataMock;
    @Mock
    private ScenarioGridCell gridCellMock;
    @Mock
    private ScenarioGridCellValue gridCellValueMock;
    @Mock
    private EventBus eventBusMock;
    @Mock
    private Simulation simulationMock;
    @Mock
    private SimulationDescriptor simulationDescriptorMock;
    @Mock
    private Scenario scenarioMock;
    @Mock
    private FactMapping factMappingMock;
    private List<FactMappingValue> factMappingValuesLocal = new ArrayList<FactMappingValue>();
    @Mock
    private FactMappingValue factMappingValueMock;
    private List<GridColumn.HeaderMetaData> headerMetaDataList = new ArrayList<GridColumn.HeaderMetaData>();
    private List<GridRow> gridRows = new ArrayList<GridRow>();
    private List<GridColumn<?>> gridColumns = new ArrayList();
    private Supplier<GridCell<?>> gridCellSupplier;
    private final String GRID_COLUMN_TITLE = "GRID_COLUMN_TITLE";
    private final String GRID_PROPERTY_TITLE = "GRID_PROPERTY_TITLE";
    private final String GRID_COLUMN_GROUP = "GIVEN";
    private final String GRID_COLUMN_ID = "GRID_COLUMN_ID";
    private final String GRID_CELL_TEXT = "GRID_CELL_TEXT";
    private final String FULL_PACKAGE = "test.scesim";
    private final String VALUE = "VALUE";
    private final String VALUE_CLASS_NAME = String.class.getName();
    private final int ROW_COUNT = 4;
    private final int ROW_INDEX = 3;
    private final int COLUMN_INDEX = 5;

    @Before
    public void setup() {
        this.headerMetaDataList.add((GridColumn.HeaderMetaData)this.groupHeaderMetaDataMock);
        this.headerMetaDataList.add((GridColumn.HeaderMetaData)this.informationHeaderMetaDataMock);
        this.headerMetaDataList.add((GridColumn.HeaderMetaData)this.propertyHeaderMetaDataMock);
        ((ScenarioGridCell)Mockito.doReturn((Object)this.gridCellValueMock).when((Object)this.gridCellMock)).getValue();
        Mockito.when((Object)this.informationHeaderMetaDataMock.isInstanceHeader()).thenReturn((Object)true);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getTitle()).thenReturn((Object)"GRID_COLUMN_TITLE");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"GIVEN");
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnId()).thenReturn((Object)"GRID_COLUMN_ID");
        Mockito.when((Object)this.propertyHeaderMetaDataMock.isInstanceHeader()).thenReturn((Object)false);
        Mockito.when((Object)this.propertyHeaderMetaDataMock.getTitle()).thenReturn((Object)"GRID_PROPERTY_TITLE");
        Mockito.when((Object)this.propertyHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)"GIVEN");
        Mockito.when((Object)this.propertyHeaderMetaDataMock.getColumnId()).thenReturn((Object)"GRID_COLUMN_ID");
        Mockito.when((Object)this.indexHeaderMetaDataMock.getTitle()).thenReturn((Object)ExpressionIdentifier.INDEX.getName());
        Mockito.when((Object)this.scenarioIndexGridColumnMock.getInformationHeaderMetaData()).thenReturn((Object)this.indexHeaderMetaDataMock);
        Mockito.when((Object)this.scenarioGridColumnMock.getPropertyHeaderMetaData()).thenReturn((Object)this.propertyHeaderMetaDataMock);
        Mockito.when((Object)this.scenarioGridColumnMock.getInformationHeaderMetaData()).thenReturn((Object)this.informationHeaderMetaDataMock);
        Mockito.when((Object)this.scenarioGridColumnMock.getHeaderMetaData()).thenReturn(this.headerMetaDataList);
        IntStream.range(0, 6).forEach(columnIndex -> {
            this.gridColumns.add((GridColumn<?>)this.scenarioGridColumnMock);
            this.factMappingValuesLocal.add(this.factMappingValueMock);
            Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(columnIndex)).thenReturn((Object)this.factMappingMock);
        });
        ((SimulationDescriptor)Mockito.doReturn((Object)this.factMappingMock).when((Object)this.simulationDescriptorMock)).addFactMapping(Matchers.anyInt(), Matchers.anyString(), (FactIdentifier)Matchers.anyObject(), (ExpressionIdentifier)Matchers.anyObject());
        Mockito.when((Object)this.simulationMock.getSimulationDescriptor()).thenReturn((Object)this.simulationDescriptorMock);
        Mockito.when((Object)this.gridCellMock.getValue()).thenReturn((Object)this.gridCellValueMock);
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"GRID_CELL_TEXT");
        Mockito.when((Object)this.scenarioMock.getUnmodifiableFactMappingValues()).thenReturn(this.factMappingValuesLocal);
        IntStream.range(0, 4).forEach(rowIndex -> {
            Mockito.when((Object)this.simulationMock.addScenario(rowIndex)).thenReturn((Object)this.scenarioMock);
            Mockito.when((Object)this.simulationMock.getScenarioByIndex(rowIndex)).thenReturn((Object)this.scenarioMock);
            Mockito.when((Object)this.simulationMock.cloneScenario(rowIndex, rowIndex + 1)).thenReturn((Object)this.scenarioMock);
            this.gridRows.add((GridRow)this.gridRowMock);
        });
        Mockito.when((Object)this.simulationMock.addScenario(4)).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.simulationMock.getScenarioByIndex(4)).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.simulationMock.cloneScenario(4, 5)).thenReturn((Object)this.scenarioMock);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)Matchers.any(), (ExpressionIdentifier)Matchers.any())).thenReturn(Optional.of(this.factMappingValueMock));
        Mockito.when((Object)this.factMappingValueMock.isError()).thenReturn((Object)true);
        this.gridCellSupplier = () -> this.gridCellMock;
        this.scenarioGridModel = (ScenarioGridModel)Mockito.spy((Object)new ScenarioGridModel(false){
            {
                this.simulation = ScenarioGridModelTest.this.simulationMock;
                this.eventBus = ScenarioGridModelTest.this.eventBusMock;
                this.rows = ScenarioGridModelTest.this.gridRows;
                this.columns = ScenarioGridModelTest.this.gridColumns;
            }

            public void deleteColumn(GridColumn<?> column) {
            }

            public GridCell<?> getCell(int rowIndex, int columnIndex) {
                if (rowIndex < 0 || rowIndex > this.rows.size() - 1) {
                    return null;
                }
                return ScenarioGridModelTest.this.gridCellMock;
            }
        });
    }

    @Test
    public void bindContent() {
        Assert.assertTrue((boolean)this.scenarioGridModel.getSimulation().isPresent());
    }

    @Test
    public void setEventBus() {
        this.scenarioGridModel.setEventBus(this.eventBusMock);
        Assert.assertEquals((Object)this.eventBusMock, (Object)this.scenarioGridModel.eventBus);
    }

    @Test
    public void appendRow() {
        this.scenarioGridModel.appendRow((GridRow)this.gridRowMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddRow(Matchers.eq((int)4));
    }

    @Test
    public void insertRowGridOnly() {
        this.scenarioGridModel.insertRowGridOnly(3, (GridRow)this.gridRowMock, this.scenarioMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)3), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)6))).setCell(Matchers.anyInt(), Matchers.anyInt(), (Supplier)Matchers.isA(Supplier.class));
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        FactMapping factMappingByIndexMock = (FactMapping)Mockito.mock(FactMapping.class);
        Mockito.when((Object)factMappingByIndexMock.getClassName()).thenReturn((Object)List.class.getName());
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(2)).thenReturn((Object)factMappingByIndexMock);
        this.scenarioGridModel.insertRowGridOnly(3, (GridRow)this.gridRowMock, this.scenarioMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)3), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)6))).setCell(Matchers.anyInt(), Matchers.anyInt(), (Supplier)Matchers.isA(Supplier.class));
    }

    @Test
    public void insertRow() {
        this.scenarioGridModel.insertRow(3, (GridRow)this.gridRowMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddRow(Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
    }

    @Test
    public void deleteRow() {
        this.scenarioGridModel.deleteRow(3);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).removeScenarioByIndex(Matchers.eq((int)3));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
    }

    @Test
    public void duplicateRow() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.duplicateRow(3, (GridRow)this.gridRowMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).cloneScenario(Matchers.eq((int)3), Matchers.eq((int)4));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).insertRowGridOnly(Matchers.eq((int)4), (GridRow)Matchers.eq((Object)this.gridRowMock), (Scenario)Matchers.isA(Scenario.class));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.never())).insertRow(Matchers.eq((int)3), (GridRow)Matchers.eq((Object)this.gridRowMock));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).updateIndexColumn();
    }

    @Test
    public void insertColumnGridOnly() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.insertColumnGridOnly(5, (GridColumn)this.scenarioGridColumnMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
    }

    @Test
    public void insertColumn() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.insertColumn(5, (GridColumn)this.scenarioGridColumnMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)5), (GridColumn)Matchers.eq((Object)this.scenarioGridColumnMock));
    }

    @Test
    public void deleteColumn() {
        this.scenarioGridModel.deleteColumn(5);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).removeFactMappingByIndex(Matchers.eq((int)5));
    }

    @Test
    public void updateColumnTypeFalse() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.updateColumnProperty(5, (GridColumn)this.scenarioGridColumnMock, "VALUE", this.VALUE_CLASS_NAME, false);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)2))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).deleteColumn(Matchers.eq((int)5));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)5), (GridColumn)Matchers.eq((Object)this.scenarioGridColumnMock), (ExpressionIdentifier)Matchers.isA(ExpressionIdentifier.class));
    }

    @Test
    public void updateColumnTypeTrue() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.updateColumnProperty(5, (GridColumn)this.scenarioGridColumnMock, "VALUE", this.VALUE_CLASS_NAME, true);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)2))).checkSimulation();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)3))).getCell(Matchers.anyInt(), Matchers.eq((int)5));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).deleteColumn(Matchers.eq((int)5));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).commonAddColumn(Matchers.eq((int)5), (GridColumn)Matchers.eq((Object)this.scenarioGridColumnMock), (ExpressionIdentifier)Matchers.isA(ExpressionIdentifier.class));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.atLeast((int)3))).setCellValue(Matchers.anyInt(), Matchers.eq((int)5), (GridCellValue)Matchers.isA(ScenarioGridCellValue.class));
    }

    @Test
    public void setCellGridOnly() {
        this.scenarioGridModel.setCellGridOnly(3, 5, this.gridCellSupplier);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).checkSimulation();
    }

    @Test
    public void setCell() {
        this.scenarioGridModel.setCell(3, 5, this.gridCellSupplier);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)1))).setCell(Matchers.eq((int)3), Matchers.eq((int)5), (Supplier)Matchers.eq(this.gridCellSupplier));
    }

    @Test
    public void getInstanceLimits() {
        GridData.Range retrieved = this.scenarioGridModel.getInstanceLimits(3);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)1L, (long)retrieved.getMinRowIndex());
        Assert.assertEquals((long)5L, (long)retrieved.getMaxRowIndex());
    }

    @Test
    public void getInstanceScenarioGridColumns() {
        List retrieved = this.scenarioGridModel.getInstanceScenarioGridColumns((ScenarioGridColumn)this.gridColumns.get(3));
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((long)6L, (long)retrieved.size());
    }

    @Test
    public void updateHeader() {
        String newValue = "NEW_VALUE";
        this.scenarioGridModel.updateHeader(5, 1, newValue);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ReloadRightPanelEvent.class));
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        this.scenarioGridModel.updateHeader(5, 2, newValue);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any());
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
        String title = ((GridColumn.HeaderMetaData)((GridColumn)this.scenarioGridModel.getColumns().get(5)).getHeaderMetaData().get(1)).getTitle();
        this.scenarioGridModel.updateHeader(5, 1, title);
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any());
    }

    @Test
    public void updateFactMapping() {
        boolean INDEX = false;
        String VALUE = "VALUE";
        String ALIAS_1 = "ALIAS_1";
        String ALIAS_2 = "ALIAS_2";
        FactMapping factMappingReference = (FactMapping)Mockito.mock(FactMapping.class);
        FactMapping factMappingToCheck = (FactMapping)Mockito.mock(FactMapping.class);
        FactIdentifier factIdentifier1 = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        FactIdentifier factIdentifier2 = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)FactIdentifier.EMPTY);
        Mockito.when((Object)factMappingReference.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(0)).thenReturn((Object)factMappingToCheck);
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "VALUE");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)"VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.times((int)1))).setFactAlias((String)Matchers.eq((Object)"VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_2");
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "VALUE");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)Matchers.eq((Object)"VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)Matchers.eq((Object)"VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingReference.getFactIdentifier()).thenReturn((Object)factIdentifier1);
        Mockito.when((Object)factMappingToCheck.getFactAlias()).thenReturn((Object)"ALIAS_1");
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "VALUE");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)Matchers.eq((Object)"VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)Matchers.eq((Object)"VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)factIdentifier1);
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "VALUE");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.times((int)1))).setTitle((String)Matchers.eq((Object)"VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.times((int)1))).setFactAlias((String)Matchers.eq((Object)"VALUE"));
        Mockito.reset((Object[])new ScenarioHeaderMetaData[]{this.informationHeaderMetaDataMock});
        Mockito.reset((Object[])new FactMapping[]{factMappingToCheck});
        Mockito.when((Object)factMappingToCheck.getFactIdentifier()).thenReturn((Object)factIdentifier2);
        this.scenarioGridModel.updateFactMapping(this.simulationDescriptorMock, factMappingReference, 0, "VALUE");
        ((ScenarioHeaderMetaData)Mockito.verify((Object)this.informationHeaderMetaDataMock, (VerificationMode)Mockito.never())).setTitle((String)Matchers.eq((Object)"VALUE"));
        ((FactMapping)Mockito.verify((Object)factMappingToCheck, (VerificationMode)Mockito.never())).setFactAlias((String)Matchers.eq((Object)"VALUE"));
    }

    @Test
    public void commonAddColumn() {
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        this.scenarioGridModel.commonAddColumn(5, (GridColumn)this.scenarioGridColumnMock);
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.times((int)0))).checkSimulation();
    }

    @Test
    public void commonAddRow() {
        this.scenarioGridModel.commonAddRow(3);
    }

    @Test
    public void updateIndexColumn() {
        this.scenarioGridModel.updateIndexColumn();
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModel, (VerificationMode)Mockito.never())).setCellValue(Matchers.anyInt(), Matchers.anyInt(), (GridCellValue)Matchers.isA(ScenarioGridCellValue.class));
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModel});
        Mockito.when((Object)this.scenarioGridModel.getRowCount()).thenReturn((Object)3);
        int indexColumnPosition = 0;
        this.gridColumns.add(indexColumnPosition, (GridColumn<?>)this.scenarioIndexGridColumnMock);
        Mockito.when((Object)this.scenarioGridModel.getColumns()).thenReturn(this.gridColumns);
        this.scenarioGridModel.updateIndexColumn();
    }

    @Test
    public void isSameInstanceHeaderDifferent() {
        this.commonIsSameInstanceHeader("TEST", "TOAST", false);
    }

    @Test
    public void isSameInstanceHeaderEqualWithoutPackage() {
        this.commonIsSameInstanceHeader("TEST", "TEST", true);
    }

    @Test
    public void isSameInstanceHeaderEqualWithPackage() {
        this.commonIsSameInstanceHeader("com.something.TEST", "TEST", true);
    }

    @Test
    public void validateHeaderUpdate() {
        this.commonValidateHeaderUpdate(1, 0, false, false, false, false);
        this.commonValidateHeaderUpdate(1, 0, false, false, true, true);
        this.commonValidateHeaderUpdate(1, 0, false, true, false, false);
        this.commonValidateHeaderUpdate(1, 0, false, true, true, true);
        this.commonValidateHeaderUpdate(1, 0, true, false, false, false);
        this.commonValidateHeaderUpdate(1, 0, true, false, true, false);
        this.commonValidateHeaderUpdate(1, 0, true, true, false, false);
        this.commonValidateHeaderUpdate(1, 0, true, true, true, true);
        this.commonValidateHeaderUpdate(2, 0, false, false, false, true);
        this.commonValidateHeaderUpdate(2, 0, false, false, true, true);
        this.commonValidateHeaderUpdate(2, 0, false, true, false, true);
        this.commonValidateHeaderUpdate(2, 0, false, true, true, true);
        this.commonValidateHeaderUpdate(2, 0, true, false, false, true);
        this.commonValidateHeaderUpdate(2, 0, true, false, true, true);
        this.commonValidateHeaderUpdate(2, 0, true, true, false, true);
        this.commonValidateHeaderUpdate(2, 0, true, true, true, true);
    }

    @Test
    public void refreshErrorsTest() {
        this.scenarioGridModel.refreshErrors();
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)24))).setErrorMode(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioGridCell[]{this.gridCellMock});
        Mockito.when((Object)this.factMappingValueMock.isError()).thenReturn((Object)false);
        this.scenarioGridModel.refreshErrors();
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)24))).setErrorMode(Matchers.eq((boolean)false));
    }

    @Test
    public void refreshErrorsRow() {
        FactMappingValue factMappingValue = (FactMappingValue)Mockito.mock(FactMappingValue.class);
        Mockito.when((Object)factMappingValue.isError()).thenReturn((Object)true);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)Matchers.any(), (ExpressionIdentifier)Matchers.any())).thenReturn(Optional.empty());
        this.scenarioGridModel.refreshErrorsRow(0);
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)6))).setErrorMode(false);
        Mockito.when((Object)this.scenarioMock.getFactMappingValue((FactIdentifier)Matchers.any(), (ExpressionIdentifier)Matchers.any())).thenReturn(Optional.of(factMappingValue));
        this.scenarioGridModel.refreshErrorsRow(0);
        ((ScenarioGridCell)Mockito.verify((Object)this.gridCellMock, (VerificationMode)Mockito.times((int)6))).setErrorMode(true);
    }

    private void commonIsSameInstanceHeader(String columnClassName, String value, boolean expected) {
        FactIdentifier factIdentifierMock = (FactIdentifier)Mockito.mock(FactIdentifier.class);
        Mockito.when((Object)factIdentifierMock.getClassName()).thenReturn((Object)columnClassName);
        int colIndex = 3;
        Mockito.when((Object)this.factMappingMock.getFactIdentifier()).thenReturn((Object)factIdentifierMock);
        Mockito.when((Object)this.simulationDescriptorMock.getFactMappingByIndex(colIndex)).thenReturn((Object)this.factMappingMock);
        boolean retrieved = this.scenarioGridModel.isSameInstanceHeader(colIndex, value);
        if (expected) {
            TestCase.assertTrue((boolean)retrieved);
        } else {
            Assert.assertFalse((boolean)retrieved);
        }
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).getSimulationDescriptor();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).getFactMappingByIndex(Matchers.eq((int)colIndex));
    }

    private void commonValidateHeaderUpdate(int rowIndex, int columnIndex, boolean isADataType, boolean isSameInstanceHeader, boolean isUnique, boolean expectedValid) {
        String value = "VALUE";
        ((ScenarioGridModel)Mockito.doReturn((Object)isSameInstanceHeader).when((Object)this.scenarioGridModel)).isSameInstanceHeader(columnIndex, value);
        ((ScenarioGridModel)Mockito.doReturn((Object)isUnique).when((Object)this.scenarioGridModel)).isUniqueInstanceHeaderTitle(value, rowIndex, columnIndex);
        boolean retrieved = this.scenarioGridModel.validateHeaderUpdate(value, rowIndex, columnIndex, isADataType);
        Assert.assertEquals((Object)retrieved, (Object)expectedValid);
        Mockito.reset((Object[])new EventBus[]{this.eventBusMock});
    }
}

