/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.ButtonElement;
import com.google.gwt.dom.client.HeadingElement;
import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.AbstractCollectionEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.KeyValueElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.editingbox.ItemEditingBoxPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.editingbox.KeyValueEditingBoxPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class CollectionPresenterTest
extends AbstractCollectionEditorTest {
    private static final String TEST_JSON = "TEST-JSON";
    private static final String TEST_CLASSNAME = "TEST-CLASSNAME";
    private static final String TEST_PROPERTYNAME = "TEST-PROPERTYNAME";
    private static final String TEST_KEY = "TEST-CLASSNAME#TEST-PROPERTYNAME";
    private static final int CHILD_COUNT = 3;
    private static final String ITEM_ID = String.valueOf(2);
    private static final String UPDATED_VALUE = "UPDATED_VALUE";
    private static final int JSON_ARRAY_SIZE = 2;
    private static final Set<String> KEY_SET = new HashSet<String>(Arrays.asList("prop1", "prop2"));
    @Mock
    private ItemElementPresenter listElementPresenterMock;
    @Mock
    private KeyValueElementPresenter mapElementPresenterMock;
    @Mock
    private ItemEditingBoxPresenter listEditingBoxPresenterMock;
    @Mock
    private KeyValueEditingBoxPresenter mapEditingBoxPresenterMock;
    @Mock
    private CollectionView collectionViewMock;
    private Map<String, Map<String, String>> instancePropertiesMapLocal = new HashMap<String, Map<String, String>>();
    private Map<String, String> keyPropertyMapLocal = new HashMap<String, String>();
    private Map<String, String> propertyMapLocal = new HashMap<String, String>();
    @Mock
    private UListElement elementsContainerMock;
    @Mock
    private LIElement listEditingBoxMock;
    @Mock
    private LIElement mapEditingBoxMock;
    @Mock
    private LIElement itemElementMock;
    @Mock
    private Style styleMock;
    @Mock
    private JSONValue jsonValueMock;
    @Mock
    private JSONArray jsonArrayMock;
    @Mock
    private JSONValue jsonValueChildMock;
    @Mock
    private JSONObject jsonObjectMock;
    @Mock
    private JSONValue jsonValueNeph1Mock;
    @Mock
    private JSONValue jsonValueNeph2Mock;
    @Mock
    private JSONString jsonStringProp1Mock;
    @Mock
    private JSONString jsonStringProp2Mock;
    @Mock
    private JSONObject nestedValue1Mock;
    @Mock
    private JSONObject nestedValue2Mock;
    @Mock
    private LIElement objectSeparatorLIMock;
    @Mock
    private HeadingElement editorTitleMock;
    @Mock
    private SpanElement propertyTitleMock;
    @Mock
    private ButtonElement addItemButtonMock;
    private CollectionPresenter collectionEditorPresenter;

    @Override
    @Before
    public void setup() {
        Mockito.when((Object)this.elementsContainerMock.getChildCount()).thenReturn((Object)3);
        Mockito.when((Object)this.editorTitleMock.getInnerText()).thenReturn((Object)TEST_KEY);
        Mockito.when((Object)this.collectionViewMock.getElementsContainer()).thenReturn((Object)this.elementsContainerMock);
        Mockito.when((Object)this.collectionViewMock.getEditorTitle()).thenReturn((Object)this.editorTitleMock);
        Mockito.when((Object)this.collectionViewMock.getPropertyTitle()).thenReturn((Object)this.propertyTitleMock);
        Mockito.when((Object)this.collectionViewMock.getObjectSeparator()).thenReturn((Object)this.objectSeparatorLIMock);
        Mockito.when((Object)this.collectionViewMock.getAddItemButton()).thenReturn((Object)this.addItemButtonMock);
        Mockito.when((Object)this.objectSeparatorLIMock.getStyle()).thenReturn((Object)this.styleMock);
        Mockito.when((Object)this.nestedValue1Mock.keySet()).thenReturn(KEY_SET);
        Mockito.when((Object)this.nestedValue1Mock.get((String)Matchers.eq((Object)"prop1"))).thenReturn((Object)this.jsonValueNeph1Mock);
        Mockito.when((Object)this.nestedValue1Mock.get((String)Matchers.eq((Object)"prop2"))).thenReturn((Object)this.jsonValueNeph2Mock);
        Mockito.when((Object)this.nestedValue2Mock.keySet()).thenReturn(KEY_SET);
        Mockito.when((Object)this.nestedValue2Mock.get((String)Matchers.eq((Object)"prop1"))).thenReturn((Object)this.jsonValueNeph1Mock);
        Mockito.when((Object)this.nestedValue2Mock.get((String)Matchers.eq((Object)"prop2"))).thenReturn((Object)this.jsonValueNeph2Mock);
        Mockito.when((Object)this.jsonValueNeph1Mock.isString()).thenReturn((Object)this.jsonStringProp1Mock);
        Mockito.when((Object)this.jsonValueNeph2Mock.isString()).thenReturn((Object)this.jsonStringProp2Mock);
        Mockito.when((Object)this.jsonValueNeph1Mock.isObject()).thenReturn((Object)this.nestedValue1Mock);
        Mockito.when((Object)this.jsonValueNeph2Mock.isObject()).thenReturn((Object)this.nestedValue2Mock);
        Mockito.when((Object)this.jsonObjectMock.keySet()).thenReturn(KEY_SET);
        Mockito.when((Object)this.jsonObjectMock.get((String)Matchers.eq((Object)"prop1"))).thenReturn((Object)this.jsonValueNeph1Mock);
        Mockito.when((Object)this.jsonObjectMock.get((String)Matchers.eq((Object)"prop2"))).thenReturn((Object)this.jsonValueNeph2Mock);
        Mockito.when((Object)this.jsonValueChildMock.isObject()).thenReturn((Object)this.jsonObjectMock);
        Mockito.when((Object)this.jsonArrayMock.size()).thenReturn((Object)2);
        Mockito.when((Object)this.jsonArrayMock.get(Matchers.anyInt())).thenReturn((Object)this.jsonValueChildMock);
        Mockito.when((Object)this.jsonValueMock.isArray()).thenReturn((Object)this.jsonArrayMock);
        Mockito.when((Object)this.jsonValueMock.isObject()).thenReturn((Object)this.jsonObjectMock);
        this.collectionEditorPresenter = (CollectionPresenter)Mockito.spy((Object)new CollectionPresenter(){
            {
                this.viewsProvider = CollectionPresenterTest.this.viewsProviderMock;
                this.listElementPresenter = CollectionPresenterTest.this.listElementPresenterMock;
                this.mapElementPresenter = CollectionPresenterTest.this.mapElementPresenterMock;
                this.listEditingBoxPresenter = CollectionPresenterTest.this.listEditingBoxPresenterMock;
                this.mapEditingBoxPresenter = CollectionPresenterTest.this.mapEditingBoxPresenterMock;
                this.instancePropertiesMap = CollectionPresenterTest.this.instancePropertiesMapLocal;
                this.collectionView = CollectionPresenterTest.this.collectionViewMock;
                this.objectSeparatorLI = CollectionPresenterTest.this.objectSeparatorLIMock;
            }

            protected JSONValue getJSONValue(String jsonString) {
                return CollectionPresenterTest.this.jsonValueMock;
            }

            protected String getListValue() {
                return CollectionPresenterTest.UPDATED_VALUE;
            }

            protected String getMapValue() {
                return CollectionPresenterTest.UPDATED_VALUE;
            }
        });
        this.instancePropertiesMapLocal.clear();
        Mockito.when((Object)this.listElementPresenterMock.getItemContainer(Matchers.anyString(), Matchers.anyMap())).thenReturn((Object)this.itemElementMock);
        Mockito.when((Object)this.mapElementPresenterMock.getKeyValueContainer(Matchers.anyString(), Matchers.anyMap(), Matchers.anyMap())).thenReturn((Object)this.itemElementMock);
        Mockito.when((Object)this.listEditingBoxPresenterMock.getEditingBox(Matchers.anyString(), Matchers.anyMap())).thenReturn((Object)this.listEditingBoxMock);
        Mockito.when((Object)this.mapEditingBoxPresenterMock.getEditingBox(Matchers.anyString(), Matchers.anyMap(), Matchers.anyMap())).thenReturn((Object)this.mapEditingBoxMock);
    }

    @Test
    public void initListStructure() {
        this.collectionEditorPresenter.initListStructure(TEST_KEY, this.propertyMapLocal, this.collectionViewMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).commonInit((String)Matchers.eq((Object)TEST_KEY), (CollectionView)Matchers.eq((Object)this.collectionViewMock));
        Assert.assertTrue((boolean)this.instancePropertiesMapLocal.containsKey(TEST_KEY));
        Assert.assertEquals(this.instancePropertiesMapLocal.get(TEST_KEY), this.propertyMapLocal);
        ((ItemEditingBoxPresenter)Mockito.verify((Object)this.listEditingBoxPresenterMock, (VerificationMode)Mockito.times((int)1))).setCollectionEditorPresenter((CollectionView.Presenter)Matchers.eq((Object)this.collectionEditorPresenter));
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).setCollectionEditorPresenter((CollectionView.Presenter)Matchers.eq((Object)this.collectionEditorPresenter));
    }

    @Test
    public void initMapStructure() {
        this.collectionEditorPresenter.initMapStructure(TEST_KEY, this.keyPropertyMapLocal, this.propertyMapLocal, this.collectionViewMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).commonInit((String)Matchers.eq((Object)TEST_KEY), (CollectionView)Matchers.eq((Object)this.collectionViewMock));
        Assert.assertTrue((boolean)this.instancePropertiesMapLocal.containsKey("TEST-CLASSNAME#TEST-PROPERTYNAME#key"));
        Assert.assertEquals(this.instancePropertiesMapLocal.get("TEST-CLASSNAME#TEST-PROPERTYNAME#key"), this.keyPropertyMapLocal);
        Assert.assertTrue((boolean)this.instancePropertiesMapLocal.containsKey("TEST-CLASSNAME#TEST-PROPERTYNAME#value"));
        Assert.assertEquals(this.instancePropertiesMapLocal.get("TEST-CLASSNAME#TEST-PROPERTYNAME#value"), this.propertyMapLocal);
        ((KeyValueEditingBoxPresenter)Mockito.verify((Object)this.mapEditingBoxPresenterMock, (VerificationMode)Mockito.times((int)1))).setCollectionEditorPresenter((CollectionView.Presenter)Matchers.eq((Object)this.collectionEditorPresenter));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).setCollectionEditorPresenter((CollectionView.Presenter)Matchers.eq((Object)this.collectionEditorPresenter));
    }

    @Test
    public void setValueIsListWidgetTrue() {
        this.commonSetValue(true);
    }

    @Test
    public void setValueIsListWidgetFalse() {
        this.commonSetValue(false);
    }

    @Test
    public void showEditingBoxIsListWidgetTrue() {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)true);
        this.collectionEditorPresenter.showEditingBox();
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getElementsContainer();
        ((ItemEditingBoxPresenter)Mockito.verify((Object)this.listEditingBoxPresenterMock, (VerificationMode)Mockito.times((int)1))).getEditingBox((String)Matchers.eq((Object)TEST_KEY), Matchers.anyMap());
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)this.listEditingBoxMock));
    }

    @Test
    public void showEditingBoxIsListWidgetFalse() {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)false);
        this.collectionEditorPresenter.showEditingBox();
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getElementsContainer();
        ((KeyValueEditingBoxPresenter)Mockito.verify((Object)this.mapEditingBoxPresenterMock, (VerificationMode)Mockito.times((int)1))).getEditingBox((String)Matchers.eq((Object)TEST_KEY), Matchers.anyMap(), Matchers.anyMap());
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)this.mapEditingBoxMock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void onToggleRowExpansionIsShownTrue() {
        this.commonOnToggleRowExpansionIsShown(true, true);
        this.commonOnToggleRowExpansionIsShown(true, false);
    }

    @Test
    public void onToggleRowExpansionIsShownFalse() {
        this.commonOnToggleRowExpansionIsShown(false, true);
        this.commonOnToggleRowExpansionIsShown(false, false);
    }

    @Test
    public void addListItem() {
        this.collectionEditorPresenter.addListItem(this.propertyMapLocal);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getElementsContainer();
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).getItemContainer((String)Matchers.eq((Object)ITEM_ID), (Map)Matchers.eq(this.propertyMapLocal));
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)this.itemElementMock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void addMapItem() {
        this.collectionEditorPresenter.addMapItem(this.keyPropertyMapLocal, this.propertyMapLocal);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getElementsContainer();
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).getChildCount();
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).getKeyValueContainer((String)Matchers.eq((Object)ITEM_ID), (Map)Matchers.eq(this.keyPropertyMapLocal), (Map)Matchers.eq(this.propertyMapLocal));
        ((UListElement)Mockito.verify((Object)this.elementsContainerMock, (VerificationMode)Mockito.times((int)1))).appendChild((Node)Matchers.eq((Object)this.itemElementMock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void saveIsListWidgetTrue() {
        this.commonSave(true, true);
        this.commonSave(true, false);
    }

    @Test
    public void saveIsListWidgetFalse() {
        this.commonSave(true, true);
        this.commonSave(true, false);
    }

    @Test
    public void removeIsListWidgetTrue() {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)true);
        this.collectionEditorPresenter.remove();
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).remove();
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.never())).remove();
    }

    @Test
    public void removeIsListWidgetFalse() {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)false);
        this.collectionEditorPresenter.remove();
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).remove();
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.never())).remove();
    }

    @Test
    public void commonInit() {
        this.collectionEditorPresenter.collectionView = null;
        this.collectionEditorPresenter.objectSeparatorLI = null;
        this.collectionEditorPresenter.commonInit(TEST_KEY, this.collectionViewMock);
        Assert.assertEquals((Object)this.collectionEditorPresenter.collectionView, (Object)this.collectionViewMock);
        ((HeadingElement)Mockito.verify((Object)this.editorTitleMock, (VerificationMode)Mockito.times((int)1))).setInnerText(TEST_KEY);
        ((SpanElement)Mockito.verify((Object)this.propertyTitleMock, (VerificationMode)Mockito.times((int)1))).setInnerText(TEST_PROPERTYNAME);
        Assert.assertEquals((Object)this.collectionEditorPresenter.objectSeparatorLI, (Object)this.objectSeparatorLIMock);
    }

    @Test
    public void populateList() {
        this.collectionEditorPresenter.populateList(this.jsonValueMock);
        for (int i = 0; i < 2; ++i) {
            ((JSONArray)Mockito.verify((Object)this.jsonArrayMock, (VerificationMode)Mockito.times((int)1))).get(Matchers.eq((int)i));
        }
        ((JSONObject)Mockito.verify((Object)this.jsonObjectMock, (VerificationMode)Mockito.times((int)2))).get("prop1");
        ((JSONObject)Mockito.verify((Object)this.jsonObjectMock, (VerificationMode)Mockito.times((int)2))).get("prop2");
        ((JSONValue)Mockito.verify((Object)this.jsonValueNeph1Mock, (VerificationMode)Mockito.times((int)2))).isString();
        ((JSONValue)Mockito.verify((Object)this.jsonValueNeph2Mock, (VerificationMode)Mockito.times((int)2))).isString();
        ((JSONString)Mockito.verify((Object)this.jsonStringProp1Mock, (VerificationMode)Mockito.times((int)2))).stringValue();
        ((JSONString)Mockito.verify((Object)this.jsonStringProp2Mock, (VerificationMode)Mockito.times((int)2))).stringValue();
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)2))).addListItem(Matchers.anyMap());
    }

    @Test
    public void populateMap() {
        this.collectionEditorPresenter.populateMap(this.jsonValueMock);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)2))).addMapItem(Matchers.anyMap(), Matchers.anyMap());
    }

    @Test
    public void toggleEditingStatusToDisableTrue() {
        this.collectionEditorPresenter.toggleEditingStatus(true);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getAddItemButton();
        ((ButtonElement)Mockito.verify((Object)this.addItemButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)true));
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void toggleEditingStatusToDisableFalse() {
        this.collectionEditorPresenter.toggleEditingStatus(false);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).getAddItemButton();
        ((ButtonElement)Mockito.verify((Object)this.addItemButtonMock, (VerificationMode)Mockito.times((int)1))).setDisabled(Matchers.eq((boolean)false));
        ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
        ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    private void commonSetValue(boolean isListWidget) {
        this.collectionEditorPresenter.setValue(null);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.never())).getJSONValue(Matchers.anyString());
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionEditorPresenter});
        this.collectionEditorPresenter.setValue("");
        ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.never())).getJSONValue(Matchers.anyString());
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionEditorPresenter});
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)isListWidget);
        this.collectionEditorPresenter.setValue(TEST_JSON);
        if (isListWidget) {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).populateList((JSONValue)Matchers.isA(JSONValue.class));
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.never())).populateMap((JSONValue)Matchers.isA(JSONValue.class));
        } else {
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).populateMap((JSONValue)Matchers.isA(JSONValue.class));
            ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.never())).populateList((JSONValue)Matchers.isA(JSONValue.class));
        }
    }

    private void commonOnToggleRowExpansionIsShown(boolean isShown, boolean isListWidget) {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)isListWidget);
        this.collectionEditorPresenter.onToggleRowExpansion(isShown);
        ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).toggleRowExpansion();
        if (isListWidget) {
            ((ItemElementPresenter)Mockito.verify((Object)this.listElementPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion(Matchers.eq((boolean)isShown));
        } else {
            ((KeyValueElementPresenter)Mockito.verify((Object)this.mapElementPresenterMock, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion(Matchers.eq((boolean)isShown));
        }
        Mockito.reset((Object[])new CollectionView[]{this.collectionViewMock});
        Mockito.reset((Object[])new ItemElementPresenter[]{this.listElementPresenterMock});
        Mockito.reset((Object[])new KeyValueElementPresenter[]{this.mapElementPresenterMock});
    }

    private void commonSave(boolean isListWidget, boolean toRemove) {
        Mockito.when((Object)this.collectionViewMock.isListWidget()).thenReturn((Object)isListWidget);
        this.collectionEditorPresenter.toRemove = toRemove;
        this.collectionEditorPresenter.save();
        if (toRemove) {
            ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).updateValue((String)Matchers.eq(null));
        } else {
            if (isListWidget) {
                ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).getListValue();
            } else {
                ((CollectionPresenter)Mockito.verify((Object)this.collectionEditorPresenter, (VerificationMode)Mockito.times((int)1))).getMapValue();
            }
            ((CollectionView)Mockito.verify((Object)this.collectionViewMock, (VerificationMode)Mockito.times((int)1))).updateValue((String)Matchers.eq((Object)UPDATED_VALUE));
        }
        Mockito.reset((Object[])new CollectionPresenter[]{this.collectionEditorPresenter});
        Mockito.reset((Object[])new CollectionView[]{this.collectionViewMock});
    }
}

