/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommandTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.SetHeaderValueCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class SetHeaderValueCommandTest
extends AbstractScenarioSimulationCommandTest {
    @Override
    @Before
    public void setup() {
        super.setup();
        this.command = (AbstractScenarioSimulationCommand)Mockito.spy((Object)new SetHeaderValueCommand());
        this.scenarioSimulationContextLocal.getStatus().setRowIndex(2);
        this.scenarioSimulationContextLocal.getStatus().setColumnIndex(3);
        this.scenarioSimulationContextLocal.getStatus().setCellValue("value");
        Assert.assertTrue((boolean)this.command.isUndoable());
    }

    @Test
    public void executeNotValid() {
        this.commonExecute(false, false);
    }

    @Test
    public void executeValid() {
        this.commonExecute(true, true);
    }

    private void commonExecute(boolean validateHeaderUpdate, boolean executed) {
        Mockito.when((Object)this.scenarioGridModelMock.validateHeaderUpdate((String)Matchers.eq((Object)"value"), Matchers.eq((int)2), Matchers.eq((int)3), Matchers.anyBoolean())).thenReturn((Object)validateHeaderUpdate);
        this.command.execute(this.scenarioSimulationContextLocal);
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).isADataType(Matchers.anyString());
        if (executed) {
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).updateHeader(Matchers.eq((int)3), Matchers.eq((int)2), (String)Matchers.eq((Object)"value"));
        } else {
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).updateHeader(Matchers.eq((int)3), Matchers.eq((int)2), (String)Matchers.eq((Object)"value"));
        }
    }
}

