/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractDataManagementStrategyTest
extends AbstractScenarioSimulationEditorTest {
    protected AbstractDataManagementStrategy abstractDataManagementStrategySpy;

    public void setUp() throws Exception {
        super.setup();
    }

    @Test
    public void getSimpleClassFactModelTree() {
        FactModelTree retrieved = AbstractDataManagementStrategy.getSimpleClassFactModelTree(String.class);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)String.class.getSimpleName(), (Object)retrieved.getFactName());
        Assert.assertEquals((Object)"java.lang", (Object)retrieved.getFullPackage());
        Assert.assertNotNull((Object)retrieved.getSimpleProperties());
    }

    @Test
    public void getPropertiesToHideMap() {
        this.commonGetPropertiesToHideMap(true, false);
        this.commonGetPropertiesToHideMap(false, false);
        this.commonGetPropertiesToHideMap(false, true);
    }

    @Test
    public void getPropertiesToHideListNoPropertyAssigned() {
        this.commonGetPropertiesToHideList(false);
    }

    @Test
    public void getPropertiesToHideListPropertyAssigned() {
        this.commonGetPropertiesToHideList(true);
    }

    private void commonGetPropertiesToHideMap(boolean selectedColumnNull, boolean isInstanceAssigned) {
        if (selectedColumnNull) {
            ((ScenarioGridModel)Mockito.doReturn(null).when((Object)this.scenarioGridModelMock)).getSelectedColumn();
        } else {
            ((ScenarioGridModel)Mockito.doReturn((Object)this.gridColumnMock).when((Object)this.scenarioGridModelMock)).getSelectedColumn();
            ((ScenarioGridColumn)Mockito.doReturn((Object)isInstanceAssigned).when((Object)this.gridColumnMock)).isInstanceAssigned();
            if (isInstanceAssigned) {
                ((AbstractDataManagementStrategy)Mockito.doReturn(new ArrayList()).when((Object)this.abstractDataManagementStrategySpy)).getPropertiesToHide((ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
            }
        }
        Map retrieved = this.abstractDataManagementStrategySpy.getPropertiesToHide(this.scenarioGridModelMock);
        if (selectedColumnNull) {
            Assert.assertTrue((boolean)retrieved.isEmpty());
            ((AbstractDataManagementStrategy)Mockito.verify((Object)this.abstractDataManagementStrategySpy, (VerificationMode)Mockito.never())).getPropertiesToHide((ScenarioGridColumn)Matchers.isA(ScenarioGridColumn.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        } else if (isInstanceAssigned) {
            ((AbstractDataManagementStrategy)Mockito.verify((Object)this.abstractDataManagementStrategySpy, (VerificationMode)Mockito.times((int)1))).getPropertiesToHide((ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        } else {
            ((AbstractDataManagementStrategy)Mockito.verify((Object)this.abstractDataManagementStrategySpy, (VerificationMode)Mockito.never())).getPropertiesToHide((ScenarioGridColumn)Matchers.isA(ScenarioGridColumn.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock));
        }
        Mockito.reset((Object[])new AbstractDataManagementStrategy[]{this.abstractDataManagementStrategySpy});
    }

    private void commonGetPropertiesToHideList(boolean isPropertyAssigned) {
        ((ScenarioGridColumn)Mockito.doReturn((Object)isPropertyAssigned).when((Object)this.gridColumnMock)).isPropertyAssigned();
        List retrieved = this.abstractDataManagementStrategySpy.getPropertiesToHide(this.gridColumnMock, this.scenarioGridModelMock);
        if (isPropertyAssigned) {
            Assert.assertTrue((boolean)retrieved.isEmpty());
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.never())).getSimulation();
        } else {
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).getSimulation();
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).getInstanceScenarioGridColumns((ScenarioGridColumn)Matchers.eq((Object)this.gridColumnMock));
        }
        Mockito.reset((Object[])new ScenarioGridModel[]{this.scenarioGridModelMock});
    }
}

