/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;

public abstract class AbstractSetHeaderCommand
extends AbstractScenarioSimulationCommand {
    public AbstractSetHeaderCommand() {
        super(true);
    }

    protected abstract void executeIfSelectedColumn(ScenarioSimulationContext var1, ScenarioGridColumn var2);

    @Override
    protected void internalExecute(ScenarioSimulationContext context) {
        this.getSelectedColumn(context).ifPresent(selectedColumn -> this.executeIfSelectedColumn(context, (ScenarioGridColumn)((Object)selectedColumn)));
    }

    protected void setInstanceHeader(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn) {
        ScenarioSimulationContext.Status status = context.getStatus();
        int columnIndex = context.getModel().getColumns().indexOf((Object)selectedColumn);
        String className = status.getClassName();
        String canonicalClassName = this.getFullPackage(context) + className;
        FactIdentifier factIdentifier = this.setEditableHeadersAndGetFactIdentifier(context, selectedColumn, className, canonicalClassName);
        this.setInstanceHeaderMetaData(selectedColumn, className, factIdentifier);
        ScenarioHeaderMetaData propertyHeaderMetaData = selectedColumn.getPropertyHeaderMetaData();
        this.setPropertyMetaData(propertyHeaderMetaData, FactMapping.getPropertyPlaceHolder((int)columnIndex), false, selectedColumn, ScenarioSimulationEditorConstants.INSTANCE.defineValidType());
        context.getModel().updateColumnInstance(columnIndex, (GridColumn<?>)selectedColumn);
    }

    protected Optional<ScenarioGridColumn> getSelectedColumn(ScenarioSimulationContext context) {
        return Optional.ofNullable((ScenarioGridColumn)context.getModel().getSelectedColumn());
    }

    protected String getFullPackage(ScenarioSimulationContext context) {
        String fullPackage = context.getStatus().getFullPackage();
        if (!fullPackage.endsWith(".")) {
            fullPackage = fullPackage + ".";
        }
        return fullPackage;
    }

    protected FactIdentifier setEditableHeadersAndGetFactIdentifier(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn, String aliasName, String canonicalClassName) {
        ScenarioSimulationModel.Type simulationModelType = context.getModel().getSimulation().get().getSimulationDescriptor().getType();
        selectedColumn.setEditableHeaders(!simulationModelType.equals((Object)ScenarioSimulationModel.Type.DMN));
        String nameToUseForCreation = simulationModelType.equals((Object)ScenarioSimulationModel.Type.DMN) ? aliasName : selectedColumn.getInformationHeaderMetaData().getColumnId();
        return this.getFactIdentifierByColumnTitle(aliasName, context).orElse(FactIdentifier.create((String)nameToUseForCreation, (String)canonicalClassName));
    }

    protected void setInstanceHeaderMetaData(ScenarioGridColumn scenarioGridColumn, String aliasName, FactIdentifier factIdentifier) {
        scenarioGridColumn.getInformationHeaderMetaData().setTitle(aliasName);
        scenarioGridColumn.setInstanceAssigned(true);
        scenarioGridColumn.setFactIdentifier(factIdentifier);
    }

    protected void setPropertyMetaData(ScenarioHeaderMetaData propertyHeaderMetaData, String title, boolean readOnly, ScenarioGridColumn selectedColumn, String placeHolder) {
        propertyHeaderMetaData.setTitle(title);
        propertyHeaderMetaData.setReadOnly(readOnly);
        selectedColumn.setPlaceHolder(placeHolder);
    }
}

