/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.events.UnsupportedDMNEvent;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.drools.workbench.screens.scenariosimulation.service.DMNTypeService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;

public class DMNDataManagementStrategy
extends AbstractDataManagementStrategy {
    private final Caller<DMNTypeService> dmnTypeService;
    private final EventBus eventBus;
    protected Path currentPath;

    public DMNDataManagementStrategy(Caller<DMNTypeService> dmnTypeService, ScenarioSimulationContext scenarioSimulationContext, EventBus eventBus) {
        this.dmnTypeService = dmnTypeService;
        this.scenarioSimulationContext = scenarioSimulationContext;
        this.eventBus = eventBus;
    }

    @Override
    public void populateRightPanel(RightPanelView.Presenter rightPanelPresenter, ScenarioGridModel scenarioGridModel) {
        String dmnFilePath = this.model.getSimulation().getSimulationDescriptor().getDmnFilePath();
        if (this.factModelTreeHolder.getFactModelTuple() != null) {
            this.getSuccessCallback(rightPanelPresenter, scenarioGridModel).callback((Object)this.factModelTreeHolder.getFactModelTuple());
        } else {
            ((DMNTypeService)this.dmnTypeService.call(this.getSuccessCallback(rightPanelPresenter, scenarioGridModel), this.getErrorCallback(rightPanelPresenter))).retrieveType(this.currentPath, dmnFilePath);
        }
    }

    @Override
    public void manageScenarioSimulationModelContent(ObservablePath currentPath, ScenarioSimulationModelContent toManage) {
        this.currentPath = currentPath.getOriginal();
        this.model = toManage.getModel();
    }

    @Override
    public boolean isADataType(String value) {
        return this.factModelTreeHolder.factModelTuple.getHiddenFacts().keySet().contains(value) || this.factModelTreeHolder.factModelTuple.getVisibleFacts().keySet().contains(value);
    }

    protected RemoteCallback<FactModelTuple> getSuccessCallback(RightPanelView.Presenter rightPanelPresenter, ScenarioGridModel scenarioGridModel) {
        return factMappingTuple -> this.getSuccessCallbackMethod((FactModelTuple)factMappingTuple, rightPanelPresenter, scenarioGridModel);
    }

    protected void getSuccessCallbackMethod(FactModelTuple factModelTuple, RightPanelView.Presenter rightPanelPresenter, ScenarioGridModel scenarioGridModel) {
        this.factModelTreeHolder.setFactModelTuple(factModelTuple);
        this.storeData(factModelTuple, rightPanelPresenter, scenarioGridModel);
        this.showErrorsAndCleanupState(factModelTuple);
    }

    private void showErrorsAndCleanupState(FactModelTuple factModelTuple) {
        StringBuilder builder = new StringBuilder();
        boolean showError = false;
        if (factModelTuple.getTopLevelCollectionError().size() > 0) {
            showError = true;
            builder.append("Top-level collections are not supported! Violated by:<br/>");
            factModelTuple.getTopLevelCollectionError().forEach(error -> builder.append("<b>" + error + "</b><br/>"));
            builder.append("<br/>");
        }
        if (factModelTuple.getMultipleNestedCollectionError().size() > 0) {
            showError = true;
            builder.append("Nested collections are not supported! Violated by:<br/>");
            factModelTuple.getMultipleNestedCollectionError().forEach(error -> builder.append("<b>" + error + "</b><br/>"));
            builder.append("<br/>");
        }
        if (factModelTuple.getMultipleNestedObjectError().size() > 0) {
            showError = true;
            builder.append("Complex nested objects inside a collection are not supported! Violated by:<br/>");
            factModelTuple.getMultipleNestedObjectError().forEach(error -> builder.append("<b>" + error + "</b><br/>"));
        }
        if (showError) {
            factModelTuple.getTopLevelCollectionError().clear();
            factModelTuple.getMultipleNestedCollectionError().clear();
            factModelTuple.getMultipleNestedObjectError().clear();
            this.eventBus.fireEvent((GwtEvent)new UnsupportedDMNEvent(builder.toString()));
        }
    }

    protected void filterFactModelTreeMap(SortedMap<String, FactModelTree> toFilter, Map<String, List<String>> alreadyAssignedProperties) {
        toFilter.forEach((factName, factModelTree) -> {
            ArrayList toRemove = new ArrayList();
            if (alreadyAssignedProperties.containsKey(factName)) {
                toRemove.addAll((Collection)alreadyAssignedProperties.get(factName));
            }
            toRemove.forEach(arg_0 -> ((FactModelTree)factModelTree).removeSimpleProperty(arg_0));
        });
    }

    private ErrorCallback<Object> getErrorCallback(RightPanelView.Presenter rightPanelPresenter) {
        return (error, exception) -> {
            rightPanelPresenter.setDataObjectFieldsMap(new TreeMap<String, FactModelTree>());
            return false;
        };
    }
}

