/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.collectioneditor;

import com.google.gwt.dom.client.LIElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.dom.client.UListElement;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementPresenterTest;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ElementView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.ItemElementView;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.PropertyPresenter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ItemElementPresenterTest
extends ElementPresenterTest<ItemElementView, ItemElementView.Presenter> {
    private static final String TEST_ITEM_ID = "TEST-ITEM-ID";
    private Map<String, String> testPropertiesMap = Collections.singletonMap("TEST-KEY", "TEST-VALUE");
    @Mock
    private LIElement propertyFieldsMock;

    @Override
    @Before
    public void setup() {
        this.elementView1Mock = (ElementView)Mockito.mock(ItemElementView.class);
        this.elementView2Mock = (ElementView)Mockito.mock(ItemElementView.class);
        super.setup();
        Mockito.when((Object)this.viewsProviderMock.getListEditorElementView()).thenReturn((Object)this.elementView1Mock);
        Mockito.when((Object)this.propertyPresenterMock.getPropertyFields(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.propertyFieldsMock);
        this.elementPresenter = (ElementView.Presenter)Mockito.spy((Object)new ItemElementPresenter(){
            {
                this.viewsProvider = ItemElementPresenterTest.this.viewsProviderMock;
                this.propertyPresenter = ItemElementPresenterTest.this.propertyPresenterMock;
                this.elementViewList = ItemElementPresenterTest.this.elementViewListLocal;
                this.collectionEditorPresenter = ItemElementPresenterTest.this.collectionPresenterMock;
            }
        });
    }

    @Test
    public void getItemContainer() {
        this.elementViewListLocal.clear();
        LIElement itemContainer = ((ItemElementView.Presenter)this.elementPresenter).getItemContainer(TEST_ITEM_ID, this.testPropertiesMap);
        ((ItemElementView)Mockito.verify((Object)this.elementView1Mock, (VerificationMode)Mockito.times((int)1))).init((Object)this.elementPresenter);
        ((ItemElementView)Mockito.verify((Object)this.elementView1Mock, (VerificationMode)Mockito.times((int)1))).setItemId(TEST_ITEM_ID);
        ((ItemElementView)Mockito.verify((Object)this.elementView1Mock, (VerificationMode)Mockito.times((int)1))).getItemContainer();
        ((ItemElementView)Mockito.verify((Object)this.elementView1Mock, (VerificationMode)Mockito.times((int)1))).getSaveChange();
        ((UListElement)Mockito.verify((Object)this.innerItemContainerMock, (VerificationMode)Mockito.times((int)1))).insertBefore((Node)this.propertyFieldsMock, (Node)this.saveChangeMock);
        Assert.assertNotNull((Object)itemContainer);
        Assert.assertTrue((boolean)this.elementViewListLocal.contains(this.elementView1Mock));
    }

    @Test
    public void onEditItemShown() {
        ((ItemElementView)Mockito.doReturn((Object)true).when((Object)this.elementView1Mock)).isShown();
        ((ItemElementView.Presenter)this.elementPresenter).onEditItem(this.elementView1Mock);
        ((ItemElementView.Presenter)Mockito.verify((Object)this.elementPresenter, (VerificationMode)Mockito.never())).onToggleRowExpansion((ElementView)Matchers.eq((Object)this.elementView1Mock), Matchers.eq((boolean)false));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).editProperties(Matchers.anyString());
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.INLINE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void onEditItemNotShown() {
        ((ItemElementView)Mockito.doReturn((Object)false).when((Object)this.elementView1Mock)).isShown();
        ((ItemElementView.Presenter)this.elementPresenter).onEditItem(this.elementView1Mock);
        ((ItemElementView.Presenter)Mockito.verify((Object)this.elementPresenter, (VerificationMode)Mockito.times((int)1))).onToggleRowExpansion((ElementView)Matchers.eq((Object)this.elementView1Mock), Matchers.eq((boolean)false));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).editProperties(Matchers.anyString());
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.INLINE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)true));
    }

    @Test
    public void onStopEditingItem() {
        ((ItemElementView.Presenter)this.elementPresenter).onStopEditingItem(this.elementView1Mock);
        ((ItemElementView.Presenter)Mockito.verify((Object)this.elementPresenter, (VerificationMode)Mockito.never())).onToggleRowExpansion((ElementView)Matchers.eq((Object)this.elementView1Mock), Matchers.eq((boolean)false));
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).stopEditProperties((String)Matchers.eq((Object)"ELEMENT1_ID"));
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void onDeleteItem() {
        ((ItemElementView.Presenter)this.elementPresenter).onDeleteItem(this.elementView1Mock);
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).deleteProperties((String)Matchers.eq((Object)"ELEMENT1_ID"));
        ((LIElement)Mockito.verify((Object)this.itemContainerMock, (VerificationMode)Mockito.times((int)1))).removeFromParent();
        Assert.assertFalse((boolean)this.elementViewListLocal.contains(this.elementView1Mock));
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void updateItem() {
        ((ItemElementView.Presenter)this.elementPresenter).updateItem(this.elementView1Mock);
        ((PropertyPresenter)Mockito.verify((Object)this.propertyPresenterMock, (VerificationMode)Mockito.times((int)1))).updateProperties(Matchers.anyString());
        ((Style)Mockito.verify((Object)this.styleMock, (VerificationMode)Mockito.times((int)1))).setDisplay(Style.Display.NONE);
        ((CollectionPresenter)Mockito.verify((Object)this.collectionPresenterMock, (VerificationMode)Mockito.times((int)1))).toggleEditingStatus(Matchers.eq((boolean)false));
    }

    @Test
    public void getItemsProperties() {
        List itemsProperties = ((ItemElementView.Presenter)this.elementPresenter).getItemsProperties();
        Assert.assertNotNull((Object)itemsProperties);
    }
}

