/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.domelements;

import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import org.drools.workbench.screens.scenariosimulation.client.domelements.ScenarioCellTextAreaDOMElement;
import org.drools.workbench.screens.scenariosimulation.client.events.SetGridCellValueEvent;
import org.drools.workbench.screens.scenariosimulation.client.factories.AbstractFactoriesTest;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridCell;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.wires.core.grids.client.model.GridCellValue;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioCellTextAreaDOMElementTest
extends AbstractFactoriesTest {
    @Mock
    private ScenarioGridCell scenarioGridCellMock;
    @Mock
    private GridCellValue gridCellValueMock;
    private ScenarioCellTextAreaDOMElement scenarioCellTextAreaDOMElement;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.scenarioGridCellMock.getValue()).thenReturn((Object)this.gridCellValueMock);
        this.scenarioCellTextAreaDOMElement = (ScenarioCellTextAreaDOMElement)Mockito.spy((Object)new ScenarioCellTextAreaDOMElement(this.textAreaMock, (GridLayer)this.scenarioGridLayerMock, (GridWidget)this.scenarioGridMock){
            {
                this.context = ScenarioCellTextAreaDOMElementTest.this.contextMock;
                this.scenarioGridCell = ScenarioCellTextAreaDOMElementTest.this.scenarioGridCellMock;
            }
        });
    }

    @Test
    public void flushSameValue() {
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"value");
        this.scenarioCellTextAreaDOMElement.flush("value");
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.eq((boolean)false));
        ((ScenarioCellTextAreaDOMElement)Mockito.verify((Object)this.scenarioCellTextAreaDOMElement, (VerificationMode)Mockito.never())).internalFlush(Matchers.anyString());
    }

    @Test
    public void flushDifferentValue() {
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"TEST");
        this.scenarioCellTextAreaDOMElement.flush("value");
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.eq((boolean)false));
        ((ScenarioCellTextAreaDOMElement)Mockito.verify((Object)this.scenarioCellTextAreaDOMElement, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq((Object)"value"));
    }

    @Test
    public void flushNullString() {
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"");
        this.scenarioCellTextAreaDOMElement.flush(null);
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.eq((boolean)false));
        ((ScenarioCellTextAreaDOMElement)Mockito.verify((Object)this.scenarioCellTextAreaDOMElement, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq(null));
    }

    @Test
    public void flushEmptyStringToNullConversion() {
        Mockito.when((Object)this.gridCellValueMock.getValue()).thenReturn((Object)"");
        this.scenarioCellTextAreaDOMElement.flush("");
        ((ScenarioGridCell)Mockito.verify((Object)this.scenarioGridCellMock, (VerificationMode)Mockito.times((int)1))).setEditingMode(Matchers.eq((boolean)false));
        ((ScenarioCellTextAreaDOMElement)Mockito.verify((Object)this.scenarioCellTextAreaDOMElement, (VerificationMode)Mockito.times((int)1))).internalFlush((String)Matchers.eq(null));
    }

    @Test
    public void internalFlush() {
        this.scenarioCellTextAreaDOMElement.internalFlush("value");
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(SetGridCellValueEvent.class));
    }
}

