/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import junit.framework.TestCase;
import org.apache.commons.lang3.RandomStringUtils;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategyTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.RightPanelView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.jgroups.util.Util;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.FieldAccessorsAndMutators;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;

@RunWith(value=GwtMockitoTestRunner.class)
public class DMODataManagementStrategyTest
extends AbstractDataManagementStrategyTest {
    private DMODataManagementStrategy dmoDataManagementStrategy;
    @Mock
    private AsyncPackageDataModelOracle oracleMock;
    private final String FACT_NAME = "FACT_NAME";
    private final String FULL_FACT_CLASSNAME = "FULL_FACT_CLASSNAME";

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.oracleMock.getFQCNByFactName("FACT_NAME")).thenReturn((Object)"FULL_FACT_CLASSNAME");
        Mockito.when((Object)this.oracleFactoryMock.makeAsyncPackageDataModelOracle((Path)this.observablePathMock, (HasImports)this.modelLocal, this.content.getDataModel())).thenReturn((Object)this.oracleMock);
        this.dmoDataManagementStrategy = (DMODataManagementStrategy)Mockito.spy((Object)new DMODataManagementStrategy(this.oracleFactoryMock, this.scenarioSimulationContextLocal){
            {
                this.oracle = DMODataManagementStrategyTest.this.oracleMock;
            }
        });
        this.abstractDataManagementStrategySpy = this.dmoDataManagementStrategy;
    }

    @Test
    public void populateRightPanel() {
        HashMap alreadyAssignedProperties = new HashMap();
        ((DMODataManagementStrategy)Mockito.doReturn(alreadyAssignedProperties).when((Object)this.dmoDataManagementStrategy)).getPropertiesToHide(this.scenarioGridModelMock);
        String[] emptyFactTypes = new String[]{};
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)emptyFactTypes);
        this.dmoDataManagementStrategy.populateRightPanel((RightPanelView.Presenter)this.rightPanelPresenterMock, this.scenarioGridModelMock);
        ((DMODataManagementStrategy)Mockito.verify((Object)this.dmoDataManagementStrategy, (VerificationMode)Mockito.never())).aggregatorCallback((RightPanelView.Presenter)Matchers.eq((Object)this.rightPanelPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock), (List)Matchers.isA(List.class));
        ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.never())).getFieldCompletions(Matchers.anyString(), (Callback)Matchers.any(Callback.class));
        String[] notEmptyFactTypes = this.getRandomStringArray();
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)notEmptyFactTypes);
        this.dmoDataManagementStrategy.populateRightPanel((RightPanelView.Presenter)this.rightPanelPresenterMock, this.scenarioGridModelMock);
        ((DMODataManagementStrategy)Mockito.verify((Object)this.dmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).aggregatorCallback((RightPanelView.Presenter)Matchers.eq((Object)this.rightPanelPresenterMock), Matchers.anyInt(), (SortedMap)Matchers.any(SortedMap.class), (ScenarioGridModel)Matchers.eq((Object)this.scenarioGridModelMock), (List)Matchers.isA(List.class));
        for (String factType : notEmptyFactTypes) {
            ((AsyncPackageDataModelOracle)Mockito.verify((Object)this.oracleMock, (VerificationMode)Mockito.times((int)1))).getFieldCompletions((String)Matchers.eq((Object)factType), (Callback)Matchers.any(Callback.class));
        }
    }

    @Test
    public void manageScenarioSimulationModelContent() {
        this.dmoDataManagementStrategy.manageScenarioSimulationModelContent(this.observablePathMock, this.content);
        Assert.assertEquals((Object)this.dmoDataManagementStrategy.oracle, (Object)this.oracleMock);
    }

    @Test
    public void isADataType() {
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[0]);
        this.commonIsADataType("TEST", false);
        Mockito.when((Object)this.oracleMock.getFactTypes()).thenReturn((Object)new String[]{"TEST"});
        this.commonIsADataType("TOAST", false);
        this.commonIsADataType("TEST", true);
    }

    @Test
    public void fieldCompletionsCallbackMethod() {
        ModelField[] result = new ModelField[]{};
        Callback aggregatorCallbackMock = (Callback)Mockito.mock(Callback.class);
        this.dmoDataManagementStrategy.fieldCompletionsCallbackMethod("FACT_NAME", result, aggregatorCallbackMock);
        ((DMODataManagementStrategy)Mockito.verify((Object)this.dmoDataManagementStrategy, (VerificationMode)Mockito.times((int)1))).getFactModelTree((String)Matchers.eq((Object)"FACT_NAME"), (ModelField[])Matchers.eq((Object)result));
        ((Callback)Mockito.verify((Object)aggregatorCallbackMock, (VerificationMode)Mockito.times((int)1))).callback(Matchers.isA(FactModelTree.class));
    }

    @Test
    public void getFactModelTree() {
        Map<String, String> simpleProperties = this.getSimplePropertiesInner();
        ModelField[] modelFields = this.getModelFieldsInner(simpleProperties);
        FactModelTree retrieved = this.dmoDataManagementStrategy.getFactModelTree("FACT_NAME", modelFields);
        Assert.assertNotNull((Object)retrieved);
        Assert.assertEquals((Object)"FACT_NAME", (Object)retrieved.getFactName());
        Assert.assertEquals((Object)"", (Object)retrieved.getFullPackage());
    }

    @Override
    @Test
    public void getSimpleClassFactModelTree() {
        Class[] expectedClazzes;
        for (Class expectedClazz : expectedClazzes = new Class[]{String.class, Boolean.class, Integer.class, Double.class, Number.class}) {
            FactModelTree retrieved = DMODataManagementStrategy.getSimpleClassFactModelTree((Class)expectedClazz);
            Assert.assertNotNull((Object)retrieved);
            String key = expectedClazz.getSimpleName();
            Assert.assertEquals((Object)key, (Object)retrieved.getFactName());
            String fullName = expectedClazz.getCanonicalName();
            String packageName = fullName.substring(0, fullName.lastIndexOf("."));
            Assert.assertEquals((Object)packageName, (Object)retrieved.getFullPackage());
            Map simpleProperties = retrieved.getSimpleProperties();
            Assert.assertNotNull((Object)simpleProperties);
            Assert.assertEquals((long)1L, (long)simpleProperties.size());
            Util.assertTrue((boolean)simpleProperties.containsKey("value"));
            String simplePropertyValue = (String)simpleProperties.get("value");
            Assert.assertNotNull((Object)simplePropertyValue);
            Assert.assertEquals((Object)fullName, (Object)simplePropertyValue);
        }
    }

    @Test
    public void getInstanceMap() {
        FactModelTree toPopulate = this.getFactModelTreeInner(RandomStringUtils.randomAlphabetic((int)3));
        Map simpleProperties = toPopulate.getSimpleProperties();
        Collection<String> values = simpleProperties.values();
        SortedMap<String, FactModelTree> factTypeFieldsMap = this.getFactTypeFieldsMapInner(values);
        SortedMap retrieved = this.dmoDataManagementStrategy.getInstanceMap(factTypeFieldsMap);
        Assert.assertNotNull((Object)retrieved);
    }

    @Test
    public void populateGenericTypeMap() {
        this.commonPopulateGenericTypeMap(true);
        this.commonPopulateGenericTypeMap(false);
    }

    private void commonIsADataType(String value, boolean expected) {
        boolean retrieved = this.dmoDataManagementStrategy.isADataType(value);
        if (expected) {
            TestCase.assertTrue((boolean)retrieved);
        } else {
            Assert.assertFalse((boolean)retrieved);
        }
    }

    private void commonPopulateGenericTypeMap(boolean isList) {
        HashMap toPopulate = new HashMap();
        String factName = "FACT_NAME";
        String propertyName = "PROPERTY_NAME";
        String factType = "Book";
        String fullFactType = "com." + factType;
        Mockito.when((Object)this.oracleMock.getParametricFieldType(factName, propertyName)).thenReturn((Object)factType);
        Mockito.when((Object)this.oracleMock.getFQCNByFactName(factType)).thenReturn((Object)fullFactType);
        this.dmoDataManagementStrategy.populateGenericTypeMap(toPopulate, factName, propertyName, isList);
        Assert.assertTrue((boolean)toPopulate.containsKey(propertyName));
        List retrieved = (List)toPopulate.get(propertyName);
        if (!isList) {
            Assert.assertEquals((Object)String.class.getName(), retrieved.get(0));
        }
        Assert.assertEquals((Object)fullFactType, retrieved.get(retrieved.size() - 1));
    }

    private ModelField[] getModelFieldsInner(Map<String, String> simpleProperties) {
        ArrayList toReturn = new ArrayList();
        simpleProperties.forEach((key, value) -> toReturn.add(this.getModelFieldInner((String)key, (String)value, "String")));
        return toReturn.toArray(new ModelField[toReturn.size()]);
    }

    private ModelField getModelFieldInner(String name, String clazz, String type) {
        return new ModelField(name, clazz, ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS, ModelField.FIELD_ORIGIN.DECLARED, FieldAccessorsAndMutators.BOTH, type);
    }

    private FactModelTree getFactModelTreeInner(String factName) {
        return new FactModelTree(factName, "scenario.package", this.getSimplePropertiesInner(), new HashMap());
    }

    private SortedMap<String, FactModelTree> getFactTypeFieldsMapInner(Collection<String> keys) {
        return new TreeMap<String, FactModelTree>(keys.stream().collect(Collectors.toMap(key -> key, key -> this.getFactModelTreeInner((String)key))));
    }

    private Map<String, String> getSimplePropertiesInner() {
        String[] keys = this.getRandomStringArray();
        return Arrays.stream(keys).collect(Collectors.toMap(key -> key, key -> {
            key = key + "_VALUE";
            return key;
        }));
    }

    private String[] getRandomStringArray() {
        return new String[]{RandomStringUtils.randomAlphabetic((int)3), RandomStringUtils.randomAlphabetic((int)4), RandomStringUtils.randomAlphabetic((int)5)};
    }
}

