/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.factories;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.drools.workbench.screens.scenariosimulation.client.collectioneditor.CollectionViewImpl;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.domelements.CollectionEditorDOMElement;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationUtils;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.utils.ScenarioSimulationSharedUtils;
import org.uberfire.ext.wires.core.grids.client.model.GridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridData;
import org.uberfire.ext.wires.core.grids.client.widget.context.GridBodyCellRenderContext;
import org.uberfire.ext.wires.core.grids.client.widget.dom.single.impl.BaseSingletonDOMElementFactory;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.ext.wires.core.grids.client.widget.layer.GridLayer;
import org.uberfire.ext.wires.core.grids.client.widget.layer.impl.GridLienzoPanel;

public class CollectionEditorSingletonDOMElementFactory
extends BaseSingletonDOMElementFactory<String, CollectionViewImpl, CollectionEditorDOMElement> {
    protected ViewsProvider viewsProvider;
    protected ScenarioSimulationContext scenarioSimulationContext;

    public CollectionEditorSingletonDOMElementFactory(GridLienzoPanel gridPanel, GridLayer gridLayer, GridWidget gridWidget, ScenarioSimulationContext scenarioSimulationContext, ViewsProvider viewsProvider) {
        super(gridPanel, gridLayer, gridWidget);
        this.scenarioSimulationContext = scenarioSimulationContext;
        this.viewsProvider = viewsProvider;
    }

    public CollectionViewImpl createWidget() {
        return (CollectionViewImpl)this.viewsProvider.getCollectionEditorView();
    }

    public CollectionEditorDOMElement createDomElement(GridLayer gridLayer, GridWidget gridWidget, GridBodyCellRenderContext context) {
        if (this.widget != null) {
            ((CollectionViewImpl)this.widget).close();
        }
        this.widget = this.createWidget();
        ScenarioGridModel model = ((ScenarioGrid)gridWidget).getModel();
        GridData.SelectedCell selectedCellsOrigin = model.getSelectedCellsOrigin();
        Optional<GridColumn> selectedColumn = model.getColumns().stream().filter(col -> col.getIndex() == selectedCellsOrigin.getColumnIndex()).findFirst();
        selectedColumn.ifPresent(col -> {
            int actualIndex = model.getColumns().indexOf(col);
            FactMapping factMapping = model.getSimulation().get().getSimulationDescriptor().getFactMappingByIndex(actualIndex);
            this.setCollectionEditorStructureData((CollectionViewImpl)this.widget, factMapping);
            this.e = this.internalCreateDomElement((CollectionViewImpl)this.widget, gridLayer, gridWidget);
            CollectionEditorDOMElement collectionEditorDOMElement = (CollectionEditorDOMElement)this.e;
            ((CollectionViewImpl)this.widget).addCloseCompositeEventHandler(event -> this.commonCloseHandling(collectionEditorDOMElement));
            ((CollectionViewImpl)this.widget).addSaveEditorEventHandler(event -> this.flush());
        });
        return (CollectionEditorDOMElement)this.e;
    }

    public void destroyResources() {
        if (this.e != null) {
            ((CollectionEditorDOMElement)this.e).detach();
            this.widget = null;
            this.e = null;
        }
    }

    protected String getValue() {
        return this.widget != null ? ((CollectionViewImpl)this.widget).getValue() : null;
    }

    protected void setCollectionEditorStructureData(CollectionViewImpl collectionEditorView, FactMapping factMapping) {
        String propertyClass = factMapping.getClassName();
        String className = factMapping.getFactAlias();
        String propertyName = factMapping.getExpressionAlias();
        List genericTypes = factMapping.getGenericTypes();
        String key = className + "#" + propertyName;
        if (ScenarioSimulationSharedUtils.isList((String)propertyClass)) {
            collectionEditorView.setListWidget(true);
            collectionEditorView.initListStructure(key, this.getPropertiesMap((String)genericTypes.get(0)));
        } else {
            collectionEditorView.setListWidget(false);
            collectionEditorView.initMapStructure(key, this.getPropertiesMap((String)genericTypes.get(0)), this.getPropertiesMap((String)genericTypes.get(1)));
        }
    }

    protected CollectionEditorDOMElement internalCreateDomElement(CollectionViewImpl collectionEditorView, GridLayer gridLayer, GridWidget gridWidget) {
        return new CollectionEditorDOMElement(collectionEditorView, gridLayer, gridWidget);
    }

    protected Map<String, String> getPropertiesMap(String typeName) {
        Map<String, String> toReturn;
        if (ScenarioSimulationUtils.isSimpleJavaType(typeName)) {
            toReturn = new HashMap<String, String>();
            toReturn.put("value", typeName);
        } else {
            Optional<Simulation> simulation = this.scenarioSimulationContext.getModel().getSimulation();
            if (simulation.isPresent() && ScenarioSimulationModel.Type.RULE.equals((Object)simulation.get().getSimulationDescriptor().getType())) {
                typeName = typeName.substring(typeName.lastIndexOf(".") + 1);
            }
            toReturn = ((FactModelTree)this.scenarioSimulationContext.getDataObjectFieldsMap().get(typeName)).getSimpleProperties();
        }
        return toReturn;
    }

    protected void commonCloseHandling(CollectionEditorDOMElement collectionEditorDOMElement) {
        this.destroyResources();
        this.gridLayer.batch();
        this.gridPanel.setFocus(true);
        collectionEditorDOMElement.stopEditingMode();
    }
}

