/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import com.google.gwt.event.shared.EventBus;
import org.drools.workbench.screens.scenariosimulation.client.AbstractScenarioSimulationTest;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public abstract class AbstractScenarioSimulationCommandTest
extends AbstractScenarioSimulationTest {
    @Mock
    protected TestToolsPresenter testToolsPresenterMock;
    @Mock
    protected EventBus eventBusMock;
    protected AbstractScenarioSimulationCommand command;

    @Override
    @Before
    public void setup() {
        super.setup();
    }

    @Test
    public void undoOnUndoable() {
        if (this.command.isUndoable()) {
            this.command.restorableStatus = this.scenarioSimulationContextLocal.getStatus();
            this.command.undo(this.scenarioSimulationContextLocal);
            ((AbstractScenarioSimulationCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).setCurrentContext((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void undoOnNotUndoable() {
        if (this.command.isUndoable()) {
            throw new UnsupportedOperationException();
        }
        this.command.undo(this.scenarioSimulationContextLocal);
    }

    @Test
    public void redoOnRedoable() {
        if (this.command.isUndoable()) {
            this.command.restorableStatus = this.scenarioSimulationContextLocal.getStatus();
            this.command.redo(this.scenarioSimulationContextLocal);
            ((AbstractScenarioSimulationCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).setCurrentContext((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void redoOnNotUndoable() {
        if (this.command.isUndoable()) {
            throw new UnsupportedOperationException();
        }
        this.command.redo(this.scenarioSimulationContextLocal);
    }

    @Test
    public void execute() {
        ScenarioSimulationContext.Status status = this.scenarioSimulationContextLocal.getStatus();
        this.command.execute(this.scenarioSimulationContextLocal);
        try {
            ((AbstractScenarioSimulationCommand)Mockito.verify((Object)this.command, (VerificationMode)Mockito.times((int)1))).internalExecute((ScenarioSimulationContext)Matchers.eq((Object)this.scenarioSimulationContextLocal));
            Assert.assertNotEquals((Object)status, (Object)this.command.restorableStatus);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void setCurrentContext() {
        if (this.command.isUndoable()) {
            ScenarioSimulationContext.Status status;
            this.command.restorableStatus = status = this.scenarioSimulationContextLocal.getStatus();
            this.command.setCurrentContext(this.scenarioSimulationContextLocal);
            ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).clearSelections();
            ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).setContent((Simulation)Matchers.eq((Object)this.simulationMock));
            ((ScenarioSimulationModel)Mockito.verify((Object)this.scenarioSimulationModelMock, (VerificationMode)Mockito.times((int)1))).setSimulation((Simulation)Matchers.eq((Object)this.simulationMock));
            ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.scenarioSimulationEditorPresenterMock, (VerificationMode)Mockito.times((int)1))).reloadTestTools(Matchers.eq((boolean)true));
            Assert.assertNotEquals((Object)status, (Object)this.command.restorableStatus);
        }
    }

    @Test
    public void commonExecution() {
        if (this.command.isUndoable()) {
            this.command.commonExecution(this.scenarioSimulationContextLocal);
            ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
            ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).select();
            ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).setFocus(Matchers.eq((boolean)true));
        }
    }

    @Test
    public void commonExecutionNotUndoable() {
        if (!this.command.isUndoable()) {
            this.command.commonExecution(this.scenarioSimulationContextLocal);
            ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).onResize();
            ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).select();
            ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.never())).setFocus(Matchers.anyBoolean());
        }
    }
}

