/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import junit.framework.TestCase;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.AbstractScenarioSimulationEditorTest;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioMenuItem;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.events.ImportEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.RedoEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.UndoEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationDocksHandler;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.popup.ConfirmPopupPresenter;
import org.drools.workbench.screens.scenariosimulation.client.producers.ScenarioSimulationProducer;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CheatSheetView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.client.type.ScenarioSimulationResourceType;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingValue;
import org.drools.workbench.screens.scenariosimulation.model.Scenario;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.model.TestRunResult;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportService;
import org.drools.workbench.screens.scenariosimulation.service.ImportExportType;
import org.drools.workbench.screens.scenariosimulation.service.ScenarioSimulationService;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.test.TestResultMessage;
import org.guvnor.messageconsole.client.console.widget.button.AlertsButtonMenuItemBuilder;
import org.jboss.errai.common.client.api.Caller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.workbench.common.services.datamodel.model.PackageDataModelOracleBaselinePayload;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.docks.DefaultEditorDock;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.kie.workbench.common.widgets.configresource.client.widget.bound.ImportsWidgetPresenter;
import org.kie.workbench.common.widgets.metadata.client.KieEditorWrapperView;
import org.kie.workbench.common.widgets.metadata.client.widget.OverviewWidgetPresenter;
import org.kie.workbench.common.workbench.client.test.TestRunnerReportingPanel;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.AbstractWorkbenchActivity;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.mvp.PlaceStatus;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDocksInteractionEvent;
import org.uberfire.ext.editor.commons.client.file.exports.TextFileExport;
import org.uberfire.ext.editor.commons.client.history.VersionRecordManager;
import org.uberfire.ext.editor.commons.client.validation.DefaultFileNameValidator;
import org.uberfire.mocks.CallerMock;
import org.uberfire.mocks.EventSourceMock;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.promise.SyncPromises;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.model.menu.MenuItem;

@RunWith(value=GwtMockitoTestRunner.class)
public class ScenarioSimulationEditorPresenterTest
extends AbstractScenarioSimulationEditorTest {
    private ScenarioSimulationEditorPresenter presenter;
    private ScenarioSimulationEditorPresenter presenterSpy;
    @Mock
    private KieEditorWrapperView kieViewMock;
    @Mock
    private OverviewWidgetPresenter overviewWidgetPresenterMock;
    @Mock
    private DefaultFileNameValidator fileNameValidatorMock;
    @Mock
    private AlertsButtonMenuItemBuilder alertsButtonMenuItemBuilderMock;
    @Mock
    private EventSourceMock<NotificationEvent> notificationMock;
    @Mock
    private ScenarioGrid scenarioGridMock;
    @Mock
    private ScenarioGridLayer scenarioGridLayerMock;
    @Mock
    private ScenarioSimulationView scenarioSimulationViewMock;
    @Mock
    private ScenarioGridModel scenarioGridModelMock;
    @Mock
    private ScenarioSimulationProducer scenarioSimulationProducerMock;
    @Mock
    private ImportsWidgetPresenter importsWidgetPresenterMock;
    @Mock
    private PlaceManager placeManagerMock;
    @Mock
    private AbstractWorkbenchActivity testToolsActivityMock;
    @Mock
    private TestToolsView testToolsViewMock;
    @Mock
    private ObservablePath pathMock;
    @Mock
    private PathPlaceRequest placeRequestMock;
    @Mock
    private ScenarioSimulationContext contextMock;
    @Mock
    private ScenarioSimulationContext.Status statusMock;
    @Mock
    private TestRunnerReportingPanel testRunnerReportingPanel;
    @Mock
    private ScenarioSimulationDocksHandler scenarioSimulationDocksHandlerMock;
    private Promises promises;
    @Mock
    private ScenarioMenuItem runScenarioMenuItemMock;
    @Mock
    private ScenarioMenuItem undoMenuItemMock;
    @Mock
    private ScenarioMenuItem redoMenuItemMock;
    @Mock
    private ScenarioMenuItem exportToCsvMenuItemMock;
    @Mock
    private DataManagementStrategy dataManagementStrategyMock;
    @Mock
    private DefaultEditorDock docksMock;
    @Mock
    private PerspectiveManager perspectiveManagerMock;
    @Mock
    private Command saveCommandMock;
    @Mock
    private TextFileExport textFileExportMock;

    @Override
    @Before
    public void setup() {
        this.promises = new SyncPromises();
        super.setup();
        Mockito.when((Object)this.scenarioGridLayerMock.getScenarioGrid()).thenReturn((Object)this.scenarioGridMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridPanel()).thenReturn((Object)this.scenarioGridPanelMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridLayer()).thenReturn((Object)this.scenarioGridLayerMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getRunScenarioMenuItem()).thenReturn((Object)this.runScenarioMenuItemMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getUndoMenuItem()).thenReturn((Object)this.undoMenuItemMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getRedoMenuItem()).thenReturn((Object)this.redoMenuItemMock);
        Mockito.when((Object)this.scenarioSimulationViewMock.getExportToCsvMenuItem()).thenReturn((Object)this.exportToCsvMenuItemMock);
        Mockito.when((Object)this.scenarioGridPanelMock.getScenarioGrid()).thenReturn((Object)this.scenarioGridMock);
        Mockito.when((Object)this.scenarioGridMock.getModel()).thenReturn((Object)this.scenarioGridModelMock);
        Mockito.when((Object)this.scenarioSimulationProducerMock.getScenarioSimulationView()).thenReturn((Object)this.scenarioSimulationViewMock);
        Mockito.when((Object)this.scenarioSimulationProducerMock.getScenarioSimulationContext()).thenReturn((Object)this.contextMock);
        Mockito.when((Object)this.placeRequestMock.getIdentifier()).thenReturn((Object)"ScenarioSimulationEditor");
        Mockito.when((Object)this.testToolsViewMock.getPresenter()).thenReturn((Object)this.testToolsPresenterMock);
        Mockito.when((Object)this.testToolsActivityMock.getWidget()).thenReturn((Object)this.testToolsViewMock);
        Mockito.when((Object)this.placeRequestMock.getPath()).thenReturn((Object)this.pathMock);
        Mockito.when((Object)this.contextMock.getStatus()).thenReturn((Object)this.statusMock);
        Mockito.when((Object)this.perspectiveManagerMock.getCurrentPerspective()).thenReturn(Mockito.mock(PerspectiveActivity.class));
        this.presenter = new ScenarioSimulationEditorPresenter((Caller)new CallerMock((Object)this.scenarioSimulationServiceMock), this.scenarioSimulationProducerMock, (ScenarioSimulationResourceType)Mockito.mock(ScenarioSimulationResourceType.class), this.importsWidgetPresenterMock, this.oracleFactoryMock, this.placeManagerMock, this.testRunnerReportingPanel, this.scenarioSimulationDocksHandlerMock, (Caller)new CallerMock((Object)this.dmnTypeServiceMock), (Caller)new CallerMock((Object)this.importExportServiceMock), this.textFileExportMock, (ConfirmPopupPresenter)Mockito.mock(ConfirmPopupPresenter.class)){
            {
                this.kieView = ScenarioSimulationEditorPresenterTest.this.kieViewMock;
                this.overviewWidget = ScenarioSimulationEditorPresenterTest.this.overviewWidgetPresenterMock;
                this.fileMenuBuilder = ScenarioSimulationEditorPresenterTest.this.fileMenuBuilderMock;
                this.fileNameValidator = ScenarioSimulationEditorPresenterTest.this.fileNameValidatorMock;
                this.versionRecordManager = ScenarioSimulationEditorPresenterTest.this.versionRecordManagerMock;
                this.notification = ScenarioSimulationEditorPresenterTest.this.notificationMock;
                this.workbenchContext = ScenarioSimulationEditorPresenterTest.this.workbenchContextMock;
                this.alertsButtonMenuItemBuilder = ScenarioSimulationEditorPresenterTest.this.alertsButtonMenuItemBuilderMock;
                this.path = ScenarioSimulationEditorPresenterTest.this.pathMock;
                this.scenarioGridPanel = ScenarioSimulationEditorPresenterTest.this.scenarioGridPanelMock;
                this.packageName = "scenario.package";
                this.eventBus = ScenarioSimulationEditorPresenterTest.this.eventBusMock;
                this.context = ScenarioSimulationEditorPresenterTest.this.contextMock;
                this.dataManagementStrategy = ScenarioSimulationEditorPresenterTest.this.dataManagementStrategyMock;
                this.model = ScenarioSimulationEditorPresenterTest.this.scenarioSimulationModelMock;
                this.docks = ScenarioSimulationEditorPresenterTest.this.docksMock;
                this.perspectiveManager = ScenarioSimulationEditorPresenterTest.this.perspectiveManagerMock;
                this.promises = ScenarioSimulationEditorPresenterTest.this.promises;
            }

            protected MenuItem downloadMenuItem() {
                return (MenuItem)Mockito.mock(MenuItem.class);
            }

            protected Command getSaveAndRename() {
                return (Command)Mockito.mock(Command.class);
            }

            protected void clearTestToolsStatus() {
            }

            protected void open(String downloadURL) {
            }

            protected String getJsonModel(ScenarioSimulationModel model) {
                return "";
            }
        };
        this.presenterSpy = (ScenarioSimulationEditorPresenter)Mockito.spy((Object)this.presenter);
    }

    @Test
    public void testPresenterInit() throws Exception {
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock)).init(this.presenter);
    }

    @Test
    public void testOnStartup() {
        AsyncPackageDataModelOracle oracle = (AsyncPackageDataModelOracle)Mockito.mock(AsyncPackageDataModelOracle.class);
        Mockito.when((Object)this.oracleFactoryMock.makeAsyncPackageDataModelOracle((Path)Mockito.any(), (HasImports)Matchers.eq((Object)this.modelLocal), (PackageDataModelOracleBaselinePayload)Matchers.eq((Object)this.content.getDataModel()))).thenReturn((Object)oracle);
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((TestRunnerReportingPanel)Mockito.verify((Object)this.testRunnerReportingPanel)).reset();
        ((ImportsWidgetPresenter)Mockito.verify((Object)this.importsWidgetPresenterMock)).setContent(oracle, this.modelLocal.getImports(), false);
        ((KieEditorWrapperView)Mockito.verify((Object)this.kieViewMock)).addImportsTab((IsWidget)this.importsWidgetPresenterMock);
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock)).showLoading();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock)).hideBusyIndicator();
    }

    @Test
    public void validateButtonShouldNotBeAdded() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).getValidateCommand();
    }

    @Test
    public void runScenarioButtonIsAdded() throws Exception {
        MenuItem menuItem = (MenuItem)Mockito.mock(MenuItem.class);
        ((ScenarioSimulationView)Mockito.doReturn((Object)menuItem).when((Object)this.scenarioSimulationViewMock)).getRunScenarioMenuItem();
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock)).addNewTopLevelMenu(menuItem);
    }

    @Test
    public void onUndo() {
        this.presenter.onUndo();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(UndoEvent.class));
    }

    @Test
    public void onRedo() {
        this.presenter.onRedo();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(RedoEvent.class));
    }

    @Test
    public void setUndoButtonEnabledStatus() {
        this.presenter.setUndoButtonEnabledStatus(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioMenuItem[]{this.undoMenuItemMock});
        this.presenter.setUndoButtonEnabledStatus(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void setRedoButtonEnabledStatus() {
        this.presenter.setRedoButtonEnabledStatus(true);
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)true));
        Mockito.reset((Object[])new ScenarioMenuItem[]{this.redoMenuItemMock});
        this.presenter.setRedoButtonEnabledStatus(false);
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void makeMenuBar() {
        this.presenter.makeMenuBar();
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.runScenarioMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.undoMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.redoMenuItemMock);
        ((FileMenuBuilder)Mockito.verify((Object)this.fileMenuBuilderMock, (VerificationMode)Mockito.times((int)1))).addNewTopLevelMenu((MenuItem)this.exportToCsvMenuItemMock);
        ((ScenarioMenuItem)Mockito.verify((Object)this.undoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
        ((ScenarioMenuItem)Mockito.verify((Object)this.redoMenuItemMock, (VerificationMode)Mockito.times((int)1))).setEnabled(Matchers.eq((boolean)false));
    }

    @Test
    public void save() {
        this.presenter.onStartup((ObservablePath)Mockito.mock(ObservablePath.class), (PlaceRequest)Mockito.mock(PlaceRequest.class));
        Mockito.reset((Object[])new ScenarioSimulationView[]{this.scenarioSimulationViewMock});
        this.presenter.save("save message");
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock)).hideBusyIndicator();
        ((EventSourceMock)Mockito.verify(this.notificationMock)).fire(Mockito.any(NotificationEvent.class));
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock)).reloadVersions((Path)Mockito.any(Path.class));
    }

    @Test
    public void showDocks() {
        this.presenterSpy.showDocks();
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).addDocks();
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).setScesimEditorId((String)Matchers.eq((Object)String.valueOf(this.presenterSpy.scenarioPresenterId)));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy)).expandToolsDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).registerTestToolsCallback();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks((String)Matchers.eq((Object)"org.drools.scenariosimulation.TestTools"));
    }

    @Test
    public void hideDocks() {
        this.presenterSpy.hideDocks();
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).removeDocks();
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).clearSelections();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy)).unRegisterTestToolsCallback();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy)).clearTestToolsStatus();
        ((TestRunnerReportingPanel)Mockito.verify((Object)this.testRunnerReportingPanel)).reset();
    }

    @Test
    public void onUberfireDocksInteractionEventCheatSheet() {
        UberfireDocksInteractionEvent uberfireDocksInteractionEventMock = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.never())).getTargetDock();
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        this.presenterSpy.dataManagementStrategy = null;
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).getCheatSheetPresenter((PlaceRequest)Mockito.any());
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        UberfireDock targetDockMock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"UNKNOWN");
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).getCheatSheetPresenter((PlaceRequest)Mockito.any());
        PlaceRequest cheatSheetPlaceRequestMock = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        Mockito.when((Object)this.presenterSpy.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)cheatSheetPlaceRequestMock);
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.empty()).when((Object)this.presenterSpy)).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)cheatSheetPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.CheatSheet");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)cheatSheetPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).setCheatSheet((CheatSheetView.Presenter)Matchers.eq((Object)this.cheatSheetPresenterMock));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        Mockito.when((Object)this.presenterSpy.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)cheatSheetPlaceRequestMock);
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.cheatSheetPresenterMock)).when((Object)this.presenterSpy)).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)cheatSheetPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.CheatSheet");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getCheatSheetPresenter((PlaceRequest)Matchers.eq((Object)cheatSheetPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setCheatSheet((CheatSheetView.Presenter)Matchers.eq((Object)this.cheatSheetPresenterMock));
    }

    @Test
    public void onUberfireDocksInteractionEventSettings() {
        UberfireDocksInteractionEvent uberfireDocksInteractionEventMock = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)false).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.never())).getTargetDock();
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        this.presenterSpy.dataManagementStrategy = null;
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).getCheatSheetPresenter((PlaceRequest)Mockito.any());
        PlaceRequest settingsPlaceRequestMock = (PlaceRequest)Mockito.mock(PlaceRequest.class);
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        Mockito.when((Object)this.presenterSpy.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)settingsPlaceRequestMock);
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        UberfireDock targetDockMock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"UNKNOWN");
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).getCheatSheetPresenter((PlaceRequest)Mockito.any());
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)this.presenterSpy.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)settingsPlaceRequestMock);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.empty()).when((Object)this.presenterSpy)).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)settingsPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.Settings");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)settingsPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.never())).setSettings((SettingsView.Presenter)Matchers.eq((Object)this.settingsPresenterMock));
        Mockito.reset((Object[])new ScenarioSimulationEditorPresenter[]{this.presenterSpy});
        Mockito.reset((Object[])new UberfireDocksInteractionEvent[]{uberfireDocksInteractionEventMock});
        this.presenterSpy.dataManagementStrategy = this.dataManagementStrategyMock;
        Mockito.when((Object)this.presenterSpy.getCurrentRightDockPlaceRequest(Matchers.anyString())).thenReturn((Object)settingsPlaceRequestMock);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)true).when((Object)this.presenterSpy)).isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn(Optional.of(this.settingsPresenterMock)).when((Object)this.presenterSpy)).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)settingsPlaceRequestMock));
        Mockito.when((Object)targetDockMock.getIdentifier()).thenReturn((Object)"org.drools.scenariosimulation.Settings");
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        this.presenterSpy.onUberfireDocksInteractionEvent(uberfireDocksInteractionEventMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).isUberfireDocksInteractionEventToManage((UberfireDocksInteractionEvent)Matchers.eq((Object)uberfireDocksInteractionEventMock));
        ((UberfireDocksInteractionEvent)Mockito.verify((Object)uberfireDocksInteractionEventMock, (VerificationMode)Mockito.times((int)2))).getTargetDock();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getSettingsPresenter((PlaceRequest)Matchers.eq((Object)settingsPlaceRequestMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getSaveCommand();
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setSettings((SettingsView.Presenter)Matchers.eq((Object)this.settingsPresenterMock));
    }

    @Test
    public void onClose() {
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)this.placeRequestMock)).thenReturn((Object)PlaceStatus.OPEN);
        this.presenter.onClose();
        this.onClosePlaceStatusOpen();
        Mockito.reset((Object[])new ScenarioGridPanel[]{this.scenarioGridPanelMock});
        Mockito.reset((Object[])new VersionRecordManager[]{this.versionRecordManagerMock});
        Mockito.reset((Object[])new PlaceManager[]{this.placeManagerMock});
        Mockito.reset((Object[])new ScenarioSimulationView[]{this.scenarioSimulationViewMock});
        Mockito.when((Object)this.placeManagerMock.getStatus((PlaceRequest)this.placeRequestMock)).thenReturn((Object)PlaceStatus.CLOSE);
        this.presenter.onClose();
        this.onClosePlaceStatusClose();
    }

    @Test
    public void onRunTest() throws Exception {
        ((ScenarioSimulationService)Mockito.doReturn((Object)new ScenarioSimulationModelContent(this.modelLocal, new Overview(), new PackageDataModelOracleBaselinePayload())).when((Object)this.scenarioSimulationServiceMock)).loadContent((Path)Mockito.any());
        Mockito.when((Object)this.scenarioSimulationServiceMock.runScenario((Path)Mockito.any(), (SimulationDescriptor)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)new TestRunResult(this.scenarioMapMock, new TestResultMessage()));
        Mockito.when((Object)this.statusMock.getSimulation()).thenReturn((Object)this.simulationMock);
        Mockito.when((Object)this.contextMock.getStatus()).thenReturn((Object)this.statusMock);
        Assert.assertNotEquals((Object)this.simulationMock, (Object)this.modelLocal.getSimulation());
        this.presenter.onStartup(this.observablePathMock, (PlaceRequest)this.placeRequestMock);
        this.presenter.onRunScenario();
        ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationServiceMock, (VerificationMode)Mockito.times((int)1))).runScenario((Path)Mockito.any(), (SimulationDescriptor)Mockito.any(), (Map)Mockito.any());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).resetErrors();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).refreshContent((Simulation)Mockito.any());
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).expandTestResultsDock();
        Assert.assertEquals((Object)this.simulationMock, (Object)this.modelLocal.getSimulation());
    }

    @Test
    public void onRunTestById() throws Exception {
        Mockito.when((Object)this.scenarioSimulationServiceMock.runScenario((Path)Mockito.any(), (SimulationDescriptor)Mockito.any(), (Map)Mockito.any())).thenReturn((Object)new TestRunResult(Collections.emptyMap(), new TestResultMessage()));
        Mockito.when((Object)this.simulationMock.getScenarioByIndex(Matchers.anyInt())).thenReturn(Mockito.mock(Scenario.class));
        this.presenter.onRunScenario(Collections.singletonList(0));
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).showBusyIndicator(Matchers.anyString());
        ((ScenarioSimulationService)Mockito.verify((Object)this.scenarioSimulationServiceMock, (VerificationMode)Mockito.times((int)1))).runScenario((Path)Mockito.any(), (SimulationDescriptor)Mockito.any(), (Map)Mockito.any());
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).resetErrors();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).refreshContent((Simulation)Mockito.any());
        ((ScenarioSimulationDocksHandler)Mockito.verify((Object)this.scenarioSimulationDocksHandlerMock)).expandTestResultsDock();
    }

    @Test
    public void refreshModelContent() {
        Mockito.when((Object)this.scenarioSimulationModelMock.getSimulation()).thenReturn((Object)this.simulationMock);
        HashSet<AbstractMap.SimpleEntry<Integer, Scenario>> entries = new HashSet<AbstractMap.SimpleEntry<Integer, Scenario>>();
        int scenarioNumber = 1;
        int scenarioIndex = scenarioNumber - 1;
        entries.add(new AbstractMap.SimpleEntry<Integer, Scenario>(scenarioNumber, new Scenario()));
        Mockito.when(this.scenarioMapMock.entrySet()).thenReturn(entries);
        this.presenter.refreshModelContent(new TestRunResult(this.scenarioMapMock, new TestResultMessage()));
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((Simulation)Mockito.verify((Object)this.simulationMock, (VerificationMode)Mockito.times((int)1))).replaceScenario(Matchers.eq((int)scenarioIndex), (Scenario)Mockito.any());
        Assert.assertEquals((Object)this.scenarioSimulationModelMock, (Object)this.presenter.getModel());
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).refreshContent((Simulation)Matchers.eq((Object)this.simulationMock));
        ((ScenarioSimulationContext.Status)Mockito.verify((Object)this.statusMock, (VerificationMode)Mockito.times((int)1))).setSimulation((Simulation)Matchers.eq((Object)this.simulationMock));
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).setModel((ScenarioSimulationModel)Matchers.eq((Object)this.scenarioSimulationModelMock));
    }

    @Test
    public void isDirty() {
        Mockito.when((Object)this.scenarioSimulationViewMock.getScenarioGridPanel()).thenThrow(new Throwable[]{new RuntimeException()});
        Assert.assertFalse((boolean)this.presenter.isDirty());
    }

    @Test
    public void onDownload() {
        String DOWNLOAD_URL = "DOWNLOAD_URL";
        Supplier pathSupplierMock = (Supplier)Mockito.mock(Supplier.class);
        ((ScenarioSimulationEditorPresenter)Mockito.doReturn((Object)DOWNLOAD_URL).when((Object)this.presenterSpy)).getFileDownloadURL((Supplier)Matchers.eq((Object)pathSupplierMock));
        this.presenterSpy.onDownload(pathSupplierMock);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).getFileDownloadURL((Supplier)Matchers.eq((Object)pathSupplierMock));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).open((String)Matchers.eq((Object)DOWNLOAD_URL));
    }

    @Test
    public void showImportDialog() {
        this.presenter.showImportDialog();
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(ImportEvent.class));
    }

    @Test
    public void setTestTools() {
        this.presenter.setTestTools((TestToolsView.Presenter)this.testToolsPresenterMock);
        ((ScenarioSimulationContext)Mockito.verify((Object)this.contextMock, (VerificationMode)Mockito.times((int)1))).setTestToolsPresenter((TestToolsView.Presenter)this.testToolsPresenterMock);
        ((TestToolsPresenter)Mockito.verify((Object)this.testToolsPresenterMock, (VerificationMode)Mockito.times((int)1))).setEventBus(this.eventBusMock);
        ((DataManagementStrategy)Mockito.verify((Object)this.dataManagementStrategyMock, (VerificationMode)Mockito.times((int)1))).populateTestTools((TestToolsView.Presenter)this.testToolsPresenterMock, this.scenarioGridModelMock);
    }

    @Test
    public void setCheatSheet() {
        this.presenter.setCheatSheet((CheatSheetView.Presenter)this.cheatSheetPresenterMock);
        ((CheatSheetPresenter)Mockito.verify((Object)this.cheatSheetPresenterMock, (VerificationMode)Mockito.times((int)1))).initCheatSheet((ScenarioSimulationModel.Type)Mockito.any());
    }

    @Test
    public void setSettings() {
        Command saveCommandMock = (Command)Mockito.mock(Command.class);
        Mockito.when((Object)this.presenterSpy.getSaveCommand()).thenReturn((Object)saveCommandMock);
        this.presenterSpy.setSettings((SettingsView.Presenter)this.settingsPresenterMock);
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.times((int)1))).setScenarioType((ScenarioSimulationModel.Type)Mockito.any(), (SimulationDescriptor)Mockito.any(), Matchers.anyString());
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenterMock, (VerificationMode)Mockito.times((int)1))).setSaveCommand((Command)Matchers.eq((Object)saveCommandMock));
    }

    @Test
    public void isUberfireDocksInteractionEventToManage() {
        UberfireDocksInteractionEvent uberfireDocksInteractionEventMock = (UberfireDocksInteractionEvent)Mockito.mock(UberfireDocksInteractionEvent.class);
        ((UberfireDocksInteractionEvent)Mockito.doReturn(null).when((Object)uberfireDocksInteractionEventMock)).getTargetDock();
        Assert.assertFalse((boolean)this.presenter.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
        UberfireDock targetDockMock = (UberfireDock)Mockito.mock(UberfireDock.class);
        Mockito.when((Object)uberfireDocksInteractionEventMock.getTargetDock()).thenReturn((Object)targetDockMock);
        Mockito.when((Object)targetDockMock.getPlaceRequest()).thenReturn((Object)this.placeRequestMock);
        Mockito.when((Object)this.placeRequestMock.getParameter((String)Matchers.eq((Object)"scesimeditorid"), (String)Matchers.eq((Object)""))).thenReturn((Object)"UNKNOWN");
        Assert.assertFalse((boolean)this.presenter.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
        ((PathPlaceRequest)Mockito.doReturn((Object)String.valueOf(this.presenter.scenarioPresenterId)).when((Object)this.placeRequestMock)).getParameter((String)Matchers.eq((Object)"scesimeditorid"), (String)Matchers.eq((Object)""));
        TestCase.assertTrue((boolean)this.presenter.isUberfireDocksInteractionEventToManage(uberfireDocksInteractionEventMock));
    }

    @Test
    public void getModelSuccessCallbackMethod() {
        this.presenterSpy.getModelSuccessCallbackMethod(this.content);
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks("org.drools.scenariosimulation.TestTools");
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).populateRightDocks("org.drools.scenariosimulation.Settings");
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).hideBusyIndicator();
        ((ScenarioSimulationView)Mockito.verify((Object)this.scenarioSimulationViewMock, (VerificationMode)Mockito.times((int)1))).setContent((Simulation)Matchers.eq((Object)this.content.getModel().getSimulation()));
        ((ScenarioSimulationContext.Status)Mockito.verify((Object)this.statusMock, (VerificationMode)Mockito.times((int)1))).setSimulation((Simulation)Matchers.eq((Object)this.content.getModel().getSimulation()));
        ((ScenarioSimulationEditorPresenter)Mockito.verify((Object)this.presenterSpy, (VerificationMode)Mockito.times((int)1))).setOriginalHash(Integer.valueOf(Matchers.anyInt()));
    }

    @Test
    public void onExportToCsv() {
        this.presenter.onExportToCsv();
        ((ImportExportService)Mockito.verify((Object)this.importExportServiceMock, (VerificationMode)Mockito.times((int)1))).exportSimulation((ImportExportType)Matchers.eq((Object)ImportExportType.CSV), (Simulation)Mockito.any());
        ((TextFileExport)Mockito.verify((Object)this.textFileExportMock, (VerificationMode)Mockito.times((int)1))).export(Mockito.any(), Matchers.anyString());
    }

    @Test
    public void onImport() {
        Mockito.when((Object)this.importExportServiceMock.importSimulation((ImportExportType)Mockito.any(), Mockito.any(), (Simulation)Mockito.any())).thenReturn((Object)new Simulation());
        String FILE_CONTENT = "FILE_CONTENT";
        this.presenterSpy.onImport(FILE_CONTENT);
        ((ImportExportService)Mockito.verify((Object)this.importExportServiceMock, (VerificationMode)Mockito.times((int)1))).importSimulation((ImportExportType)Matchers.eq((Object)ImportExportType.CSV), Matchers.eq((Object)FILE_CONTENT), (Simulation)Mockito.any());
    }

    private void onClosePlaceStatusOpen() {
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).unregister();
    }

    private void onClosePlaceStatusClose() {
        ((VersionRecordManager)Mockito.verify((Object)this.versionRecordManagerMock, (VerificationMode)Mockito.times((int)1))).clear();
        ((PlaceManager)Mockito.verify((Object)this.placeManagerMock, (VerificationMode)Mockito.times((int)0))).closePlace((PlaceRequest)this.placeRequestMock);
        ((ScenarioGridPanel)Mockito.verify((Object)this.scenarioGridPanelMock, (VerificationMode)Mockito.times((int)1))).unregister();
    }

    @Test
    public void cleanReadOnlyColumn() {
        Simulation simulation = new Simulation();
        SimulationDescriptor simulationDescriptor = simulation.getSimulationDescriptor();
        FactMapping test1 = simulationDescriptor.addFactMapping(FactIdentifier.create((String)"test1", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"", (FactMappingType)FactMappingType.GIVEN));
        FactMapping test2 = simulationDescriptor.addFactMapping(FactIdentifier.create((String)"test2", (String)String.class.getCanonicalName()), ExpressionIdentifier.create((String)"", (FactMappingType)FactMappingType.GIVEN));
        test1.addExpressionElement("test", String.class.getCanonicalName());
        Scenario scenario = simulation.addScenario();
        scenario.addMappingValue(test1.getFactIdentifier(), test1.getExpressionIdentifier(), (Object)"value");
        scenario.addMappingValue(test2.getFactIdentifier(), test2.getExpressionIdentifier(), (Object)"value");
        this.presenter.cleanReadOnlyColumn(simulation);
        Assert.assertNotNull((Object)((FactMappingValue)scenario.getFactMappingValue(test1.getFactIdentifier(), test1.getExpressionIdentifier()).get()).getRawValue());
        Assert.assertNull((Object)((FactMappingValue)scenario.getFactMappingValue(test2.getFactIdentifier(), test2.getExpressionIdentifier()).get()).getRawValue());
    }
}

