/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.ait.lienzo.client.core.types.Point2D;
import com.ait.lienzo.test.LienzoMockitoTestRunner;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import org.drools.workbench.screens.scenariosimulation.client.TestProperties;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridHandlerTest;
import org.drools.workbench.screens.scenariosimulation.client.handlers.ScenarioSimulationGridPanelClickHandler;
import org.drools.workbench.screens.scenariosimulation.client.menu.ScenarioContextMenuRegistry;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGrid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=LienzoMockitoTestRunner.class)
public class ScenarioSimulationGridPanelClickHandlerTest
extends AbstractScenarioSimulationGridHandlerTest {
    private ScenarioSimulationGridPanelClickHandler scenarioSimulationGridPanelClickHandler;
    @Mock
    private EventBus eventBusMock;
    @Mock
    private ScenarioContextMenuRegistry scenarioContextMenuRegistryMock;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.scenarioSimulationGridPanelClickHandler = (ScenarioSimulationGridPanelClickHandler)Mockito.spy((Object)new ScenarioSimulationGridPanelClickHandler(){
            {
                this.scenarioGrid = ScenarioSimulationGridPanelClickHandlerTest.this.scenarioGridMock;
                this.scenarioContextMenuRegistry = ScenarioSimulationGridPanelClickHandlerTest.this.scenarioContextMenuRegistryMock;
                this.eventBus = ScenarioSimulationGridPanelClickHandlerTest.this.eventBusMock;
                this.rendererHelper = ScenarioSimulationGridPanelClickHandlerTest.this.scenarioGridRendererHelperMock;
            }
        });
    }

    @Test
    public void setScenarioGrid() {
        this.scenarioSimulationGridPanelClickHandler.setScenarioGrid(this.scenarioGridMock);
        Assert.assertEquals((Object)this.scenarioGridMock, (Object)this.scenarioSimulationGridPanelClickHandler.scenarioGrid);
    }

    @Test
    public void setEventBus() {
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.eventBusMock);
        ((ScenarioContextMenuRegistry)Mockito.verify((Object)this.scenarioContextMenuRegistryMock, (VerificationMode)Mockito.times((int)1))).setEventBus((EventBus)Matchers.eq((Object)this.eventBusMock));
    }

    @Test
    public void onContextMenu() {
        ((ScenarioContextMenuRegistry)Mockito.doReturn((Object)true).when((Object)this.scenarioContextMenuRegistryMock)).manageRightClick(this.scenarioGridMock, this.contextMenuEventMock);
        this.scenarioSimulationGridPanelClickHandler.onContextMenu(this.contextMenuEventMock);
        ((ContextMenuEvent)Mockito.verify((Object)this.contextMenuEventMock, (VerificationMode)Mockito.times((int)1))).preventDefault();
        ((ContextMenuEvent)Mockito.verify((Object)this.contextMenuEventMock, (VerificationMode)Mockito.times((int)1))).stopPropagation();
        ((ScenarioContextMenuRegistry)Mockito.verify((Object)this.scenarioContextMenuRegistryMock, (VerificationMode)Mockito.times((int)1))).hideMenus();
    }

    @Test
    public void hideMenus() {
        this.scenarioSimulationGridPanelClickHandler.hideMenus();
        ((ScenarioContextMenuRegistry)Mockito.verify((Object)this.scenarioContextMenuRegistryMock, (VerificationMode)Mockito.times((int)1))).hideMenus();
    }

    @Test
    public void testManageLeftClick() {
        Mockito.when((Object)this.point2DMock.getX()).thenReturn((Object)5.0);
        Mockito.when((Object)this.point2DMock.getY()).thenReturn((Object)5.0);
        Assert.assertTrue((String)"testManageLeftClick fail", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
    }

    @Test
    public void testManageLeftClick_ReadOnly() {
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)true);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.eventBusMock);
        Assert.assertTrue((String)"Click to readonly header cell.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.any(EnableTestToolsEvent.class));
    }

    @Test
    public void testManageLeftClick_NextToGrid() {
        Assert.assertFalse((String)"Click to point next to table.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(TestProperties.GRID_WIDTH.intValue() + 5, 5));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any(EnableTestToolsEvent.class));
    }

    @Test
    public void testManageLeftClick_BelowHeader() {
        Assert.assertFalse((String)"Click to point below header.", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, TestProperties.HEADER_HEIGHT.intValue() + 5));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.anyInt(), Matchers.anyInt());
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any(EnableTestToolsEvent.class));
    }

    @Test
    public void testManageHeaderLeftClick_NoEditableHeader() {
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)true);
        Assert.assertTrue((String)"NoEditableHeader fail", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
    }

    @Test
    public void testManageHeaderLeftClick_NullUIHeaderRowIndex() {
        Assert.assertFalse((String)"NullUIHeaderRowIndex fail", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 15));
    }

    @Test
    public void testManageHeaderLeftClick_NullMetadata() {
        Mockito.when(this.headerMetaDatasMock.get(Matchers.anyInt())).thenReturn(null);
        Assert.assertFalse((String)"NullMetadata fail", (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
    }

    @Test
    public void testManageHeaderLeftClick_GIVENGroup() {
        this.commontTestManageHeaderLeftClick_Group("GIVEN", true);
    }

    @Test
    public void testManageHeaderLeftClick_EXPECTGroup() {
        this.commontTestManageHeaderLeftClick_Group("EXPECT", true);
    }

    @Test
    public void testManageHeaderLeftClick_OTHERGroup() {
        this.commontTestManageHeaderLeftClick_Group("OTHER", false);
    }

    @Test
    public void testManageGridLeftClickReadOnlyTrue() {
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)true);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.eventBusMock);
        Mockito.when((Object)this.scenarioGridCellMock.isEditingMode()).thenReturn((Object)false);
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn(null).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiHeaderRowIndexLocal((Point2D)Matchers.isA(Point2D.class));
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)1).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiRowIndexLocal(Matchers.anyDouble());
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)0).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiColumnIndexLocal(Matchers.anyDouble());
        Assert.assertTrue((boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).selectCell(Matchers.eq((int)1), Matchers.eq((int)0));
    }

    @Test
    public void testManageGridLeftClickReadOnlyFalse() {
        Mockito.when((Object)this.scenarioGridMock.startEditingCell(1, 0)).thenReturn((Object)true);
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)false);
        this.scenarioSimulationGridPanelClickHandler.setEventBus(this.eventBusMock);
        Mockito.when((Object)this.scenarioGridCellMock.isEditingMode()).thenReturn((Object)false);
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn(null).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiHeaderRowIndexLocal((Point2D)Matchers.isA(Point2D.class));
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)1).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiRowIndexLocal(Matchers.anyDouble());
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)0).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiColumnIndexLocal(Matchers.anyDouble());
        ((ScenarioGridModel)Mockito.doReturn((Object)this.scenarioGridCellMock).when((Object)this.scenarioGridModelMock)).getCell(1, 0);
        Assert.assertTrue((boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
        ((ScenarioGridModel)Mockito.verify((Object)this.scenarioGridModelMock, (VerificationMode)Mockito.times((int)1))).selectCell(Matchers.eq((int)1), Matchers.eq((int)0));
    }

    private void commontTestManageHeaderLeftClick_Group(String group, boolean assertExpected) {
        ((ScenarioSimulationGridPanelClickHandler)Mockito.doReturn((Object)1).when((Object)this.scenarioSimulationGridPanelClickHandler)).getUiHeaderRowIndexLocal(this.point2DMock);
        Mockito.when((Object)this.informationHeaderMetaDataMock.isReadOnly()).thenReturn((Object)false);
        Mockito.when((Object)this.informationHeaderMetaDataMock.getColumnGroup()).thenReturn((Object)group);
        String message = group + "Group fail";
        if (!assertExpected) {
            Assert.assertFalse((String)message, (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
            ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.never())).setSelectedColumnAndHeader(Matchers.eq((int)0), Matchers.eq((int)0));
            ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.never())).fireEvent((GwtEvent)Matchers.any());
            return;
        }
        Assert.assertTrue((String)message, (boolean)this.scenarioSimulationGridPanelClickHandler.manageLeftClick(5, 5));
        ((ScenarioGrid)Mockito.verify((Object)this.scenarioGridMock, (VerificationMode)Mockito.times((int)1))).setSelectedColumnAndHeader(Matchers.eq((int)0), Matchers.eq((int)0));
        ((EventBus)Mockito.verify((Object)this.eventBusMock, (VerificationMode)Mockito.times((int)1))).fireEvent((GwtEvent)Matchers.isA(EnableTestToolsEvent.class));
    }
}

