/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractScenarioSimulationCommand;
import org.drools.workbench.screens.scenariosimulation.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;

@Dependent
public class SetHeaderCellValueCommand
extends AbstractScenarioSimulationCommand {
    protected boolean isInstanceHeader;
    protected boolean isPropertyHeader;

    public SetHeaderCellValueCommand() {
        this(false, false);
    }

    public SetHeaderCellValueCommand(boolean isInstanceHeader, boolean isPropertyHeader) {
        super(true);
        this.isInstanceHeader = isInstanceHeader;
        this.isPropertyHeader = isPropertyHeader;
    }

    @Override
    protected void internalExecute(ScenarioSimulationContext context) throws Exception {
        ScenarioSimulationContext.Status status = context.getStatus();
        String headerCellValue = status.getHeaderCellValue();
        if (this.isInstanceHeader) {
            this.validateInstanceHeader(context, headerCellValue, status.getColumnIndex());
        } else if (this.isPropertyHeader) {
            this.validatePropertyHeader(context, headerCellValue, status.getColumnIndex());
        }
        context.getModel().updateHeader(status.getColumnIndex(), status.getRowIndex(), headerCellValue);
    }

    protected void validateInstanceHeader(ScenarioSimulationContext context, String headerCellValue, int columnIndex) throws Exception {
        List<String> instanceNameElements = Collections.unmodifiableList(Arrays.asList(headerCellValue.split("\\.")));
        boolean isADataType = !headerCellValue.endsWith(".") && instanceNameElements.size() == 1 && context.getDataObjectFieldsMap().containsKey(instanceNameElements.get(0));
        context.getModel().validateInstanceHeaderUpdate(headerCellValue, columnIndex, isADataType);
    }

    protected void validatePropertyHeader(ScenarioSimulationContext context, String headerCellValue, int columnIndex) throws Exception {
        List<String> propertyNameElements = Collections.unmodifiableList(Arrays.asList(headerCellValue.split("\\.")));
        FactMapping factMappingByIndex = context.getStatus().getSimulation().getSimulationDescriptor().getFactMappingByIndex(columnIndex);
        String className = factMappingByIndex.getFactIdentifier().getClassNameWithoutPackage();
        FactModelTree factModelTree = (FactModelTree)context.getDataObjectFieldsMap().get(className);
        boolean isPropertyType = !headerCellValue.endsWith(".") && factModelTree != null && this.recursivelyFindIsPropertyType(context, factModelTree, propertyNameElements);
        context.getModel().validatePropertyHeaderUpdate(headerCellValue, columnIndex, isPropertyType);
    }

    protected boolean recursivelyFindIsPropertyType(ScenarioSimulationContext context, FactModelTree factModelTree, List<String> propertyNameElements) {
        boolean toReturn;
        boolean bl = toReturn = propertyNameElements.size() == 1 && (factModelTree.getSimpleProperties().containsKey(propertyNameElements.get(0)) || factModelTree.getExpandableProperties().containsKey(propertyNameElements.get(0)));
        if (!toReturn && propertyNameElements.size() > 1) {
            String propertyParent = propertyNameElements.get(0);
            if (factModelTree.getExpandableProperties().containsKey(propertyParent)) {
                List<String> nestedPropertyNameElements = propertyNameElements.subList(1, propertyNameElements.size());
                String className = (String)factModelTree.getExpandableProperties().get(propertyParent);
                FactModelTree nestedFactModelTree = (FactModelTree)context.getDataObjectFieldsMap().get(className);
                toReturn = this.recursivelyFindIsPropertyType(context, nestedFactModelTree, nestedPropertyNameElements);
            }
        }
        return toReturn;
    }
}

