/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor;

import com.google.gwt.user.client.ui.Widget;
import java.util.function.Supplier;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioMenuItem;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationEditorPresenter;
import org.drools.workbench.screens.scenariosimulation.client.editor.ScenarioSimulationView;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridLayer;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridPanel;
import org.drools.workbench.screens.scenariosimulation.model.Simulation;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.kie.workbench.common.widgets.metadata.client.KieEditorViewImpl;
import org.uberfire.backend.vfs.Path;
import org.uberfire.ext.wires.core.grids.client.widget.grid.GridWidget;
import org.uberfire.workbench.model.menu.MenuItem;

@Dependent
public class ScenarioSimulationViewImpl
extends KieEditorViewImpl
implements ScenarioSimulationView {
    private ScenarioGridPanel scenarioGridPanel;
    private ScenarioSimulationEditorPresenter presenter;
    private ScenarioGridLayer scenarioGridLayer;
    private ScenarioMenuItem runMenuItem;
    private ScenarioMenuItem undoMenuItem;
    private ScenarioMenuItem redoMenuItem;
    private ScenarioMenuItem downloadMenuItem;
    private ScenarioMenuItem importMenuItem;
    private ScenarioMenuItem exportToCsvMenuItem;

    @Override
    public void setScenarioGridPanel(ScenarioGridPanel scenarioGridPanel) {
        this.scenarioGridPanel = scenarioGridPanel;
        this.scenarioGridLayer = scenarioGridPanel.getScenarioGridLayer();
    }

    @Override
    public void init(ScenarioSimulationEditorPresenter presenter) {
        this.presenter = presenter;
        this.scenarioGridLayer.enterPinnedMode((GridWidget)this.scenarioGridLayer.getScenarioGrid(), () -> {});
        this.initWidget((Widget)this.scenarioGridPanel);
    }

    @Override
    public void setContent(Simulation simulation) {
        this.scenarioGridPanel.getScenarioGrid().setContent(simulation);
        this.scenarioGridPanel.setFocus(true);
    }

    @Override
    public void refreshContent(Simulation simulation) {
        this.scenarioGridPanel.getScenarioGrid().getModel().bindContent(simulation);
        this.refreshErrors();
    }

    @Override
    public MenuItem getRunScenarioMenuItem() {
        if (this.runMenuItem == null) {
            this.runMenuItem = new ScenarioMenuItem(IconType.PLAY, () -> this.presenter.onRunScenario());
        }
        return this.runMenuItem;
    }

    @Override
    public MenuItem getUndoMenuItem() {
        if (this.undoMenuItem == null) {
            this.undoMenuItem = new ScenarioMenuItem(IconType.UNDO, () -> this.presenter.onUndo());
        }
        return this.undoMenuItem;
    }

    @Override
    public MenuItem getRedoMenuItem() {
        if (this.redoMenuItem == null) {
            this.redoMenuItem = new ScenarioMenuItem(IconType.REPEAT, () -> this.presenter.onRedo());
        }
        return this.redoMenuItem;
    }

    @Override
    public MenuItem getDownloadMenuItem(Supplier<Path> pathSupplier) {
        if (this.downloadMenuItem == null) {
            this.downloadMenuItem = new ScenarioMenuItem(IconType.DOWNLOAD, () -> this.presenter.onDownload(pathSupplier));
        }
        return this.downloadMenuItem;
    }

    @Override
    public MenuItem getExportToCsvMenuItem() {
        if (this.exportToCsvMenuItem == null) {
            this.exportToCsvMenuItem = new ScenarioMenuItem("Export", () -> this.presenter.onExportToCsv());
        }
        return this.exportToCsvMenuItem;
    }

    @Override
    public MenuItem getImportMenuItem() {
        if (this.importMenuItem == null) {
            this.importMenuItem = new ScenarioMenuItem(ScenarioSimulationEditorConstants.INSTANCE.importLabel(), () -> this.presenter.showImportDialog());
        }
        return this.importMenuItem;
    }

    @Override
    public ScenarioGridPanel getScenarioGridPanel() {
        return this.scenarioGridPanel;
    }

    @Override
    public ScenarioGridLayer getScenarioGridLayer() {
        return this.scenarioGridLayer;
    }

    private void refreshErrors() {
        this.scenarioGridPanel.getScenarioGrid().getModel().refreshErrors();
        this.onResize();
    }

    public void onResize() {
        Widget parent = this.getParent();
        if (parent != null) {
            double w = parent.getOffsetWidth();
            double h = parent.getOffsetHeight();
            this.setPixelSize((int)w, (int)h);
        }
        this.scenarioGridPanel.onResize();
    }
}

