/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.Style;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSubDockPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModel;
import org.drools.workbench.screens.scenariosimulation.model.SimulationDescriptor;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.mvp.Command;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.scenariosimulation.Settings", preferredWidth=300)
public class SettingsPresenter
extends AbstractSubDockPresenter<SettingsView>
implements SettingsView.Presenter {
    public static final int DEFAULT_PREFERRED_WIDHT = 300;
    public static final String IDENTIFIER = "org.drools.scenariosimulation.Settings";
    protected SimulationDescriptor simulationDescriptor;
    protected Command saveCommand;

    public SettingsPresenter() {
        this.title = ScenarioSimulationEditorConstants.INSTANCE.settings();
    }

    @Inject
    public SettingsPresenter(SettingsView view) {
        super(view);
        this.title = ScenarioSimulationEditorConstants.INSTANCE.settings();
    }

    @Override
    public void setScenarioType(ScenarioSimulationModel.Type scenarioType, SimulationDescriptor simulationDescriptor, String fileName) {
        this.simulationDescriptor = simulationDescriptor;
        ((SettingsView)this.view).getScenarioType().setInnerText(scenarioType.name());
        ((SettingsView)this.view).getFileName().setInnerText(fileName);
        ((SettingsView)this.view).getSkipFromBuild().setChecked(simulationDescriptor.isSkipFromBuild());
        switch (scenarioType) {
            case RULE: {
                this.setRuleSettings(simulationDescriptor);
                break;
            }
            case DMN: {
                this.setDMNSettings(simulationDescriptor);
            }
        }
    }

    @Override
    public void setSaveCommand(Command saveCommand) {
        this.saveCommand = saveCommand;
    }

    @Override
    public void onSaveButton(String scenarioType) {
        this.simulationDescriptor.setSkipFromBuild(((SettingsView)this.view).getSkipFromBuild().isChecked());
        this.simulationDescriptor.setFileName(((SettingsView)this.view).getFileName().getInnerText());
        switch (ScenarioSimulationModel.Type.valueOf((String)scenarioType)) {
            case RULE: {
                this.saveRuleSettings();
                break;
            }
            case DMN: {
                this.saveDMNSettings();
            }
        }
        this.saveCommand.execute();
    }

    protected void setRuleSettings(SimulationDescriptor simulationDescriptor) {
        ((SettingsView)this.view).getDmnSettings().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getRuleSettings().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmoSession().setValue(simulationDescriptor.getDmoSession());
        ((SettingsView)this.view).getKieBase().setValue(simulationDescriptor.getKieBase());
        ((SettingsView)this.view).getKieSession().setValue(simulationDescriptor.getKieSession());
        ((SettingsView)this.view).getRuleFlowGroup().setValue(simulationDescriptor.getRuleFlowGroup());
    }

    protected void setDMNSettings(SimulationDescriptor simulationDescriptor) {
        ((SettingsView)this.view).getRuleSettings().getStyle().setDisplay(Style.Display.NONE);
        ((SettingsView)this.view).getDmnSettings().getStyle().setDisplay(Style.Display.INLINE);
        ((SettingsView)this.view).getDmnFilePath().setInnerText(simulationDescriptor.getDmnFilePath());
        ((SettingsView)this.view).getDmnName().setInnerText(simulationDescriptor.getDmnName());
        ((SettingsView)this.view).getDmnNamespace().setInnerText(simulationDescriptor.getDmnNamespace());
    }

    protected void saveRuleSettings() {
        this.simulationDescriptor.setDmoSession(((SettingsView)this.view).getDmoSession().getValue());
        this.simulationDescriptor.setKieBase(((SettingsView)this.view).getKieBase().getValue());
        this.simulationDescriptor.setKieSession(((SettingsView)this.view).getKieSession().getValue());
        this.simulationDescriptor.setRuleFlowGroup(((SettingsView)this.view).getRuleFlowGroup().getValue());
    }

    protected void saveDMNSettings() {
        this.simulationDescriptor.setDmnFilePath(((SettingsView)this.view).getDmnFilePath().getInnerText());
        this.simulationDescriptor.setDmnName(((SettingsView)this.view).getDmnName().getInnerText());
        this.simulationDescriptor.setDmnNamespace(((SettingsView)this.view).getDmnNamespace().getInnerText());
    }
}

