/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.DivElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.events.SetInstanceHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.SetPropertyHeaderEvent;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSubDockPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.FieldItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.ListGroupItemView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.uberfire.client.annotations.WorkbenchScreen;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.scenariosimulation.TestTools", preferredWidth=300)
public class TestToolsPresenter
extends AbstractSubDockPresenter<TestToolsView>
implements TestToolsView.Presenter {
    public static final String IDENTIFIER = "org.drools.scenariosimulation.TestTools";
    private ListGroupItemPresenter listGroupItemPresenter;
    protected Map<String, FactModelTree> dataObjectFieldsMap = new TreeMap<String, FactModelTree>();
    protected Map<String, FactModelTree> simpleJavaTypeFieldsMap = new TreeMap<String, FactModelTree>();
    protected Map<String, FactModelTree> instanceFieldsMap = new TreeMap<String, FactModelTree>();
    protected Map<String, FactModelTree> simpleJavaInstanceFieldsMap = new TreeMap<String, FactModelTree>();
    protected Map<String, FactModelTree> hiddenFieldsMap = new TreeMap<String, FactModelTree>();
    protected EventBus eventBus;
    protected boolean editingColumnEnabled = false;
    protected ListGroupItemView selectedListGroupItemView;
    protected FieldItemView selectedFieldItemView;

    public TestToolsPresenter() {
        this.title = ScenarioSimulationEditorConstants.INSTANCE.testTools();
    }

    @Inject
    public TestToolsPresenter(TestToolsView view, ListGroupItemPresenter listGroupItemPresenter) {
        super(view);
        this.listGroupItemPresenter = listGroupItemPresenter;
        this.listGroupItemPresenter.init(this);
        this.title = ScenarioSimulationEditorConstants.INSTANCE.testTools();
    }

    @Override
    public void onClearSearch() {
        ((TestToolsView)this.view).clearInputSearch();
        ((TestToolsView)this.view).hideClearButton();
        this.onSearchedEvent("");
    }

    @Override
    public void onClearNameField() {
        ((TestToolsView)this.view).clearNameField();
    }

    @Override
    public void onClearStatus() {
        this.onClearSearch();
        this.onClearNameField();
    }

    @Override
    public void clearDataObjectList() {
        ((TestToolsView)this.view).getDataObjectListContainer().removeAllChildren();
    }

    @Override
    public void clearSimpleJavaTypeList() {
        ((TestToolsView)this.view).getSimpleJavaTypeListContainer().removeAllChildren();
    }

    @Override
    public void clearInstanceList() {
        ((TestToolsView)this.view).getInstanceListContainer().removeAllChildren();
    }

    @Override
    public void clearSimpleJavaInstanceFieldList() {
        ((TestToolsView)this.view).getSimpleJavaInstanceListContainer().removeAllChildren();
    }

    @Override
    public void updateDataObjectListSeparator() {
        if (((TestToolsView)this.view).getDataObjectListContainer().getChildCount() == 0) {
            ((TestToolsView)this.view).getDataObjectListContainerSeparator().getStyle().setDisplay(Style.Display.NONE);
        } else {
            ((TestToolsView)this.view).getDataObjectListContainerSeparator().getStyle().setDisplay(Style.Display.BLOCK);
        }
    }

    @Override
    public void updateSimpleJavaTypeListSeparator() {
        if (((TestToolsView)this.view).getSimpleJavaTypeListContainer().getChildCount() == 0) {
            ((TestToolsView)this.view).getSimpleJavaTypeListContainerSeparator().getStyle().setDisplay(Style.Display.NONE);
        } else {
            ((TestToolsView)this.view).getSimpleJavaTypeListContainerSeparator().getStyle().setDisplay(Style.Display.BLOCK);
        }
    }

    @Override
    public void updateInstanceListSeparator() {
        if (((TestToolsView)this.view).getInstanceListContainer().getChildCount() == 0) {
            ((TestToolsView)this.view).getInstanceListContainerSeparator().getStyle().setDisplay(Style.Display.NONE);
        } else {
            ((TestToolsView)this.view).getInstanceListContainerSeparator().getStyle().setDisplay(Style.Display.BLOCK);
        }
    }

    @Override
    public void updateSimpleJavaInstanceFieldListSeparator() {
        if (((TestToolsView)this.view).getSimpleJavaInstanceListContainer().getChildCount() == 0) {
            ((TestToolsView)this.view).getSimpleJavaInstanceListContainerSeparator().getStyle().setDisplay(Style.Display.NONE);
        } else {
            ((TestToolsView)this.view).getSimpleJavaInstanceListContainerSeparator().getStyle().setDisplay(Style.Display.BLOCK);
        }
    }

    @Override
    public Optional<FactModelTree> getFactModelTreeFromFactTypeMap(String factName) {
        return Optional.ofNullable(this.dataObjectFieldsMap.get(factName));
    }

    @Override
    public Optional<FactModelTree> getFactModelTreeFromSimpleJavaTypeMap(String factName) {
        return Optional.ofNullable(this.simpleJavaTypeFieldsMap.get(factName));
    }

    @Override
    public Optional<FactModelTree> getFactModelTreeFromInstanceMap(String factName) {
        return Optional.ofNullable(this.instanceFieldsMap.get(factName));
    }

    @Override
    public Optional<FactModelTree> getFactModelTreeFromSimpleJavaInstanceMap(String factName) {
        return Optional.ofNullable(this.simpleJavaInstanceFieldsMap.get(factName));
    }

    @Override
    public FactModelTree getFactModelTreeFromHiddenMap(String factName) {
        return this.hiddenFieldsMap.get(factName);
    }

    @Override
    public void setDataObjectFieldsMap(SortedMap<String, FactModelTree> dataObjectFieldsMap) {
        this.clearDataObjectList();
        this.dataObjectFieldsMap = dataObjectFieldsMap;
        this.dataObjectFieldsMap.forEach(this::addDataObjectListGroupItemView);
        this.updateDataObjectListSeparator();
    }

    @Override
    public void setSimpleJavaTypeFieldsMap(SortedMap<String, FactModelTree> simpleJavaTypeFieldsMap) {
        this.clearSimpleJavaTypeList();
        this.simpleJavaTypeFieldsMap = simpleJavaTypeFieldsMap;
        this.simpleJavaTypeFieldsMap.forEach(this::addSimpleJavaTypeListGroupItemView);
        this.updateSimpleJavaTypeListSeparator();
    }

    @Override
    public void setInstanceFieldsMap(SortedMap<String, FactModelTree> instanceFieldsMap) {
        this.clearInstanceList();
        this.instanceFieldsMap = instanceFieldsMap;
        this.instanceFieldsMap.forEach(this::addInstanceListGroupItemView);
        this.updateInstanceListSeparator();
    }

    @Override
    public void setSimpleJavaInstanceFieldsMap(SortedMap<String, FactModelTree> simpleJavaInstanceFieldsMap) {
        this.clearSimpleJavaInstanceFieldList();
        this.simpleJavaInstanceFieldsMap = simpleJavaInstanceFieldsMap;
        this.simpleJavaInstanceFieldsMap.forEach(this::addSimpleJavaInstanceListGroupItemView);
        this.updateSimpleJavaInstanceFieldListSeparator();
    }

    @Override
    public void setHiddenFieldsMap(SortedMap<String, FactModelTree> hiddenFieldsMap) {
        this.hiddenFieldsMap = hiddenFieldsMap;
    }

    @Override
    public void hideProperties(Map<String, List<List<String>>> propertiesToHide) {
        this.listGroupItemPresenter.showAll();
        propertiesToHide.entrySet().stream().forEach(stringListEntry -> ((List)stringListEntry.getValue()).forEach(propertyParts -> this.listGroupItemPresenter.hideProperty((String)stringListEntry.getKey(), (List<String>)propertyParts)));
    }

    @Override
    public void onShowClearButton() {
        ((TestToolsView)this.view).showClearButton();
    }

    @Override
    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    @Override
    public void onSearchedEvent(String search) {
        this.clearLists();
        this.dataObjectFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addDataObjectListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addSimpleJavaTypeListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.instanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> ((String)entry.getKey()).toLowerCase().contains(search.toLowerCase())).forEach(filteredEntry -> this.addSimpleJavaInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.updateSeparators();
    }

    @Override
    public void onPerfectMatchSearchedEvent(String search, boolean notEqualsSearch) {
        this.clearLists();
        this.dataObjectFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addDataObjectListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.simpleJavaTypeFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addSimpleJavaTypeListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.instanceFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.simpleJavaInstanceFieldsMap.entrySet().stream().filter(entry -> this.filterTerm((String)entry.getKey(), search, notEqualsSearch)).forEach(filteredEntry -> this.addSimpleJavaInstanceListGroupItemView((String)filteredEntry.getKey(), (FactModelTree)filteredEntry.getValue()));
        this.updateSeparators();
    }

    @Override
    public void addDataObjectListGroupItemView(String factName, FactModelTree factModelTree) {
        DivElement toAdd = this.listGroupItemPresenter.getDivElement(factName, factModelTree);
        ((TestToolsView)this.view).getDataObjectListContainer().appendChild((Node)toAdd);
    }

    @Override
    public void addSimpleJavaTypeListGroupItemView(String factName, FactModelTree factModelTree) {
        DivElement toAdd = this.listGroupItemPresenter.getDivElement(factName, factModelTree);
        ((TestToolsView)this.view).getSimpleJavaTypeListContainer().appendChild((Node)toAdd);
    }

    @Override
    public void addInstanceListGroupItemView(String instanceName, FactModelTree factModelTree) {
        DivElement toAdd = this.listGroupItemPresenter.getDivElement(instanceName, factModelTree);
        ((TestToolsView)this.view).getInstanceListContainer().appendChild((Node)toAdd);
    }

    @Override
    public void addSimpleJavaInstanceListGroupItemView(String instanceName, FactModelTree factModelTree) {
        DivElement toAdd = this.listGroupItemPresenter.getDivElement(instanceName, factModelTree);
        ((TestToolsView)this.view).getSimpleJavaInstanceListContainer().appendChild((Node)toAdd);
    }

    @Override
    public void onEnableEditorTab() {
        this.onDisableEditorTab();
        this.listGroupItemPresenter.enable();
        this.editingColumnEnabled = true;
        ((TestToolsView)this.view).enableEditorTab();
    }

    @Override
    public void onEnableEditorTab(String factName, List<String> propertyNameElements, boolean notEqualsSearch) {
        this.onDisableEditorTab();
        this.onPerfectMatchSearchedEvent(factName, notEqualsSearch);
        this.listGroupItemPresenter.enable(factName);
        this.editingColumnEnabled = true;
        ((TestToolsView)this.view).enableEditorTab();
        if (propertyNameElements != null && !notEqualsSearch) {
            this.listGroupItemPresenter.selectProperty(factName, propertyNameElements);
        }
    }

    @Override
    public void onDisableEditorTab() {
        this.onSearchedEvent("");
        this.listGroupItemPresenter.disable();
        this.editingColumnEnabled = false;
        ((TestToolsView)this.view).disableEditorTab();
        this.selectedFieldItemView = null;
        this.selectedListGroupItemView = null;
    }

    @Override
    public void setSelectedElement(ListGroupItemView selected) {
        this.selectedListGroupItemView = selected;
        this.selectedFieldItemView = null;
        ((TestToolsView)this.view).enableAddButton();
    }

    @Override
    public void setSelectedElement(FieldItemView selected) {
        this.selectedFieldItemView = selected;
        this.selectedListGroupItemView = null;
        ((TestToolsView)this.view).enableAddButton();
    }

    @Override
    public void onModifyColumn() {
        if (this.editingColumnEnabled) {
            if (this.selectedListGroupItemView != null) {
                String className = this.selectedListGroupItemView.getActualClassName();
                this.getFullPackage(className).ifPresent(fullPackage -> this.eventBus.fireEvent((GwtEvent)new SetInstanceHeaderEvent((String)fullPackage, className)));
            } else if (this.selectedFieldItemView != null) {
                String baseClass = this.selectedFieldItemView.getFullPath().split("\\.")[0];
                String value = this.isSimple(baseClass) ? this.selectedFieldItemView.getFullPath() : this.selectedFieldItemView.getFullPath() + "." + this.selectedFieldItemView.getFieldName();
                List<String> propertyNameElements = Collections.unmodifiableList(Arrays.asList(value.split("\\.")));
                this.getFullPackage(baseClass).ifPresent(fullPackage -> this.eventBus.fireEvent((GwtEvent)new SetPropertyHeaderEvent((String)fullPackage, propertyNameElements, this.selectedFieldItemView.getClassName())));
            }
        }
    }

    protected Optional<String> getFullPackage(String className) {
        return this.getFactModelTreeFromMaps(className).map(FactModelTree::getFullPackage);
    }

    protected Optional<FactModelTree> getFactModelTreeFromMaps(String key) {
        return Optional.ofNullable(this.getFactModelTreeFromFactTypeMap(key).orElseGet(() -> this.getFactModelTreeFromSimpleJavaTypeMap(key).orElseGet(() -> this.getFactModelTreeFromInstanceMap(key).orElseGet(() -> this.getFactModelTreeFromSimpleJavaInstanceMap(key).orElse(null)))));
    }

    protected boolean isSimple(String key) {
        return Optional.ofNullable(this.getFactModelTreeFromSimpleJavaTypeMap(key)).orElseGet(() -> this.getFactModelTreeFromSimpleJavaInstanceMap(key)).isPresent();
    }

    protected void clearLists() {
        this.clearDataObjectList();
        this.clearSimpleJavaTypeList();
        this.clearInstanceList();
        this.clearSimpleJavaInstanceFieldList();
    }

    protected void updateSeparators() {
        this.updateDataObjectListSeparator();
        this.updateSimpleJavaTypeListSeparator();
        this.updateInstanceListSeparator();
        this.updateSimpleJavaInstanceFieldListSeparator();
    }

    protected boolean filterTerm(String key, String search, boolean notEqualsSearch) {
        List<String> terms = Arrays.asList(search.split(";"));
        if (notEqualsSearch) {
            return !terms.contains(key);
        }
        return terms.contains(key);
    }
}

