/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.DataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioCellTextAreaSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.factories.ScenarioHeaderTextBoxSingletonDOMElementFactory;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationBuilders;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.drools.workbench.screens.scenariosimulation.model.ExpressionIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactIdentifier;
import org.drools.workbench.screens.scenariosimulation.model.FactMappingType;

public class ScenarioSimulationUtils {
    protected static AtomicInteger subGroupCounter = new AtomicInteger(0);

    public static String getPropertyMetaDataGroup(String columnGroup) {
        return columnGroup + "-" + subGroupCounter.getAndIncrement();
    }

    public static boolean isSimpleJavaType(String className) {
        return DataManagementStrategy.SIMPLE_CLASSES_MAP.values().stream().map(Class::getCanonicalName).anyMatch(className::equals);
    }

    public static List<String> getPropertyNameElementsWithoutAlias(List<String> propertyNameElements, FactIdentifier factIdentifier) {
        String actualClassName = factIdentifier.getClassName();
        if (actualClassName.contains(".")) {
            actualClassName = actualClassName.substring(actualClassName.lastIndexOf(".") + 1);
        }
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.addAll(propertyNameElements);
        if (toReturn.size() > 1) {
            toReturn.set(0, actualClassName);
        }
        return toReturn;
    }

    public static ScenarioGridColumn getScenarioGridColumn(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell) {
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = ScenarioSimulationUtils.getHeaderBuilder(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, factoryHeader);
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, factoryCell);
    }

    public static ScenarioGridColumn getScenarioGridColumn(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = ScenarioSimulationUtils.getHeaderBuilder(instanceTitle, propertyTitle, columnId, columnGroup, factMappingType, factoryHeader);
        return ScenarioSimulationUtils.getScenarioGridColumn(headerBuilder, factoryCell, placeHolder);
    }

    public static ScenarioGridColumn getScenarioGridColumn(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell) {
        ScenarioSimulationBuilders.ScenarioGridColumnBuilder scenarioGridColumnBuilder = ScenarioSimulationUtils.getScenarioGridColumnBuilder(factoryCell, headerBuilder, ScenarioSimulationEditorConstants.INSTANCE.insertValue());
        return scenarioGridColumnBuilder.build();
    }

    public static ScenarioGridColumn getScenarioGridColumn(ScenarioSimulationBuilders.HeaderBuilder headerBuilder, ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, String placeHolder) {
        ScenarioSimulationBuilders.ScenarioGridColumnBuilder scenarioGridColumnBuilder = ScenarioSimulationUtils.getScenarioGridColumnBuilder(factoryCell, headerBuilder, placeHolder);
        return scenarioGridColumnBuilder.build();
    }

    public static ScenarioSimulationBuilders.ScenarioGridColumnBuilder getScenarioGridColumnBuilder(ScenarioCellTextAreaSingletonDOMElementFactory factoryCell, ScenarioSimulationBuilders.HeaderBuilder headerBuilder, String placeHolder) {
        ScenarioSimulationBuilders.ScenarioGridColumnBuilder toReturn = ScenarioSimulationBuilders.ScenarioGridColumnBuilder.get(factoryCell, headerBuilder);
        toReturn.setPlaceHolder(placeHolder);
        toReturn.setWidth(ScenarioSimulationUtils.getColumnWidth(headerBuilder.getColumnId()));
        return toReturn;
    }

    public static ScenarioSimulationBuilders.HeaderBuilder getHeaderBuilder(String instanceTitle, String propertyTitle, String columnId, String columnGroup, FactMappingType factMappingType, ScenarioHeaderTextBoxSingletonDOMElementFactory factoryHeader) {
        ScenarioSimulationBuilders.HeaderBuilder headerBuilder = ScenarioSimulationBuilders.HeaderBuilder.get(factoryHeader);
        headerBuilder.setColumnId(columnId);
        headerBuilder.setColumnTitle(columnGroup);
        headerBuilder.setReadOnly(true);
        if (ScenarioSimulationUtils.isOther(factMappingType)) {
            headerBuilder.setColumnTitle(instanceTitle);
            headerBuilder.setColumnGroup(columnGroup);
            headerBuilder.setInstanceHeader(true);
            return headerBuilder;
        }
        ScenarioSimulationBuilders.HeaderBuilder instanceHeader = headerBuilder.newLevel().setColumnTitle(instanceTitle).setColumnGroup(columnGroup).setReadOnly(false).setInstanceHeader(true).setPropertyHeader(false);
        instanceHeader.newLevel().setColumnTitle(propertyTitle).setColumnGroup(ScenarioSimulationUtils.getPropertyMetaDataGroup(columnGroup)).setReadOnly(false).setInstanceHeader(false).setPropertyHeader(true);
        return headerBuilder;
    }

    protected static double getColumnWidth(String columnId) {
        ExpressionIdentifier.NAME expressionName = ExpressionIdentifier.NAME.Other;
        try {
            expressionName = ExpressionIdentifier.NAME.valueOf((String)columnId);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (expressionName) {
            case Index: {
                return 70.0;
            }
            case Description: {
                return 300.0;
            }
        }
        return 114.0;
    }

    private static boolean isOther(FactMappingType factMappingType) {
        return FactMappingType.OTHER.equals((Object)factMappingType);
    }
}

