/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import com.google.gwt.dom.client.InputElement;
import com.google.gwt.dom.client.SpanElement;
import com.google.gwt.dom.client.Style;
import com.google.gwtmockito.GwtMockitoTestRunner;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.SimulationDescriptor;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSettingsTest;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.SettingsView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=GwtMockitoTestRunner.class)
public class SettingsPresenterTest
extends AbstractSettingsTest {
    private SettingsPresenter settingsPresenter;
    @Mock
    private SettingsView settingsViewMock;
    @Mock
    private SimulationDescriptor simulationDescriptorMock;
    @Mock
    private Command saveCommandMock;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.settingsViewMock.getNameLabel()).thenReturn((Object)this.nameLabelMock);
        Mockito.when((Object)this.settingsViewMock.getFileName()).thenReturn((Object)this.fileNameMock);
        Mockito.when((Object)this.settingsViewMock.getTypeLabel()).thenReturn((Object)this.typeLabelMock);
        Mockito.when((Object)this.settingsViewMock.getScenarioType()).thenReturn((Object)this.scenarioTypeMock);
        Mockito.when((Object)this.settingsViewMock.getRuleSettings()).thenReturn((Object)this.ruleSettingsMock);
        Mockito.when((Object)this.settingsViewMock.getKieSession()).thenReturn((Object)this.kieSessionMock);
        Mockito.when((Object)this.settingsViewMock.getKieBase()).thenReturn((Object)this.kieBaseMock);
        Mockito.when((Object)this.settingsViewMock.getRuleFlowGroup()).thenReturn((Object)this.ruleFlowGroupMock);
        Mockito.when((Object)this.settingsViewMock.getDmoSession()).thenReturn((Object)this.dmoSessionMock);
        Mockito.when((Object)this.settingsViewMock.getDmnSettings()).thenReturn((Object)this.dmnSettingsMock);
        Mockito.when((Object)this.settingsViewMock.getDmnFileLabel()).thenReturn((Object)this.dmnModelLabelMock);
        Mockito.when((Object)this.settingsViewMock.getDmnFilePath()).thenReturn((Object)this.dmnFilePathMock);
        Mockito.when((Object)this.settingsViewMock.getDmnNamespaceLabel()).thenReturn((Object)this.dmnNamespaceLabelMock);
        Mockito.when((Object)this.settingsViewMock.getDmnNamespace()).thenReturn((Object)this.dmnNamespaceMock);
        Mockito.when((Object)this.settingsViewMock.getDmnNameLabel()).thenReturn((Object)this.dmnNameLabelMock);
        Mockito.when((Object)this.settingsViewMock.getDmnName()).thenReturn((Object)this.dmnNameMock);
        Mockito.when((Object)this.settingsViewMock.getSkipFromBuild()).thenReturn((Object)this.skipFromBuildMock);
        Mockito.when((Object)this.settingsViewMock.getSaveButton()).thenReturn((Object)this.saveButtonMock);
        Mockito.when((Object)this.simulationDescriptorMock.getFileName()).thenReturn((Object)"FILE_NAME");
        Mockito.when((Object)this.simulationDescriptorMock.getKieSession()).thenReturn((Object)"KIE_SESSION");
        Mockito.when((Object)this.simulationDescriptorMock.getKieBase()).thenReturn((Object)"KIE_BASE");
        Mockito.when((Object)this.simulationDescriptorMock.getRuleFlowGroup()).thenReturn((Object)"RULE_FLOW_GROUP");
        Mockito.when((Object)this.simulationDescriptorMock.getDmoSession()).thenReturn((Object)"DMO_SESSION");
        Mockito.when((Object)this.simulationDescriptorMock.getDmnFilePath()).thenReturn((Object)"DMN_FILE_PATH");
        Mockito.when((Object)this.simulationDescriptorMock.getDmnNamespace()).thenReturn((Object)"DMN_NAMESPACE");
        Mockito.when((Object)this.simulationDescriptorMock.getDmnName()).thenReturn((Object)"DMN_NAME");
        this.settingsPresenter = (SettingsPresenter)Mockito.spy((Object)new SettingsPresenter(this.settingsViewMock){
            {
                this.simulationDescriptor = SettingsPresenterTest.this.simulationDescriptorMock;
                this.saveCommand = SettingsPresenterTest.this.saveCommandMock;
            }
        });
    }

    @Test
    public void onSetup() {
        this.settingsPresenter.setup();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).init((Object)this.settingsPresenter);
    }

    @Test
    public void getTitle() {
        Assert.assertEquals((Object)ScenarioSimulationEditorConstants.INSTANCE.settings(), (Object)this.settingsPresenter.getTitle());
    }

    @Test
    public void onSaveButtonSkipTrue() {
        Mockito.when((Object)this.skipFromBuildMock.isChecked()).thenReturn((Object)true);
        this.settingsPresenter.onSaveButton(ScenarioSimulationModel.Type.RULE.name());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)true));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setFileName((String)Matchers.eq((Object)"FILE_NAME"));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).saveRuleSettings();
        ((Command)Mockito.verify((Object)this.saveCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.reset((Object[])new Command[]{this.saveCommandMock});
        Mockito.reset((Object[])new SimulationDescriptor[]{this.simulationDescriptorMock});
        this.settingsPresenter.onSaveButton(ScenarioSimulationModel.Type.DMN.name());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).saveDMNSettings();
        ((Command)Mockito.verify((Object)this.saveCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void onSaveButtonSkipFalse() {
        Mockito.when((Object)this.skipFromBuildMock.isChecked()).thenReturn((Object)false);
        this.settingsPresenter.onSaveButton(ScenarioSimulationModel.Type.RULE.name());
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).saveRuleSettings();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setFileName((String)Matchers.eq((Object)"FILE_NAME"));
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)false));
        ((Command)Mockito.verify((Object)this.saveCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
        Mockito.reset((Object[])new Command[]{this.saveCommandMock});
        Mockito.reset((Object[])new SimulationDescriptor[]{this.simulationDescriptorMock});
        this.settingsPresenter.onSaveButton(ScenarioSimulationModel.Type.DMN.name());
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setSkipFromBuild(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).saveDMNSettings();
        ((Command)Mockito.verify((Object)this.saveCommandMock, (VerificationMode)Mockito.times((int)1))).execute();
    }

    @Test
    public void setScenarioTypeRULESkipTrue() {
        Mockito.when((Object)this.simulationDescriptorMock.isSkipFromBuild()).thenReturn((Object)true);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.RULE, this.simulationDescriptorMock, "FILE_NAME");
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioType();
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE.name()));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((SpanElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setRuleSettings(this.simulationDescriptorMock);
    }

    @Test
    public void setScenarioTypeRULESkipFalse() {
        Mockito.when((Object)this.simulationDescriptorMock.isSkipFromBuild()).thenReturn((Object)false);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.RULE, this.simulationDescriptorMock, "FILE_NAME");
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioType();
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.RULE.name()));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((SpanElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setRuleSettings(this.simulationDescriptorMock);
    }

    @Test
    public void setScenarioTypeDMNSkipTrue() {
        Mockito.when((Object)this.simulationDescriptorMock.isSkipFromBuild()).thenReturn((Object)true);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.DMN, this.simulationDescriptorMock, "FILE_NAME");
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioType();
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN.name()));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((SpanElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)true));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setDMNSettings(this.simulationDescriptorMock);
    }

    @Test
    public void setScenarioTypeDMNSkipFalse() {
        Mockito.when((Object)this.simulationDescriptorMock.isSkipFromBuild()).thenReturn((Object)false);
        this.settingsPresenter.setScenarioType(ScenarioSimulationModel.Type.DMN, this.simulationDescriptorMock, "FILE_NAME");
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getScenarioType();
        ((SpanElement)Mockito.verify((Object)this.scenarioTypeMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)ScenarioSimulationModel.Type.DMN.name()));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getFileName();
        ((SpanElement)Mockito.verify((Object)this.fileNameMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)"FILE_NAME"));
        ((InputElement)Mockito.verify((Object)this.skipFromBuildMock, (VerificationMode)Mockito.times((int)1))).setChecked(Matchers.eq((boolean)false));
        ((SettingsPresenter)Mockito.verify((Object)this.settingsPresenter, (VerificationMode)Mockito.times((int)1))).setDMNSettings(this.simulationDescriptorMock);
    }

    @Test
    public void setRuleSettings() {
        this.settingsPresenter.setRuleSettings(this.simulationDescriptorMock);
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnSettings();
        ((Style)Mockito.verify((Object)this.dmnSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getRuleSettings();
        ((Style)Mockito.verify((Object)this.ruleSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmoSession();
        ((InputElement)Mockito.verify((Object)this.dmoSessionMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"DMO_SESSION"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getKieBase();
        ((InputElement)Mockito.verify((Object)this.kieBaseMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"KIE_BASE"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getKieSession();
        ((InputElement)Mockito.verify((Object)this.kieSessionMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"KIE_SESSION"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getRuleFlowGroup();
        ((InputElement)Mockito.verify((Object)this.ruleFlowGroupMock, (VerificationMode)Mockito.times((int)1))).setValue((String)Matchers.eq((Object)"RULE_FLOW_GROUP"));
    }

    @Test
    public void setDMNSettings() {
        this.settingsPresenter.setDMNSettings(this.simulationDescriptorMock);
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getRuleSettings();
        ((Style)Mockito.verify((Object)this.ruleSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.NONE));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnSettings();
        ((Style)Mockito.verify((Object)this.dmnSettingsStyleMock, (VerificationMode)Mockito.times((int)1))).setDisplay((Style.Display)Matchers.eq((Object)Style.Display.INLINE));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnFilePath();
        ((SpanElement)Mockito.verify((Object)this.dmnFilePathMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)"DMN_FILE_PATH"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnName();
        ((SpanElement)Mockito.verify((Object)this.dmnNameMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)"DMN_NAME"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnNamespace();
        ((SpanElement)Mockito.verify((Object)this.dmnNamespaceMock, (VerificationMode)Mockito.times((int)1))).setInnerText((String)Matchers.eq((Object)"DMN_NAMESPACE"));
    }

    @Test
    public void saveRuleSettings() {
        Mockito.when((Object)this.skipFromBuildMock.isChecked()).thenReturn((Object)true);
        this.settingsPresenter.saveRuleSettings();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmoSession();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setDmoSession((String)Matchers.eq((Object)"DMO_SESSION"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getKieBase();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setKieBase((String)Matchers.eq((Object)"KIE_BASE"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getKieSession();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setKieSession((String)Matchers.eq((Object)"KIE_SESSION"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getRuleFlowGroup();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setRuleFlowGroup((String)Matchers.eq((Object)"RULE_FLOW_GROUP"));
    }

    @Test
    public void saveDMNSettings() {
        this.settingsPresenter.saveDMNSettings();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnFilePath();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setDmnFilePath((String)Matchers.eq((Object)"DMN_FILE_PATH"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnName();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setDmnName((String)Matchers.eq((Object)"DMN_NAME"));
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).getDmnNamespace();
        ((SimulationDescriptor)Mockito.verify((Object)this.simulationDescriptorMock, (VerificationMode)Mockito.times((int)1))).setDmnNamespace((String)Matchers.eq((Object)"DMN_NAMESPACE"));
    }

    @Test
    public void resetTest() {
        this.settingsPresenter.reset();
        ((SettingsView)Mockito.verify((Object)this.settingsViewMock, (VerificationMode)Mockito.times((int)1))).reset();
    }
}

