/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import org.drools.scenariosimulation.api.model.ExpressionElement;
import org.drools.scenariosimulation.api.model.FactMapping;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.commands.actualcommands.AbstractSelectedColumnCommand;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;

@Dependent
public class DuplicateInstanceCommand
extends AbstractSelectedColumnCommand {
    public static final String COPY_LABEL = "_copy_";

    @Override
    protected void executeIfSelectedColumn(ScenarioSimulationContext context, ScenarioGridColumn selectedColumn) {
        int instancesCount = context.getModel().getInstancesCount(selectedColumn.getFactIdentifier().getClassName());
        String alias = selectedColumn.getInformationHeaderMetaData().getTitle().split(COPY_LABEL)[0] + COPY_LABEL + instancesCount;
        int columnPosition = context.getModel().getInstanceLimits(context.getModel().getColumns().indexOf((Object)selectedColumn)).getMaxRowIndex() + 1;
        AtomicInteger nextColumnPosition = new AtomicInteger(columnPosition);
        context.getModel().getInstanceScenarioGridColumns(selectedColumn).forEach(originalColumn -> {
            ScenarioGridColumn createdColumn = this.insertNewColumn(context, (ScenarioGridColumn)((Object)originalColumn), nextColumnPosition.getAndIncrement(), false);
            if (originalColumn.isInstanceAssigned()) {
                this.setInstanceHeader(context, createdColumn, alias, originalColumn.getFactIdentifier().getClassName());
                if (originalColumn.isPropertyAssigned()) {
                    int originalColumnIndex = context.getModel().getColumns().indexOf(originalColumn);
                    int createdColumnIndex = context.getModel().getColumns().indexOf((Object)createdColumn);
                    FactMapping originalFactMapping = context.getModel().getSimulation().get().getSimulationDescriptor().getFactMappingByIndex(originalColumnIndex);
                    ArrayList<String> propertyNameElements = new ArrayList<String>();
                    propertyNameElements.add(alias);
                    propertyNameElements.addAll(originalFactMapping.getExpressionElementsWithoutClass().stream().map(ExpressionElement::getStep).collect(Collectors.toList()));
                    this.setPropertyHeader(context, createdColumn, propertyNameElements, originalFactMapping.getClassName(), Optional.of(originalColumn.getPropertyHeaderMetaData().getTitle()));
                    context.getModel().duplicateColumnValues(originalColumnIndex, createdColumnIndex);
                }
            }
        });
    }
}

