/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.ContextMenuEvent;
import com.google.gwt.event.dom.client.ContextMenuHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.Dependent;
import org.drools.workbench.screens.scenariosimulation.client.events.DisableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.EnableTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.events.ReloadTestToolsEvent;
import org.drools.workbench.screens.scenariosimulation.client.handlers.AbstractScenarioSimulationGridPanelHandler;
import org.drools.workbench.screens.scenariosimulation.client.menu.ScenarioContextMenuRegistry;
import org.drools.workbench.screens.scenariosimulation.client.metadata.ScenarioHeaderMetaData;
import org.drools.workbench.screens.scenariosimulation.client.utils.ScenarioSimulationGridHeaderUtilities;
import org.drools.workbench.screens.scenariosimulation.client.widgets.ScenarioGridColumn;
import org.uberfire.ext.wires.core.grids.client.model.GridCell;
import org.uberfire.ext.wires.core.grids.client.util.CoordinateUtilities;

@Dependent
public class ScenarioSimulationGridPanelClickHandler
extends AbstractScenarioSimulationGridPanelHandler
implements ClickHandler,
ContextMenuHandler {
    protected ScenarioContextMenuRegistry scenarioContextMenuRegistry;
    protected EventBus eventBus;
    protected AtomicInteger clickReceived = new AtomicInteger(0);

    public void setScenarioContextMenuRegistry(ScenarioContextMenuRegistry scenarioContextMenuRegistry) {
        this.scenarioContextMenuRegistry = scenarioContextMenuRegistry;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void onClick(ClickEvent event) {
        this.clickReceived.getAndIncrement();
        int canvasX = CoordinateUtilities.getRelativeXOfEvent((DomEvent)event);
        int canvasY = CoordinateUtilities.getRelativeYOfEvent((DomEvent)event);
        this.scenarioContextMenuRegistry.hideMenus();
        this.scenarioContextMenuRegistry.hideErrorReportPopover();
        this.scenarioGrid.clearSelections();
        if (!this.manageCoordinates(canvasX, canvasY)) {
            this.eventBus.fireEvent((GwtEvent)new DisableTestToolsEvent());
        }
    }

    public void onContextMenu(ContextMenuEvent event) {
        this.scenarioContextMenuRegistry.hideMenus();
        if (this.scenarioContextMenuRegistry.manageRightClick(this.scenarioGrid, event)) {
            this.scenarioContextMenuRegistry.hideErrorReportPopover();
            event.preventDefault();
            event.stopPropagation();
        }
    }

    public void hideMenus() {
        this.scenarioContextMenuRegistry.hideMenus();
    }

    @Override
    protected boolean manageGivenExpectHeaderCoordinates(ScenarioHeaderMetaData clickedScenarioHeaderMetadata, ScenarioGridColumn scenarioGridColumn, String group, Integer uiColumnIndex) {
        this.scenarioGrid.setSelectedColumnAndHeader(scenarioGridColumn.getHeaderMetaData().indexOf((Object)clickedScenarioHeaderMetadata), uiColumnIndex);
        if (scenarioGridColumn.isInstanceAssigned() && clickedScenarioHeaderMetadata.getMetadataType().equals((Object)ScenarioHeaderMetaData.MetadataType.INSTANCE)) {
            this.eventBus.fireEvent((GwtEvent)new ReloadTestToolsEvent(true, true));
            return true;
        }
        EnableTestToolsEvent toFire = ScenarioSimulationGridHeaderUtilities.getEnableTestToolsEvent(this.scenarioGrid, scenarioGridColumn, clickedScenarioHeaderMetadata, uiColumnIndex, group);
        this.eventBus.fireEvent((GwtEvent)toFire);
        return true;
    }

    @Override
    protected boolean manageBodyCoordinates(Integer uiRowIndex, Integer uiColumnIndex) {
        GridCell cell = this.scenarioGrid.getModel().getCell(uiRowIndex, uiColumnIndex);
        if (cell == null) {
            return false;
        }
        this.scenarioGrid.getModel().selectCell(uiRowIndex, uiColumnIndex);
        return true;
    }
}

