/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.ScenarioSimulationModel;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.scenariosimulation.api.model.SimulationRunMetadata;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.AbstractSubDockPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageDecisionElementPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportDonutPresenter;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageReportView;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageScenarioListPresenter;
import org.uberfire.client.annotations.WorkbenchScreen;

@ApplicationScoped
@WorkbenchScreen(identifier="org.drools.scenariosimulation.CoverageReport", preferredWidth=300)
public class CoverageReportPresenter
extends AbstractSubDockPresenter<CoverageReportView>
implements CoverageReportView.Presenter {
    public static final int DEFAULT_PREFERRED_WIDHT = 300;
    public static final String IDENTIFIER = "org.drools.scenariosimulation.CoverageReport";
    protected CoverageReportDonutPresenter coverageReportDonutPresenter;
    protected CoverageDecisionElementPresenter coverageDecisionElementPresenter;
    protected CoverageScenarioListPresenter coverageScenarioListPresenter;

    public CoverageReportPresenter() {
        this.title = ScenarioSimulationEditorConstants.INSTANCE.coverageReport();
    }

    @Inject
    public CoverageReportPresenter(CoverageReportView view, CoverageReportDonutPresenter coverageReportDonutPresenter, CoverageDecisionElementPresenter coverageDecisionElementPresenter, CoverageScenarioListPresenter coverageScenarioListPresenter) {
        super(view);
        this.title = ScenarioSimulationEditorConstants.INSTANCE.coverageReport();
        this.coverageReportDonutPresenter = coverageReportDonutPresenter;
        this.coverageDecisionElementPresenter = coverageDecisionElementPresenter;
        this.coverageScenarioListPresenter = coverageScenarioListPresenter;
    }

    @PostConstruct
    public void init() {
        this.coverageReportDonutPresenter.init(((CoverageReportView)this.view).getDonutChart());
        this.coverageDecisionElementPresenter.initDecisionList(((CoverageReportView)this.view).getDecisionList());
        this.coverageScenarioListPresenter.initScenarioList(((CoverageReportView)this.view).getScenarioList());
    }

    @Override
    public void setSimulationRunMetadata(SimulationRunMetadata simulationRunMetadata, ScenarioSimulationModel.Type type) {
        if (ScenarioSimulationModel.Type.DMN.equals((Object)type)) {
            this.populateSummary(simulationRunMetadata.getAvailable(), simulationRunMetadata.getExecuted(), simulationRunMetadata.getCoveragePercentage());
            this.populateDecisionList(simulationRunMetadata.getOutputCounter());
            this.populateScenarioList(simulationRunMetadata.getScenarioCounter());
            ((CoverageReportView)this.view).show();
        }
    }

    @Override
    public void reset() {
        ((CoverageReportView)this.view).reset();
    }

    @Override
    public void showEmptyStateMessage(ScenarioSimulationModel.Type type) {
        if (ScenarioSimulationModel.Type.RULE.equals((Object)type)) {
            ((CoverageReportView)this.view).setEmptyStatusText(ScenarioSimulationEditorConstants.INSTANCE.coverageNotSupportedForRule());
        } else {
            ((CoverageReportView)this.view).setEmptyStatusText(ScenarioSimulationEditorConstants.INSTANCE.runATestToSeeCoverageReport());
        }
        ((CoverageReportView)this.view).hide();
    }

    protected void populateSummary(int available, int executed, double coveragePercentage) {
        ((CoverageReportView)this.view).setReportAvailable(available + "");
        ((CoverageReportView)this.view).setReportExecuted(executed + "");
        ((CoverageReportView)this.view).setReportCoverage(coveragePercentage + "%");
        this.coverageReportDonutPresenter.showCoverageReport(executed, available - executed);
    }

    protected void populateDecisionList(Map<String, Integer> outputCounter) {
        this.coverageDecisionElementPresenter.clear();
        ArrayList<String> decisions = new ArrayList<String>(outputCounter.keySet());
        decisions.sort(Comparator.naturalOrder());
        for (String decision : decisions) {
            this.coverageDecisionElementPresenter.addDecisionElementView(decision, outputCounter.get(decision) + "");
        }
    }

    protected void populateScenarioList(Map<ScenarioWithIndex, List<String>> scenarioCounter) {
        this.coverageScenarioListPresenter.clear();
        ArrayList<ScenarioWithIndex> scenarioIndexes = new ArrayList<ScenarioWithIndex>(scenarioCounter.keySet());
        scenarioIndexes.sort(Comparator.comparingInt(ScenarioWithIndex::getIndex));
        for (ScenarioWithIndex scenarioWithIndex : scenarioIndexes) {
            this.coverageScenarioListPresenter.addScenarioGroup(scenarioWithIndex, scenarioCounter.get(scenarioWithIndex));
        }
    }
}

