/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.editor.strategies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.drools.scenariosimulation.api.utils.ScenarioSimulationSharedUtils;
import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.SimpleClassEntry;
import org.drools.workbench.screens.scenariosimulation.client.models.ScenarioGridModel;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.model.ScenarioSimulationModelContent;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTuple;
import org.kie.soup.project.datamodel.imports.HasImports;
import org.kie.soup.project.datamodel.oracle.ModelField;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracle;
import org.kie.workbench.common.widgets.client.datamodel.AsyncPackageDataModelOracleFactory;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.callbacks.Callback;

public class DMODataManagementStrategy
extends AbstractDataManagementStrategy {
    private AsyncPackageDataModelOracleFactory oracleFactory;
    protected AsyncPackageDataModelOracle oracle;
    protected String packageName = "";

    public DMODataManagementStrategy(AsyncPackageDataModelOracleFactory oracleFactory, ScenarioSimulationContext scenarioSimulationContext) {
        this.oracleFactory = oracleFactory;
        this.scenarioSimulationContext = scenarioSimulationContext;
    }

    @Override
    public void populateTestTools(TestToolsView.Presenter testToolsPresenter, ScenarioGridModel scenarioGridModel) {
        if (this.factModelTreeHolder.getFactModelTuple() != null) {
            this.storeData(this.factModelTreeHolder.getFactModelTuple(), testToolsPresenter, scenarioGridModel);
        } else {
            if (this.oracle == null || this.oracle.getFactTypes().length == 0) {
                return;
            }
            List<String> factTypes = Arrays.asList(this.oracle.getFactTypes());
            Map<Boolean, List<String>> partitionedFactTypes = factTypes.stream().collect(Collectors.partitioningBy(factType -> SIMPLE_CLASSES_MAP.keySet().contains(factType)));
            List<String> dataObjectsTypes = partitionedFactTypes.get(false);
            List<String> simpleJavaTypes = partitionedFactTypes.get(true);
            int expectedElements = dataObjectsTypes.size();
            TreeMap<String, FactModelTree> dataObjectsFieldsMap = new TreeMap<String, FactModelTree>();
            if (dataObjectsTypes.isEmpty()) {
                this.aggregatorCallbackMethod(testToolsPresenter, expectedElements, dataObjectsFieldsMap, scenarioGridModel, null, simpleJavaTypes);
            } else {
                Callback<FactModelTree> aggregatorCallback = this.aggregatorCallback(testToolsPresenter, expectedElements, dataObjectsFieldsMap, scenarioGridModel, simpleJavaTypes);
                dataObjectsTypes.forEach(factType -> this.oracle.getFieldCompletions(factType, this.fieldCompletionsCallback((String)factType, aggregatorCallback)));
            }
        }
    }

    @Override
    public void manageScenarioSimulationModelContent(ObservablePath currentPath, ScenarioSimulationModelContent toManage) {
        this.model = toManage.getModel();
        this.oracle = this.oracleFactory.makeAsyncPackageDataModelOracle((Path)currentPath, (HasImports)this.model, toManage.getDataModel());
    }

    @Override
    public boolean isADataType(String value) {
        return this.oracle != null && Arrays.asList(this.oracle.getFactTypes()).contains(value);
    }

    public AsyncPackageDataModelOracle getOracle() {
        return this.oracle;
    }

    protected Callback<ModelField[]> fieldCompletionsCallback(String factName, Callback<FactModelTree> aggregatorCallback) {
        return result -> this.fieldCompletionsCallbackMethod(factName, (ModelField[])result, aggregatorCallback);
    }

    protected void fieldCompletionsCallbackMethod(String factName, ModelField[] result, Callback<FactModelTree> aggregatorCallback) {
        FactModelTree toSend = this.getFactModelTree(factName, result);
        aggregatorCallback.callback((Object)toSend);
    }

    protected FactModelTree getFactModelTree(String factName, ModelField[] modelFields) {
        HashMap<String, String> simpleProperties = new HashMap<String, String>();
        HashMap<String, List<String>> genericTypesMap = new HashMap<String, List<String>>();
        String factPackageName = this.packageName;
        String fullFactClassName = this.oracle.getFQCNByFactName(factName);
        if (fullFactClassName != null && fullFactClassName.contains(".")) {
            factPackageName = fullFactClassName.substring(0, fullFactClassName.lastIndexOf("."));
        }
        for (ModelField modelField : modelFields) {
            if (modelField.getName().equals("this")) continue;
            String className = SIMPLE_CLASSES_MAP.containsKey(modelField.getClassName()) ? ((SimpleClassEntry)SIMPLE_CLASSES_MAP.get(modelField.getClassName())).getCanonicalName() : modelField.getClassName();
            simpleProperties.put(modelField.getName(), className);
            if (!ScenarioSimulationSharedUtils.isCollection((String)className)) continue;
            this.populateGenericTypeMap(genericTypesMap, factName, modelField.getName(), ScenarioSimulationSharedUtils.isList((String)className));
        }
        return new FactModelTree(factName, factPackageName, simpleProperties, genericTypesMap);
    }

    protected void populateGenericTypeMap(Map<String, List<String>> toPopulate, String factName, String propertyName, boolean isList) {
        ArrayList<String> genericTypes = new ArrayList<String>();
        if (!isList) {
            genericTypes.add(String.class.getName());
        }
        String genericInfo = this.oracle.getParametricFieldType(factName, propertyName);
        String fullGenericInfoClassName = this.oracle.getFQCNByFactName(genericInfo);
        genericTypes.add(fullGenericInfoClassName);
        toPopulate.put(propertyName, genericTypes);
    }

    protected Callback<FactModelTree> aggregatorCallback(TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap, ScenarioGridModel scenarioGridModel, List<String> simpleJavaTypes) {
        return result -> this.aggregatorCallbackMethod(testToolsPresenter, expectedElements, factTypeFieldsMap, scenarioGridModel, (FactModelTree)result, simpleJavaTypes);
    }

    protected void aggregatorCallbackMethod(TestToolsView.Presenter testToolsPresenter, int expectedElements, SortedMap<String, FactModelTree> factTypeFieldsMap, ScenarioGridModel scenarioGridModel, FactModelTree result, List<String> simpleJavaTypes) {
        if (result != null) {
            factTypeFieldsMap.put(result.getFactName(), result);
        }
        if (factTypeFieldsMap.size() == expectedElements) {
            factTypeFieldsMap.values().forEach(factModelTree -> this.populateFactModelTree((FactModelTree)factModelTree, factTypeFieldsMap));
            TreeMap<String, FactModelTree> simpleJavaTypeFieldsMap = new TreeMap<String, FactModelTree>(simpleJavaTypes.stream().collect(Collectors.toMap(factType -> factType, factType -> {
                SimpleClassEntry classEntry = (SimpleClassEntry)SIMPLE_CLASSES_MAP.get(factType);
                return DMODataManagementStrategy.getSimpleClassFactModelTree(classEntry.getSimpleName(), classEntry.getCanonicalName());
            })));
            TreeMap<String, FactModelTree> visibleFacts = new TreeMap<String, FactModelTree>(factTypeFieldsMap);
            visibleFacts.putAll(simpleJavaTypeFieldsMap);
            FactModelTuple factModelTuple = new FactModelTuple(visibleFacts, new TreeMap());
            this.factModelTreeHolder.setFactModelTuple(factModelTuple);
            this.storeData(factModelTuple, testToolsPresenter, scenarioGridModel);
        }
    }

    protected void populateFactModelTree(FactModelTree toPopulate, SortedMap<String, FactModelTree> factTypeFieldsMap) {
        ArrayList toRemove = new ArrayList();
        toPopulate.getSimpleProperties().forEach((key, value) -> {
            if (factTypeFieldsMap.containsKey(value)) {
                toRemove.add(key);
                toPopulate.addExpandableProperty(key, ((FactModelTree)factTypeFieldsMap.get(value)).getFactName());
            }
        });
        toRemove.forEach(arg_0 -> ((FactModelTree)toPopulate).removeSimpleProperty(arg_0));
    }
}

