/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.kie.workbench.common.widgets.client.docks.AbstractWorkbenchDocksHandler;
import org.kie.workbench.common.widgets.client.docks.DockPlaceHolderPlace;
import org.kie.workbench.common.workbench.client.docks.AuthoringWorkbenchDocks;
import org.kie.workbench.common.workbench.client.resources.i18n.DefaultWorkbenchConstants;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDockPosition;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;

@ApplicationScoped
public class ScenarioSimulationDocksHandler
extends AbstractWorkbenchDocksHandler {
    public static final String SCESIMEDITOR_ID = "scesimeditorid";
    public static final String TEST_RUNNER_REPORTING_PANEL = "testRunnerReportingPanel";
    @Inject
    private AuthoringWorkbenchDocks authoringWorkbenchDocks;
    private UberfireDock settingsDock;
    private UberfireDock toolsDock;
    private UberfireDock cheatSheetDock;
    private UberfireDock reportDock;
    private UberfireDock coverageDock;

    public Collection<UberfireDock> provideDocks(String perspectiveIdentifier) {
        ArrayList<UberfireDock> result = new ArrayList<UberfireDock>();
        this.settingsDock = new UberfireDock(UberfireDockPosition.EAST, "SLIDERS", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.Settings"), perspectiveIdentifier);
        result.add(this.settingsDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.settings()));
        this.toolsDock = new UberfireDock(UberfireDockPosition.EAST, "INFO_CIRCLE", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.TestTools"), perspectiveIdentifier);
        result.add(this.toolsDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.testTools()));
        this.cheatSheetDock = new UberfireDock(UberfireDockPosition.EAST, "FILE_TEXT", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.CheatSheet"), perspectiveIdentifier);
        result.add(this.cheatSheetDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.scenarioCheatSheet()));
        this.reportDock = new UberfireDock(UberfireDockPosition.EAST, "PLAY_CIRCLE", (PlaceRequest)new DockPlaceHolderPlace(TEST_RUNNER_REPORTING_PANEL), perspectiveIdentifier);
        result.add(this.reportDock.withSize(450.0).withLabel(DefaultWorkbenchConstants.INSTANCE.TestReport()));
        this.coverageDock = new UberfireDock(UberfireDockPosition.EAST, "BAR_CHART", (PlaceRequest)new DefaultPlaceRequest("org.drools.scenariosimulation.CoverageReport"), perspectiveIdentifier);
        result.add(this.coverageDock.withSize(450.0).withLabel(ScenarioSimulationEditorConstants.INSTANCE.coverageReport()));
        return result;
    }

    public void addDocks() {
        this.refreshDocks(true, false);
    }

    public void removeDocks() {
        this.refreshDocks(true, true);
    }

    public void expandToolsDock() {
        this.authoringWorkbenchDocks.expandAuthoringDock(this.toolsDock);
    }

    public void expandTestResultsDock() {
        this.authoringWorkbenchDocks.expandAuthoringDock(this.reportDock);
    }

    public void setScesimEditorId(String scesimEditorId) {
        this.settingsDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
        this.toolsDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
        this.cheatSheetDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
        this.coverageDock.getPlaceRequest().addParameter(SCESIMEDITOR_ID, scesimEditorId);
    }

    public Optional<UberfireDock> getSettingsDock(PlaceRequest placeRequest) {
        return Objects.equals(this.settingsDock.getPlaceRequest(), placeRequest) ? Optional.of(this.settingsDock) : Optional.empty();
    }

    public Optional<UberfireDock> getToolsDock(PlaceRequest placeRequest) {
        return Objects.equals(this.toolsDock.getPlaceRequest(), placeRequest) ? Optional.of(this.toolsDock) : Optional.empty();
    }

    public Optional<UberfireDock> getCheatSheetDock(PlaceRequest placeRequest) {
        return Objects.equals(this.cheatSheetDock.getPlaceRequest(), placeRequest) ? Optional.of(this.cheatSheetDock) : Optional.empty();
    }

    public Optional<UberfireDock> getCoverageReportDock(PlaceRequest placeRequest) {
        return Objects.equals(this.coverageDock.getPlaceRequest(), placeRequest) ? Optional.of(this.coverageDock) : Optional.empty();
    }
}

