/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.screens.scenariosimulation.client.rightpanel;

import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLLIElement;
import elemental2.dom.HTMLUListElement;
import elemental2.dom.Node;
import java.util.Comparator;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.drools.scenariosimulation.api.model.ScenarioWithIndex;
import org.drools.workbench.screens.scenariosimulation.client.resources.i18n.ScenarioSimulationEditorConstants;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.CoverageScenarioListView;
import org.drools.workbench.screens.scenariosimulation.client.utils.ViewsProvider;

@Dependent
public class CoverageScenarioListPresenter
implements CoverageScenarioListView.Presenter {
    @Inject
    protected ViewsProvider viewsProvider;
    private HTMLUListElement scenarioList;

    @Override
    public void initScenarioList(HTMLUListElement scenarioList) {
        this.scenarioList = scenarioList;
    }

    @Override
    public void addScenarioGroup(ScenarioWithIndex scenarioWithIndex, List<String> decisions) {
        CoverageScenarioListView coverageScenarioListView = this.viewsProvider.getCoverageScenarioListView();
        coverageScenarioListView.setPresenter(this);
        coverageScenarioListView.setVisible(false);
        HTMLLIElement scenarioElement = coverageScenarioListView.getScenarioElement();
        coverageScenarioListView.getFaAngleRight().textContent = "  " + ScenarioSimulationEditorConstants.INSTANCE.decisionsEvaluated() + " " + scenarioWithIndex.getIndex() + ": " + scenarioWithIndex.getScenario().getDescription();
        scenarioElement.appendChild((Node)this.createDecisionList(decisions, coverageScenarioListView.getDecisionElement()));
        this.scenarioList.appendChild((Node)scenarioElement);
    }

    @Override
    public void clear() {
        while (this.scenarioList.firstChild != null) {
            this.scenarioList.removeChild(this.scenarioList.firstChild);
        }
    }

    protected HTMLUListElement createDecisionList(List<String> decisions, HTMLUListElement decisionGroup) {
        decisions.sort(Comparator.naturalOrder());
        for (String decision : decisions) {
            HTMLLIElement listElement = this.createDecisionLi();
            listElement.textContent = decision;
            decisionGroup.appendChild((Node)listElement);
        }
        return decisionGroup;
    }

    protected HTMLLIElement createDecisionLi() {
        HTMLLIElement decisionLi = (HTMLLIElement)DomGlobal.document.createElement("li");
        decisionLi.classList.add(new String[]{"list-group-item"});
        return decisionLi;
    }

    @Override
    public void onElementClick(CoverageScenarioListView coverageScenarioListView) {
        coverageScenarioListView.setVisible(!coverageScenarioListView.isVisible());
    }
}

